

<?php
// Error logging
ini_set('log_errors', 1);
ini_set('error_log', 'error.txt');

// Set the response header to accept JSON and specify the method allowed
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, mobileization');


include_once "../server/conn.php";
include "../server/controller.php";
include "../server/api_call.php";


date_default_timezone_set("Africa/Lagos");
// Get the input
$input = file_get_contents("php://input");

// Use fopen, fwrite, and fclose to write the data to a file
$file = fopen('strowallet.txt', 'a');
if ($file !== false) {
    fwrite($file, $input);
    fclose($file);
} else {
    error_log("Failed to open strowallet.txt for writing.");
}

$response = json_decode($input, true);

if (is_array($response) && isset($response["sessionId"])) {
    // Extracting fields from the webhook payload
    $sessionId = $response["sessionId"];
    $accountNumber = $response["accountNumber"];
    $tranRemarks = $response["tranRemarks"];
    $transactionAmount = $response["transactionAmount"];
    $settledAmount = $response["settledAmount"];
    $feeAmount = $response["feeAmount"];
    $vatAmount = $response["vatAmount"];
    $currency = $response["currency"];
    $initiationTranRef = $response["initiationTranRef"];
    $settlementId = $response["settlementId"];
    $sourceAccountNumber = $response["sourceAccountNumber"];
    $sourceAccountName = $response["sourceAccountName"];
    $sourceBankName = $response["sourceBankName"];
    $channelId = $response["channelId"];
    $tranDateTime = $response["tranDateTime"];

    $user_id = "";
    $sql = $conn->prepare("SELECT * FROM account WHERE acc_no = ?");
    $sql->bind_param("s", $accountNumber);
    $sql->execute();
    $res = $sql->get_result();
    if($res->num_rows < 1){
       error_log("no account found with this account no ".$accountNumber);
       echo "Fail";
       http_response_code(400);
       exit();
    }
    
    $row = $res->fetch_assoc();
    $user_id = $row['unique_id'];
    
    $user = Control::fetchDetail($conn, $user_id);
    if($user["status"] === false){
       error_log("no user found with this id ".$user_id);
       echo "Fail";
       http_response_code(400);
       exit();
    }

$settledAmount = $settledAmount - ($settledAmount *0.015);
    
    
    $updateBalance = Control::updateBalance($conn, $user_id, "credit", $settledAmount);
    if($updateBalance["status"] == false){
      error_log("Unable to credit user");
      echo "Unable to credit user";
      http_response_code(400);
      exit();
    }
    
    $generateId = Control::generateId("MB", 10);
    
    $description = "Wallet Funding of NGN ".number_format($settledAmount)." at charge 0f 1% Narration: ".$tranRemarks;
   
    $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Wallet Topup", $user["phone"], "Strowallet", "success", $user["bal"], $user["bal"] + $settledAmount, $settledAmount, "", $description, date("D d-M-Y h:i a"));
    if($insertTransaction["status"] !== true){
      error_log("Unable to insert transaction");
      echo "Unable to insert transaction";
      http_response_code(400);
      exit();
    }

if($user["sms"] == 'On'){
      $sender = "Teller";
    $bal = $user["bal"] + $settledAmount;
    $phoneNumbers = $user["phone"];
    $amt = number_format($settledAmount,2);
    $msg = "BUYPOINT CREDIT ALERT\n";
    $msg .= "Acc: $sourceAccountNumber\n";
    $msg .= "Amt: $settledAmount\n";
   // $msg .= "Desc: $tranRemarks\n";
    $msg .="Bal: $bal";
    

    $response = Api::buyBulkSms($conn, $sender, $phoneNumbers, $msg);
   if ($response["status"] === false) {
        error_log("Cannot send sms: " . $response);
        echo json_encode(["status" => false, "message" => "cannot send"]);
        http_response_code(400);
        exit();
    }
}  
    echo "success";
    http_response_code(200);
    exit();
    

} else {
    error_log("Webhook data was not received or lacked the sessionId field.");
    echo "Fail";
    http_response_code(400);
}
?>
