<?php
 session_start();
 include_once "../conn.php";
 if(!isset($_SESSION["user_id"])){
   header("Location: ../../log.php");
 }
 $unique_id = htmlspecialchars(mysqli_real_escape_string($conn, $_SESSION["user_id"]));
 if(!empty($_GET["reference"]) && !empty($_GET["1appref"])){
   $refrence = htmlspecialchars(mysqli_real_escape_string($conn, $_GET["reference"]));
   $trans_ref = htmlspecialchars(mysqli_real_escape_string($conn, $_GET["1appref"]));
   $ch = curl_init();
   curl_setopt_array($ch, array(
      CURLOPT_URL => "https://api.paystack.co/transaction/verify/$refrence",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_TIMEOUT => 30,
      CURLOPT_CUSTOMREQUEST => "GET", 
      CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "mobileization: Bearer sk_test_f61802103c335c7d8eb163e496a7b2e7f5758846",
        ),
     ));
     $reaponse = curl_exec($ch);
     $decode = json_decode($reaponse);
     if(!curl_error($ch)){
       if($decode->data->status == "success"){
         $amount = $decode->data->amount / 102;
         $sql2 = "SELECT * FROM transaction WHERE unique_id = ? AND trans_ref = ?";
         $stmt2 = $conn->prepare($sql2);
         $stmt2->bind_param("ss", $unique_id, $trans_ref);
         $stmt2->execute();
         $check = $stmt2->get_result();
         if($check->num_rows > 0){
           $row = $check->fetch_assoc();
           if($row["status"] === "success"){
             header("Location: ../service/dash.php");
             $stmt2->close();
             $output = "Transaction already completed";
           }else{
         $sql = "UPDATE regtable SET bal = bal + ? WHERE unique_id = ?";
         $stmt = $conn->prepare($sql);
         $stmt->bind_param("ss", $amount, $unique_id);
         if($stmt->execute()){
           $stmt->close();
           $success = $decode->data->status;
           $amount2 = (float)$amount;
           $sql3 = "UPDATE transaction SET status = ?, new_bal = old_bal + ? WHERE unique_id = ? AND trans_ref = ?";
           $stmt3 = $conn->prepare($sql3);
           $stmt3->bind_param("ssss", $success, $amount, $unique_id, $trans_ref);
           if($stmt3->execute()){ 
             $output = "
             <ion-icon name='checkmark-circle-outline'></ion-icon>
             <h3 style='color:rgba(0%, 70%, 0%);'>TRANSACTION APPROVED</h3>
             <table>
              <tr>
               <td>Trans ref</td>
               <td>{$trans_ref}</td>
              </tr>
              <tr>
               <td>Amount</td>
               <td>NGN {$amount}</td>
              </tr>
              <tr>
               <td>Date</td>
               <td>{$decode->data->paid_at}</td>
              </tr>
             </table>
             <div class='div'>
               <a href='../service/dash.php'><button>GO HOME</button></a>
             </div>
             ";
             $stmt3->close();
           }
         }else{
           $output = "Unable to update user balance pls contact us for verification with this reference {$refrence}";
         }
        }
        }
       }else{
         $output = "Wrong transaction initiated pls contact us for verification if any issue is involved";
       }
       
     }else{
       $output = "Server/network error there was an error connecting to server";
     }
  curl_close($ch);
 }else{
   $output = "
   <i class='fas fa-times-circle'></i><br>
   Invalid data recieved all data cannot be empty
   ";
 }
?>
<html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <title>Transaction Approval - 1App</title>
    <style>
      @import url('https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900&display=swap');
      body 
      {
        display: flex;
        justify-content: center;
        flex-direction: column;
        align-items: center;
        min-height: 30vh;
        font-family: 'poppins', Sans-Serif;
      }
      .box 
      {
        padding: 10px;
        width: 330px;
        background: #fff;
        border-radius: 6px;
        text-align: center;
        box-sizing: border-box;
        font-weight: 700;
        font-size: 13px;
      }
      .box ion-icon
      {
        text-align: center;
        margin-left: 0%;
        font-size: 65px;
        margin-bottom: 0px;
      }
      .box ion-icon[name="close-circle-outline"]
      {
        color: red;
      }
      .box ion-icon[name="checkmark-circle-outline"]
      {
        color: rgba(0%, 70%, 0%);
      }
      .box table 
      {
        width: 100%;
      }
      .box table tr
      {
        padding: 10px;
        height: 45px;
      }
      .box table tr:nth-child(odd)
      {
        background: hsl(0, 0%, 95%);
      }
      .box table tr td 
      {
        padding: 10px;
      }
      .box table tr td:nth-child(1)
      {
        text-align: left;
        font-size: 12px;
        font-weight: 700;
      }
      .box table tr td:nth-child(2)
      {
        text-align: right;
        font-weight: 400;
        font-size: 12px;
      }
      .box .div 
      {
        display: flex;
        justify-content: space-between;
        align-self: center;
        margin-top: 20px;
        box-sizing: border-box;
        width: 100%;
      }
      .box .div button 
      {
        padding: 10px;
        font-size: 12px;
        font-weight: 900;
        letter-spacing: 0px;
        color: #fff;
        background: rgba(67%, 0%, 42%);
        border: none;
        border-radius: 9px;
        height: 42px;
        width: 100%;
      }
    </style>
  </head>
  <body>
    <div class="box">
    <?php echo $output; ?>
    </div>
<script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
  </body>
</html>