<?php
// Error logging
ini_set('log_errors', 1);
ini_set('error_log', 'ncwallet.txt');

// Set the response header to accept JSON and specify the method allowed
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, mobileization');


include_once "../server/conn.php";
include "../server/controller.php";
include "../server/api_call.php";

date_default_timezone_set("Africa/Lagos"); 

// Get the input
$input = file_get_contents("php://input");

// Use fopen, fwrite, and fclose to write the data to a file
$file = fopen('ncwallet.txt', 'w');
if ($file !== false) {
    fwrite($file, $input);
    fclose($file);
} else {
    error_log("Failed to open ncwallet.txt for writing.");
}

$response = json_decode($input, true);

if (is_array($response) && isset($response["session_id"])) {
    // Extracting fields from the webhook payload
    $status = validate::validateString($conn, $response["status"]);
    $email = validate::validateString($conn, $response["email"]);
    $acc_no = validate::validateInt($conn, $response["account_number"]);
    $amount = validate::validateInt($conn, $response["settled_amount"]);
    $narration = validate::validateString($conn, $response["narration"]);

    $sql = $conn->prepare("SELECT * FROM account WHERE acc_no = ?");
    $sql->bind_param("s", $acc_no);
    $sql->execute();
    $res = $sql->get_result();

    if ($res->num_rows < 1) {
        error_log("No account found with this account number: " . $acc_no);
        echo json_encode(["status" => false, "message" => "Account not found"]);
        http_response_code(400);
        exit();
    }

    $row = $res->fetch_assoc();
    $user_id = $row['unique_id'];
    $user = Control::fetchDetail($conn, $user_id);

    if ($user["status"] === false) {
        error_log("No user found with this ID: " . $user_id);
        echo json_encode(["status" => false, "message" => "User not found"]);
        http_response_code(400);
        exit();
    }
    
    if($response["status"] !== "success"){
      error_log("Transaction failure");
      echo "Transaction failure";
      http_response_code(400);
      exit();
    }
    
    if((int)$amount > 999){
        $amount = (int)$amount - 50;
    }else{
        $amount = (int)$amount;
    }
    
    $updateBalance = Control::updateBalance($conn, $user_id, "credit", $amount);
    if($updateBalance["status"] == false){
      error_log("Unable to credit user");
      echo "Unable to credit user";
      http_response_code(400);
      exit();
    }
    
    $generateId = $response["ref_id"];
    
    $description = "Wallet Funding of NGN ".number_format($amount)." at charge 0f 1% Narration: ".$narration;
   
    $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Wallet Topup", $acc_no, "Providus Bank", "success", $user["bal"], $user["bal"] + $amount, $amount, "", $description, date("D d-M-Y h:i a"));
    if($insertTransaction["status"] !== true){
      error_log("Unable to insert transaction");
      echo "Unable to insert transaction";
      http_response_code(400);
      exit();
    }
    
    if($user["sms"] === 'On'){
        
     $sender = "Teller";
    $bal = $user["bal"] + $amount;
    $phoneNumbers = $user["phone"];
    $amt = number_format($amount,2);
    $msg = "A credit transaction occured on your account\n";
    $msg .= "Acc: $acc_no\n";
    $msg .= "Amt: $amount\n";
    $msg .= "Desc: $narration\n";
    $msg .="Bal: $bal\n";
    

    $response = Api::buyBulkSms($conn, $sender, $phoneNumbers, $msg);
   if ($response["status"] === false) {
        error_log("Cannot send sms: " . $response);
        echo json_encode(["status" => false, "message" => "cannot send"]);
        http_response_code(400);
        exit();
    }
    }
    
    echo "success";
    http_response_code(200);
    exit();
    

} else {
    error_log("Webhook data was not received or lacked the sessionId field.");
    echo "Fail";
    http_response_code(400);
}
?>
