<?php
 session_start();
 include "server/conn.php";
 include_once "server/controller.php";
 include_once "../server/controller.php";
 AdminControl::checkSession();
?>
<div class="topic"><i class="bi bi-headset"></i>Verification</div>
<?php
function all_verification($conn, $type){
    $stmt = $conn->prepare("SELECT * FROM verification ORDER BY id DESC");
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $res = $stmt->get_result();
    $outputs = "";
    if($res->num_rows > 0){
      while($row = $res->fetch_assoc()){
          if(strstr($row[$type], "_verify")){
            $user = Control::fetchDetail($conn, $row["unique_id"]);
            $outputs .= '
             <div class="user-design" id="'.$row["unique_id"].':verify-box" style="margin-bottom: 5px;">
               <div class="user-left">
                <h3>'.$user["fname"].' '.$user["lname"].'</h3>
                <h3>ID: '.$row["unique_id"].'</h3>
                <b>'.strtoupper($type).': '.trim(str_replace("_verifying", "", $row[$type])).'</b>
               </div>
               <button class="form-small-btn inline top-none" onclick="updateVerify(this, `'.$row["unique_id"].'`, `'.$type.'`, `reject`)">Reject</button>
               <button class="form-small-btn inline top-none blue" style="margin-left: 5px;" onclick="updateVerify(this, `'.$row["unique_id"].'`, `'.$type.'`, `accept`)">Accept</button>
             </div>
            ';
          }
      }
    }else{
      $outputs = '
       <div class="empty">
         <i class="bi bi-exclamation-circle"></i>
         <span>No pending '.$type.' approval yet</span>
       </div>
      ';
    }
    return $outputs;
}
?>
<div class="many-btns">
  <button class="form-small-btn do inline top-none ash active" onclick="changeTabs('.session-tab', 'bvn-bx', this, '.form-small-btn.do')">Bvn Verification</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'nin-inn-bx', this, '.form-small-btn.do')">Nin Verificaton</button>
</div>

<div id="bvn-bx" class="session-tab" style="display: block;">
  <div class="topic">All pending bvn approvals</div>
  <div class="gird">
   <?php echo all_verification($conn, "bvn"); ?>
  </div>
</div>
<div id="nin-inn-bx" class="session-tab" style="display: none;">
  <div class="topic">All pending nin approvals</div>
  <div class="gird">
   <?php echo all_verification($conn, "nin"); ?>
  </div>
</div>