<?php
session_start();
header("Content-Type: application/json");
include "conn.php";
include_once "controller.php";
include_once "../../server/controller.php";
AdminControl::checkSession();

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    echo "Invalid server request method only post method allowed";
    exit();
}

$admin_id = $_SESSION["admin_id"];

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data["user_id"])) {
    echo "Invalid request sent check and try again";
    exit();
} 

$user_id = validate::validateString($conn, $data["user_id"]);

$user = Control::fetchDetail($conn, $user_id);
if ($user["status"] === false) {
    echo $user["msg"];
    exit(); 
}

$acc_nos = "";

 $sql = $conn->prepare("SELECT * FROM account WHERE unique_id = ? ORDER BY id DESC");
 $sql->bind_param("s", $user_id);
 $sql->execute();
 $res = $sql->get_result();
 $count = 0; 
 if($res->num_rows > 0){
   while($row = $res->fetch_assoc()){
      $count++;
      $acc_nos .= '
        <div class="acc-detail"> 
           <i class="bi bi-bank a-d-icon"></i>
           <div>
              <b class="a-d-bank">'.$row["bank_name"].' - <b>'.$row["acc_name"].'</b></b>
              <span class="a-d-no">'.$row["acc_no"].' <i class="bi bi-copy" onclick="copyTxt('.$row["acc_no"].')"></i></span>
              <span class="a-d-no-small">'.$row["bank_name"].' charges 0.5% on every deposit</span>
           </div>
       </div>
      ';
  }
}else{
      $acc_nos = '
        <div class="empty">
          <i class="bi bi-info-circle"></i>
          <b>No account generated yet</b>
        </div>
      ';
  
}


   $trx = '';
   $sql5 = $conn->prepare("SELECT * FROM transaction WHERE unique_id = ? ORDER BY id DESC");
   $sql5->bind_param("s", $user["unique_id"]);
   $sql5->execute();
   $result5 = $sql5->get_result();
   if($result5->num_rows > 0){
     while($row = $result5->fetch_assoc()){
       $status = $row["status"];
       $clr = "";
       if($status == "Success" || $status == "success"){
         $clr = "green";
       }else if($status == "Failed" || $status == "failed"){
         $clr = "red";
       }else if($status == "Pending" || $status == "pending"){
         $clr = "orange";
       }
       $trx .= '
       <a href="../reciept.php?user_id='.$row["unique_id"].'&ref='.$row["reference"].'"><div class="tr-design" style="box-sizing: border-box;word-break: break-word; margin-bottom: 10px;">
         <div class="tr-left">
           <h3>'.$row["type"].'</h3>
           <span>'.$row["description"].'</span>
         </div>
         <div class="tr-right">
          <b class="status '.$clr.'">'.$row["status"].'</b>
          <b>NGN '.number_format($row["amount"], 2).'</b>
          <b>'.$row["date"].'</b>
         </div>
       </div></a>
       ';
     }
   }else{
     $trx = '
      <div class="empty">
       <i class="bi bi-exclamation-circle"></i>
       <b>No transaction made yet</b>
      </div>
     ';
   }



$un = "";
if($user["status"] === "BAN" || $user["status"] === "RESTRICTED"){
    $un = '
     <button class="form-small-btn inline green" onclick="takeAction(`'.$user["unique_id"].'`, `VERIFIED`)">UN-'.$user["status"].' Account</button>
    ';
}

   $nm = '
          <tr>
            <th>First Name</th>
            <td>'.$user["fname"].'</td>
          </tr>
          <tr>
            <th>Last Name</th>
            <td>'.$user["lname"].'</td>
          </tr>
   ';

echo '
<div class="user-form" id="'.$user["id"].':close-page">
  <div class="user-form-inner">
     <div class="user-topic">
       <span class="topic">'.$user["fname"].' Personal Information</span>
       <button onclick="closeUserPage(`'.$user["id"].':close-page`)">close</button>
     </div>

     <div class="table-container">
       <table class="styled-table">
          <tr>
            <th>User Id</th>
            <td>'.$user["unique_id"].'</td>
          </tr>
          '.$nm.'
          <tr>
            <th>Email</th>
            <td>'.$user["email"].'</td>
          </tr>
          <tr>
            <th>Phone</th>
            <td>'.$user["phone"].'</td>
          </tr>
          <tr>
            <th>Gender</th>
            <td>'.(!empty($user["gender"]) ? $user["gender"] : "<i>NOT ADDED</i>").'</td>
          </tr>
          <tr>
            <th>Address</th>
            <td>'.(!empty($user["address"]) ? $user["address"] : "<i>NOT ADDED</i>").'</td>
          </tr>
          <tr>
            <th>State</th>
            <td>'.(!empty($user["state"]) ? $user["state"] : "<i>NOT ADDED</i>").'</td>
          </tr>
          <tr>
            <th>City</th>
            <td>'.(!empty($user["city"]) ? $user["city"] : "<i>NOT ADDED</i>").'</td>
          </tr>
          <tr>
            <th>Password</th>
            <td>'.$user["password"].'</td>
          </tr>
          <tr>
            <th>Balance</th>
            <td>'.$user["bal"].'</td>
          </tr>
          <tr>
            <th>PIN</th>
            <td>'.$user["pin"].'</td>
          </tr>
          <tr>
            <th>Api Key</th>
            <td>'.$user["api_key"].' <i class="bi bi-copy" style="margin-left: 20px; font-size: 16px; color: green;" onclick="copyTxt(`'.$user["api_key"].'`)"><small style="font-size: 12px;">copy</small></i></td>
          </tr>
          <tr>
            <th>Level</th>
            <td>'.$user["level"].'</td>
          </tr>
          <tr>
            <th>Status</th>
            <td>'.$user["status"].'</td>
          </tr>
       </table>
     </div>
     
     <div style="margin-bottom: 30px;">
         <div class="form-topic" style="margin-bottom: 10px;">Take Action</div>
         <button class="form-small-btn inline red" onclick="takeAction(`'.$user["unique_id"].'`, `BAN`)"><i class="bi bi-ban"></i>BAN</button>
         <button class="form-small-btn inline red" onclick="takeAction(`'.$user["unique_id"].'`, `RESTRICTED`)"><i class="bi bi-ban"></i>RESTRICT</button>
         '.$un.'
         
         <div class="form-topic"style="margin-bottom: 10px; margin-top: 35px;">Other Actions</div>
         <button class="form-small-btn inline red" onclick="deleteAccount(`'.$user["unique_id"].'`, `Delete`)"><i class="bi bi-trash"></i>Delete</button>
         <a href="edit-user.php?user='.$user["unique_id"].'"><button class="form-small-btn inline blue">Edit details</button></a>
     </div>
     
     <div class="sps">
       <div class="form-topic">Reserved Account</div>
       '.$acc_nos.'
     </div>
     
     <div class="sps" style="margin-top: 30px;">
       <div class="form-topic">Transactions</div>
       '.$trx.'
     </div>
  </div>
</div>
';
?>

<style>
.sps{
  margin-top: 10px;
  margin-bottom: 10px;
}
  /* Container to make the table scrollable */
  .user-form {
      max-height: 100vh; /* or any height you prefer */
      overflow-y: auto; /* Enables vertical scrolling */
  }
  
  .table-container {
      overflow: hidden;
      margin-top: 10px;
      box-sizing: border-box;
      word-break: break-word;
      letter-spacing: 0.5px;
  }

  /* Style the table */
  .styled-table {
      border-collapse: collapse;
      margin: 25px 0;
      font-size: 0.9em;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
  }

  .styled-table th,
  .styled-table td {
      padding: 12px 15px;
      text-align: left;
      border-bottom: 1px solid #ddd;
      font-size: 11px;
  }

  .styled-table th {
      background-color: #fff;
      color: #444;
      letter-spacing: 0.5px;
      width: 100px;
  }

  .styled-table tr {
      color: #000;
      background: #fff;
  }

  .styled-table td i {
      color: #999;
  }
      .acc-detail{
        display: flex; 
        align-items: center; 
        min-height: 70px; 
        background: #fff; 
        border-radius: 5px;
        box-sizing: border-box;
        width: 100%; 
        padding: 10px;
        margin: 0;
        margin-top: 10px;
        box-shadow: 0 1px 1px 0 #0002;
    }
    .a-d-icon{
        display: flex;
        height: 30px;
        width: 30px;
        background: transparent;  
        border-radius: 50%; 
        border: none; 
        justify-content: center; 
        align-items: center;
        color: var(--site-clr);
        margin-right: 10px;
        box-sizing: border-box;
    }
    .a-d-bank{ 
        display: block;
        font-size: 10px;
        font-weight: 300;
        margin: 0;
        color: #555;
        margin-bottom: 6px;
        line-height: 13px;
    }
    .a-d-bank b{
        font-weight: 900;
        color: #000;
    }
    .a-d-no{
        display:block; 
        font-size: 11px;
        font-weight: 900;
        color: #000;
        margin: 0;
        margin-bottom: 6px;
        letter-spacing: 0.4px;
    }
    .a-d-no i{
        font-size: 14px;
        color: var(--site-clr);
        margin-left: 12px;
    }
    .a-d-no-small{
        display:block; 
        font-size: 7px;
        font-weight: 300;
        margin: 0;
        letter-spacing: 0.4;
    }
</style>