<?php
 session_start();
 include "conn.php";
 include_once "controller.php";
 include_once "../../server/controller.php";
 require "../../server/mail.php";
 
 AdminControl::checkSession();
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo "Invalid server request method";
     exit();
 }
 
 $user_id = validate::validateString($conn, $_POST["user_id"]);
 $type = validate::validateString($conn, $_POST["type"]);
 $status = validate::validateString($conn, $_POST["status"]);
 
 $user = Control::fetchDetail($conn, $user_id);
 if($user["status"] === false){
     echo $user["msg"];
     exit();
 }
 
 $checkV = Control::fetchVerification($conn, $user_id);
 
 $site = Control::site($conn);
 
 $new = "";
 $txtMsg = "";
 if($status == "accept"){
     $new = trim(str_replace("_verifying", "", $checkV[$type]));
     $txtMsg = "
     We are pleased to inform you that your BVN verification request, associated with BVN number ['.$new.'], has been successfully approved.
     
     <table>
         <tr>
           <td>Bank Verification Number(BVN)</td>
           <td><b>'.$new.'</b></td>
         </tr>
     </table>
     
     Your BVN/NIN is now fully verified, and you can proceed with utilizing our services without any restrictions.
     <pre></pre>

     If you have any questions or need further assistance, please feel free to reach out to our support team at [".$site["support_email"]."].
     <pre></pre>

     Thank you for choosing ".$site["site_name"].". We are committed to providing you with the best service experience.
     <pre></pre>

     Best regards.
     ";
     
     $lv = "level-2";
     $update = $conn->prepare("UPDATE regtable SET level = ? WHERE unique_id = ?");
     $update->bind_param("ss", $lv, $user_id);
     $update->execute();
 }else{
     $new = trim(str_replace("_verifying", "_rejected", $checkV[$type]));
     $txtMsg = '
     I hope this message finds you well.
     <pre></pre>
     
     We regret to inform you that your recent BVN verification request, associated with BVN/NIN number ['.trim(str_replace("_verifying", "", $checkV[$type])).'], has been rejected. This decision was made after a careful review of the details provided.
     <pre></pre>
     
     If you believe this rejection was made in error or you have additional documentation that may assist in verifying your BVN, please feel free to submit a new request or contact our support team at <a href="mail: '.$site["support_email"].'">'.$site["support_email"].'</a>.
     <pre></pre>
     
     We apologize for any inconvenience this may have caused and appreciate your understanding.
     <pre></pre>

     Thank you for your cooperation.<br>
    
     Best regards.
      ';
 }
 
 $update = AdminControl::updateVerification($conn, $user_id, $type, $new);
 echo $update["msg"];

$msg = '
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Document</title>
  <link href="https://fonts.googleapis.com/css2?family=Mitr:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    *{
      box-sizing: border-box;
      font-family: "Mitr", Sans-Serif;
    }
    .head{
      background: rgba(70%, 0%, 40%);
      height: 120px;
      color: #fff;
      display: grid;
      grid-template-column: repeat(1, 1fr);
      flex-direction: column;
      padding: 10px;
    }
    .head img{
      width: 90px;
      height: 70px;
      display: block;
    }
    .head b{
      font-size: 22px;
      font-weight: 900;
      display: block;
      margin-top: 0px;
    }
    .bottom{
      background: rgba(70%, 0%, 40%);
      height: 50px;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .bottom i{
      margin-left: 10px;
      margin-right: 10px;
      font-size: 18px;
    }
    .body{
      padding: 15px;
      background: #0002;
    }
    .scam-alert{
      font-size: 12px;
      color: #555;
    }
    .greet{
      font-size: 16px;
      font-weight: 900;
      color: #000;
      margin-bottom: 20px;
      display: block;
    }
    table{
      margin: 0;
      margin-top: 15px;
      margin-bottom: 15px;
    }
    table tr{
      height: 25px;
      width: 100%;
      padding: 5px;
    }
    table tr td:nth-child(1){
      font-weight: 500;
      font-size: 13px;
      color: #000;
      width: 90px;
    }
    table tr td:nth-child(2){
      font-weight: 500;
      font-size: 13px;
      color: #777;
    }
  </style>
</head>
<body>
  <div class="head">
    <img src="https://'.$_SERVER["HTTP_HOST"].'/app/images/1724225088350-removebg-preview.png" alt="logo">
    <b>Account Verification</b>
  </div>
  <div class="body">
    <b class="greet">Dear, '.$user["fname"].'</b>
    
    <p>'.$txtMsg.'</p>
    
    <div class="scam-alert"><a href="https://'.$_SERVER["HTTP_HOST"].'/app/login.php">Login</a> your account now to purchase some of our services you can also reach out to us at <a href="mail: '.$site["support_email"].'">'.$site["support_email"].'</a>. Thank you for using '.$site["site_name"].'</div>
  </div>
  <div class="bottom">
    <i class="fab fa-facebook"></i>
    <i class="fab fa-whatsapp"></i>
    <i class="fab fa-instagram"></i>
  </div>
</body>
</html>
';

 sendOtpMail($conn, $user["unique_id"], $user["email"], "Account Verification", $msg, "Email notification send successfully");
?>