<?php
 session_start();
 include "conn.php";
 include_once "controller.php";
 include_once "../../server/controller.php";
 AdminControl::checkSession();
 
   if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo "Invalid server request method only post method allowed";
     exit();
   }
   $admin_id = $_SESSION["admin_id"];
   
   
   $site_name = validate::validateString($conn, $_POST["site-name"]);
   $site_logo = validate::validateString($conn, $_POST["site-logo"]);
   $site_url = validate::validateUrl($conn, $_POST["site-url"]);
   $phone = validate::validateString($conn, $_POST["phone"]);
   $smtp_email = validate::validateString($conn, $_POST["smtp-email"]);
   $smtp_username = validate::validateString($conn, $_POST["smtp-username"]);
   $smtp_password = validate::validateString($conn, $_POST["smtp-password"]);
   $smtp_host = validate::validateString($conn, $_POST["smtp-host"]);
   $info_email = validate::validateEmail($conn, $_POST["info-email"]);
   $hi_email = validate::validateEmail($conn, $_POST["hi-email"]);
   $support_email = validate::validateEmail($conn, $_POST["support-email"]);
   $whatsapp = validate::validateUrl($conn, $_POST["whatsapp"]);
   $whatsapp_group = validate::validateString($conn, $_POST["whatsapp-group"]);
   $facebook = validate::validateUrl($conn, $_POST["facebook"]);
   $twitter = validate::validateUrl($conn, $_POST["twitter"]);
   $instagram = validate::validateUrl($conn, $_POST["instagram"]);
   $telegram = validate::validateUrl($conn, $_POST["telegram"]);
   $referral_b = validate::validateInt($conn, $_POST["referral-bonus"]);
   $register_b = validate::validateInt($conn, $_POST["register-bonus"]);
   $site_color = validate::validateString($conn, $_POST["site-color"]);
   $site_bg = validate::validateString($conn, $_POST["site-background"]);
   
   $stmt = $conn->prepare("UPDATE site_setting SET site_name = ?, site_logo = ?, site_url = ?, phone = ?, smtp_email = ?, smtp_username = ?, smtp_password = ?, smtp_host = ?, info_email = ?, hi_email = ?, support_email = ?, whatsapp = ?, whatsapp_group = ?, facebook = ?, twitter = ?, instagram = ?, telegram = ?, referral_bonus = ?, register_bonus = ?, site_color = ?, site_background = ?");
   $stmt->bind_param("sssssssssssssssssssss", $site_name, $site_logo, $site_url, $phone, $smtp_email, $smtp_username, $smtp_password, $smtp_host, $info_email, $hi_email, $support_email, $whatsapp, $whatsapp_group, $facebook, $twitter, $instagram, $telegram, $referral_b, $register_b, $site_color, $site_bg);
   if($stmt->execute()){
     echo "Site settings updated successfully";
     exit();
   }else{
     echo "An error occurred we were unable to update site details";
     exit();
   }
?>