<?php
 session_start();
 include "conn.php";
 include_once "controller.php";
 include_once "../../server/controller.php";
 AdminControl::checkSession();
 
   if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo json_encode([
       "msg" => "Invalid server request method only post method allowed",
       ]);
     exit();
   }
   $admin_id = $_SESSION["admin_id"];
   
   if(!isset($_POST["title"]) || !isset($_POST["type"]) || !isset($_POST["message"]) || !isset($_POST["passkey"])){
     echo json_encode([
       "msg" => "Invalid request check and try again",
       ]);
     exit();
   }
   
   $title = validate::validateString($conn, $_POST["title"]);
   $type = validate::validateString($conn, $_POST["type"]);
   $msg = $_POST["message"];
   $passkey = validate::validateString($conn, $_POST["passkey"]);
   
   
   $check_passkey = AdminControl::verifyPasskey($conn, $admin_id, $passkey);
   if($check_passkey["status"] == false){
     echo json_encode([
       "msg" => $check_passkey["msg"],
       ]);
     exit();
   }
   
   $timer = "";
   $image_name = "";
   $status = "On";
   if($type === "timer"){
     $timer = validate::validateString($conn, $_POST["timer"]);
   }
   
   $tmpath = "";
   $file = $_FILES["image"];
   if(!empty($file)){
     if($file["error"] === UPLOAD_ERR_OK){
       $file_name = basename($file["name"]);
       $fileTmpPath = $file["tmp_name"];
       
       $image_name = uniqid("img_", true).'.'.pathinfo($file_name, PATHINFO_EXTENSION);
       
       $allowed = ["jpg", "jpeg", "png", "gif", "webp"];
       $upld_ex = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
       if(in_array($upld_ex, $allowed)){
         $tmpath = $fileTmpPath;
       }else{
         echo json_encode([
           "msg" => "Please select image jpg, jpeg, png, gif or webp",
           ]);
         exit();
       }
     }
   }
   
   
   $sql = "INSERT INTO notification (header, message, image, no_type, date, status) VALUES (?, ?, ?, ?, ?, ?)";
   $stmt = $conn->prepare($sql);
   $stmt->bind_param("ssssss", $title, $msg, $image_name, $type, $timer, $status);
   if($stmt->execute()){
     $get = AdminControl::checkIfNotificationExist($conn, $image_name);
     $img = "";
     if(!empty($get["data"][0]["image"])){
       $img = '<img src="../notify_images/'.$get["data"][0]["image"].'" alt="notification image" class="not-img">';
     }
     echo json_encode([
       "msg" => "Notification sent successful",
       "other" => '
      <div class="form-design table-form" id="'.$get["data"][0]["id"].':notify-box">
       <div class="table-bx space">
        <b>Header</b><span class="span left">'.$get["data"][0]["header"].'</span>
       </div>
       <div class="table-bx space">
        <b>Message</b><span class="span left">'.$get["data"][0]["message"].'</span>
       </div>
       <div class="table-bx space">
        <b>Type</b><span class="span left">'.$get["data"][0]["no_type"].' notification</span>
       </div>
       <div class="table-bx space">
        <b>Status</b>
        <span class="span left" style="display: inline; position: relative;" onclick="update_notification_status(`'.$get["data"][0]["id"].'`, `'.$get["data"][0]["id"].':notify-toggler`)">
            <span class="toggler-span active" id="'.$get["data"][0]["id"].':notify-toggler"></span>
            <span class="toggler" style="margin-top: 1px;"></span>
        </span>
       </div>
       '.$img.'
       <button class="form-small-btn inline" onclick="delete_notification(`'.$get["data"][0]["id"].'`)"><i class="bi bi-trash"></i>Delete</button>
       <button class="form-small-btn inline blue"><i class="bi bi-pencil"></i>Edit</button>
       <button class="form-small-btn inline green" onclick="copyTxt(`'.$get["data"][0]["message"].'`)"><i class="bi bi-copy"></i>Copy message</button>
      </div>
       ',
       ]);
     if(!empty($_FILES)){
       move_uploaded_file($tmpath, "../../notify_images/".$image_name);
     }
     exit();
   }else{
     echo json_encode([
       "msg" => "An error occurred we were unable to perform request",
       ]);
     exit();
   }
?>