<?php
 ini_set('display_errors', 1);
 ini_set('display_startup_errors', 1);
 error_reporting(E_ALL);
 
 session_start();
 include "conn.php";
 include_once "controller.php";
 include_once "../../server/controller.php";
 include_once "../../server/mail.php";
 AdminControl::checkSession();
 
  if($_SERVER["REQUEST_METHOD"] !== "POST"){
      echo "Invalid server request method";
      exit();
  }
  
  $admin_id = $_SESSION["admin_id"];
  
  if(!isset($_POST["topic"]) || !isset($_POST["header"]) || !isset($_POST["message"]) || !isset($_POST["passkey"])){
     echo "Invalid request sent check request and try again";
     exit();
   }
  
  $topic = validate::validateString($conn, $_POST["topic"]);
  $header = validate::validateString($conn, $_POST["header"]);
  $message = $_POST["message"];
  $passkey = $_POST["passkey"];
  
  $check_passkey = AdminControl::verifyPasskey($conn, $admin_id, $passkey);
  if($check_passkey["status"] == false){
    echo $check_passkey["msg"];
    exit();
  }
  
  $sql = $conn->prepare("SELECT * FROM regtable");
  $sql->execute();
  $res = $sql->get_result();
  $resp = "";
  if($res->num_rows > 0){
      while($row = $res->fetch_assoc()){
        $site = Control::site($conn);
        
        $msg = '
        <!DOCTYPE html>
        <html lang="en">
        <head>
          <meta charset="UTF-8">
          <meta name="viewport" content="width=device-width, initial-scale=1.0">
          <meta http-equiv="X-UA-Compatible" content="ie=edge">
          <title>Document</title>
          <link href="https://fonts.googleapis.com/css2?family=Mitr:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
          <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
          <style>
            *{
              box-sizing: border-box;
              font-family: "Mitr", Sans-Serif;
            }
            .head{
              background: rgba(10%, 0%, 50%);
              height: 120px;
              color: #fff;
              display: grid;
              grid-template-column: repeat(1, 1fr);
              flex-direction: column;
              padding: 10px;
            }
            .head img{
              width: 90px;
              height: 70px;
              display: block;
            }
            .head b{
              font-size: 22px;
              font-weight: 900;
              display: block;
              margin-top: 0px;
            }
            .bottom{
              background: rgba(10%, 0%, 50%);
              height: 50px;
              color: #fff;
              display: flex;
              justify-content: center;
              align-items: center;
            }
            .bottom i{
              margin-left: 10px;
              margin-right: 10px;
              font-size: 18px;
            }
            .body{
              padding: 15px;
              background: #0002;
            }
            .scam-alert{
              font-size: 12px;
              color: #555;
            }
            .greet{
              font-size: 16px;
              font-weight: 900;
              color: #000;
              margin-bottom: 20px;
              display: block;
            }
            table{
              margin: 0;
              margin-top: 15px;
              margin-bottom: 15px;
            }
            table tr{
              height: 25px;
              width: 100%;
              padding: 5px;
            }
            table tr td:nth-child(1){
              font-weight: 900;
              font-size: 14px;
              color: #000;
              width: 150px;
              padding-right: 40px;
            }
            table tr td:nth-child(2){
              font-weight: 300;
              font-size: 13px;
              color: #777;
            }
          </style>
        </head>
        <body>
          <div class="head">
            <img src="https://'.$_SERVER["HTTP_HOST"].'/app/images/1724225088350-removebg-preview.png" alt="logo">
            <b>'.$header.'</b>
          </div>
          <div class="body">
            <b class="greet">Hello, '.$row["fname"].'</b>
            
            <p>'.$message.'</p>
            
            <div class="scam-alert">This message was sent to <a href="mail: '.$row["email"].'">'.$row["email"].'</a> from '.$site["hi_email"].' '.$site["site_name"].' email <a href="https://'.$_SERVER["HTTP_HOST"].'/app/login.php">Login</a> your account now to purchase some of our services.</div>
          </div>
          <div class="bottom">
            <i class="fab fa-facebook"></i>
            <i class="fab fa-whatsapp"></i>
            <i class="fab fa-instagram"></i>
          </div>
        </body>
        </html>
        ';
        
        $sendMail = sendOtpMail($conn, $row["unique_id"], $row["email"], $topic, $msg, "Email notification send successfully");
        $resp = $sendMail["msg"];
      }
      echo $resp;
      exit();
  }else{
      echo "Unable to send mail cause site has no users yet";
      exit();
  }
?>