<?php
 session_start();
 include "conn.php";
 include_once "controller.php";
 include_once "../../server/controller.php";
 AdminControl::checkSession();
 
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $admin_id = $_SESSION["admin_id"];
   if(!isset($_POST["identification"]) || !isset($_POST["amount"]) || !isset($_POST["reason"]) || !isset($_POST["passkey"])){
     echo "Invalid request sent check request and try again";
     exit();
   }
   
   $identification = validate::validateString($conn, $_POST["identification"]);
   $amount = validate::validateInt($conn, $_POST["amount"]);
   $action = validate::validateString($conn, $_POST["action"]);
   $reason = validate::validateString($conn, $_POST["reason"]);
   $passkey = $_POST["passkey"];
   
   $user_check = Control::fetchDetail($conn, $identification);
   if($user_check["status"] == false){
     echo $user_check["msg"];
     exit();
   }
   
   $check_passkey = AdminControl::verifyPasskey($conn, $admin_id, $passkey);
   if($check_passkey["status"] == false){
     echo $check_passkey["msg"];
     exit();
   }
   
   $fund_user = Control::updateBalance($conn, $user_check["unique_id"], $action, $amount);
   if($fund_user["status"] == false){
     echo $fund_user["msg"];
     exit();
   }else{
     AdminControl::saveFundHistory($conn, $admin_id, $user_check["unique_id"], $amount, $reason);
     echo ''.$user_check["fname"].' Wallet has be successfully '.$action.'ed with NGN '.number_format($amount, 2).' for/as '.$reason;
     exit();
   }
 }
?>