<?php
session_start();
include "conn.php";
include_once "controller.php";
include_once "../../server/controller.php";

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set("display_errors", 1);

AdminControl::checkSession();

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    echo json_encode(["status" => false, "msg" => "Invalid request method. Only POST is allowed."]);
    exit();
}

// Validate if user_id is provided
if (!isset($_POST["user_id"]) || empty($_POST["user_id"])) {
    echo json_encode(["status" => false, "msg" => "Invalid request. User ID is missing or invalid."]);
    exit();
}

$admin_id = $_SESSION["admin_id"];
$user_id = validate::validateString($conn, $_POST["user_id"]);

// Fetch user details to ensure the user exists
$user = Control::fetchDetail($conn, $user_id);
if ($user["status"] === false) {
    echo json_encode(["status" => false, "msg" => $user["msg"]]);
    exit();
}

// Function to delete user records from a table
function deleteUser($table) {
    global $conn, $user_id;
    $query = "DELETE FROM `" . $table . "` WHERE unique_id = ?";
    $stmt = $conn->prepare($query);
    if (!$stmt) {
        error_log("Error preparing query for table $table: " . $conn->error);
        die(json_encode(["status" => false, "msg" => "Error with table $table: " . $conn->error]));
    }
    $stmt->bind_param("s", $user_id);
    if (!$stmt->execute()) {
        die(json_encode(["status" => false, "msg" => "Error executing query for table $table: " . $stmt->error]));
    }
    return true;
}

// Tables to delete user data from
$tables = ["account", "referral", "verification", "transaction", "regtable"];

// Attempt to delete user data from all tables
foreach ($tables as $table) {
    if (!deleteUser($table)) {
        echo json_encode(["status" => false, "msg" => "Failed to delete data from $table."]);
        exit();
    }
}

// Return success response
echo "User account deleted successfully";
?>