<?php
 session_start();
 header("Content-Type: application/json");
 include "conn.php";
 include_once "controller.php";
 include_once "../../server/controller.php";
 AdminControl::checkSession();
 
 $response = "";
   if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo "Invalid server request method only post method allowed";
     exit();
   }
   $admin_id = $_SESSION["admin_id"];
   $support_id = "admin_ID_478023941";
   
   $data = json_decode(file_get_contents("php://input"), true);
   
   if(!isset($data["chat_id"])){
     echo "Invalid request sent check and try again";
     exit();
   }
   
   $chat_id = validate::validateString($conn, $data["chat_id"]);
   $tr = false;
   
   $sql = $conn->prepare("SELECT * FROM message WHERE (sender = ? AND reciever = ?) OR (reciever = ? AND sender = ?)");
   $sql->bind_param("ssss", $support_id, $chat_id, $support_id, $chat_id);
   $sql->execute();
   $result = $sql->get_result();
   if($result->num_rows < 1){
     $tr = false;
   }else{
     $tr = true;
   }
   
   
   if($tr == true){
     while($row = $result->fetch_assoc()){
       if(!empty($row["image"])){
         $img_lnk = "../../chatimage/".$row["image"];
         if(file_exists($img_lnk)){
           unlink($img_lnk);
         }else{
           echo "An error occurred unable to delete session images";
           exit();
         }
       }
     }
   }
   
   $sql2 = $conn->prepare("DELETE FROM message WHERE (sender = ? AND reciever = ?) OR (reciever = ? AND sender = ?)");
   $sql2->bind_param("ssss", $support_id, $chat_id, $support_id, $chat_id);
   if(!$sql2->execute()){
     echo "An error occurred reload page and try again";
     exit();
   }
   
   
   $sql3 = $conn->prepare("DELETE FROM session WHERE session_id = ?");
   $sql3->bind_param("s", $chat_id);
   if($sql3->execute()){
     echo "Support session deleted successfully";
     exit();
   }else{
     echo "An error occurred reload page and try again";
     exit();
   }
?>