<?php
class AdminControl{
  public static function checkSession(){
    if(!isset($_SESSION["admin_id"])){
      header("Location: login.php");
      exit();
    }
  }
  
  
  public static function FetchDetails($conn, $admin_id){
    $response = array();
    $sql = "SELECT * FROM admin WHERE admin_id = ? OR email = ? OR phone = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $admin_id, $admin_id, $admin_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows > 0){
      $row = $res->fetch_assoc();
      return $row;
    }else{
      $response["status"] = false;
      $response["msg"] = "No Admin found with this id ".$admin_id."";
      return $response;
    }
  }
  
  
  public static function saveFundHistory($conn, $admin_id, $user_id, $amount, $reason){
    $response = array();
    
    $stmt = $conn->prepare("INSERT INTO adminfund (admin_id, identification, amount, reason) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $admin_id, $user_id, $amount, $reason);
    if($stmt->execute()){
      return "Fund history saved saved successful";
      exit();
    }else{
      return "Unable to save fund history";
      exit();
    }
  }
  
  
  public static function verifyPasskey($conn, $admin_id, $passkey){
    $response = array();
    
    $get_admin = Self::FetchDetails($conn, $admin_id);
    if($get_admin["status"] === false){
      $response["status"] = false;
      $response["msg"] = "Admin does not exist";
      return $response;
      exit();
    }
    
    $real_key = $get_admin["passkey"];
    if(password_verify($passkey, $real_key)){
      $response["status"] = true;
      $response["msg"] = "Admin passkey verified successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Incorrect admin passkey check and try again";
      return $response;
      exit();
    }
  }
  
  
  public static function getServiceStatus($conn, $service_id){
    $response = array();
    
    $stmt = $conn->prepare("SELECT * FROM services WHERE id = ?");
    $stmt->bind_param("s", $service_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows > 0){
      $row = $res->fetch_assoc();
      $response["status"] = true;
      $response["msg"] = "One service found successfully";
      $response["data"][] = $row;
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Service doesn't exist please try again if this was an error";
      return $response;
      exit();
    }
  }
  
  
  public static function updateServiceStatus($conn, $service_id, $new_status){
    $response = array();
    
    $stmt = $conn->prepare("UPDATE services SET status = ? WHERE id = ?");
    $stmt->bind_param("ss", $new_status, $service_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Status has be successfully turned ".$new_status;
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "There was an error updating status";
      return $response;
      exit();
    }
  }
  
  
  
  public static function checkIfApiExist($conn, $api_id){
    $response = array();
    
    $stmt = $conn->prepare("SELECT * FROM api WHERE id = ?");
    $stmt->bind_param("s", $api_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows > 0){
      $row = $res->fetch_assoc();
      $response["status"] = true;
      $response["msg"] = "One api found successful";
      $response["data"][] = $row;
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Invalid id send reload page and try again";
      return $response;
      exit();
    }
  }
  
  
  public static function updateApiDetails($conn, $api_id, $name, $contract_code, $public_key, $secret_key, $url){
    $response = array();
    
    $stmt = $conn->prepare("UPDATE api SET name = ?, contract_code = ?, public_key = ?, secret_key = ?, url = ? WHERE id = ?");
    $stmt->bind_param("ssssss", $name, $contract_code, $public_key, $secret_key, $url, $api_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Api details updated successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Unable to update api details try again later";
      return $response;
      exit();
    }
  }
  
  
  public static function offAllApiStatus($conn, $type){
    $response = array();
    
    $sts = "Off";
    $uppercase = strtoupper($type);
    $stmt = $conn->prepare("UPDATE api SET status = ? WHERE service = ?");
    $stmt->bind_param("ss", $sts, $uppercase);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "All ".$uppercase." api status off successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Unable to update api status try again later";
      return $response;
      exit();
    }
  }
  
  
  public static function updateApiStatus($conn, $api_id, $new_status){
    $response = array();
    
    $stmt = $conn->prepare("UPDATE api SET status = ? WHERE id = ?");
    $stmt->bind_param("ss", $new_status, $api_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Api status turned ".$new_status." successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Unable to update api status try again later";
      return $response;
      exit();
    }
  }
  
public static function checkIfNotificationExist($conn, $notify_id){
    $response = array();
    
    $stmt = $conn->prepare("SELECT * FROM notification WHERE id = ? OR image = ?");
    $stmt->bind_param("ss", $notify_id, $notify_id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows > 0){
      $row = $res->fetch_assoc();
      $response["status"] = true;
      $response["msg"] = "One notification found successfully";
      $response["data"][] = $row;
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Invalid notification id reload page and try again";
      return $response;
      exit();
    }
  }
  
  
public static function updateNotificationStatus($conn, $notify_id, $new_status){
    $response = array();
    
    $stmt = $conn->prepare("UPDATE notification SET status = ? WHERE id = ?");
    $stmt->bind_param("ss", $new_status, $notify_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Notification status turned ".$new_status." successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "Unable to update notification status try again later";
      return $response;
      exit();
    }
  }
  
  
  public static function insertNewApi($conn, $name, $contract_code, $service, $public_key, $secret_key, $url, $status){
    $response = array();
    
    $sql = "INSERT INTO api (name, contract_code, service, public_key, secret_key, url, status) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssss", $name, $contract_code, $service, $public_key, $secret_key, $url, $status);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "New api inserted successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "An error occurred unable to insert new api";
      return $response;
      exit();
    }
  }
  
  
  
  public static function updateService($conn, $id, $service_id, $name, $plan, $service, $amount, $validity, $status){
    $response = array();
    
    $sql = "UPDATE service_details SET service_id = ?, name = ?, plan = ?, service = ?, amount = ?, validity = ?, status = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssss", $service_id, $name, $plan, $service, $amount, $validity, $status, $id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Service plan details updated successfully, reload page to view updated details";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "An error occurred unable to update service plan details";
      return $response;
      exit();
    }
  }
  
  
  
  public static function updateId($conn, $id, $service, $provider_id, $provider, $ab, $status){
    $response = array();
    
    $sql = "UPDATE service_id SET service = ?, provider_id = ?, provider = ?, ab = ?, status = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssss", $service, $provider_id, $provider, $ab, $status, $id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "ID details updated successfully, reload page to view updated details";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "An error occurred unable to update ID details";
      return $response;
      exit();
    }
  }
  
  
  public static function insertNewService($conn, $service_id, $name, $plan, $service, $amount, $validity, $status){
    $response = array();
    
    $sql = "INSERT INTO service_details (service_id, name, plan, service, amount, validity, status) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssss", $service_id, $name, $plan, $service, $amount, $validity, $status);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "New service details inserted successfully, reload page to view the new plan details";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "An error occurred unable to insert new service details";
      return $response;
      exit();
    }
  }
  
  
  public static function deleteApi($conn, $api_id){
    $response = array();
    
    $stmt = $conn->prepare("DELETE FROM api WHERE id = ?");
    $stmt->bind_param("s", $api_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Api details deleted successfully";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "An error occurred unable to delete api";
      return $response;
      exit();
    }
  }
   
  
  public static function updateProfileDetails($conn, $admin_id, $type, $old_pass, $new_pass){
    $response = array();
    
    $fetchD = Self::FetchDetails($conn, $admin_id);
    if($fetchD["status"] === false){
      $response["status"] = false;
      $response["msg"] = $fetchD["msg"];
      return $response;
      exit();
    }
    
    if(!password_verify($old_pass, $fetchD["password"])){
      $response["status"] = false; 
      $response["msg"] = "Incorrect  old ".$type." try again";
      return $response;
      exit();
    }
    
    $stmt = $conn->prepare("UPDATE admin SET ".$type." = ? WHERE admin_id = ?");
    $stmt->bind_param("ss", $new_pass, $admin_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = "Admin ".$type." updated successful";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "There was an error updating ".$type;
      return $response;
      exit();
    }
  }
  
  
   public static function updateVerification($conn, $user_id, $type, $vValue){
    $response = array();
    
    $stmt = $conn->prepare("UPDATE verification SET ".$type." = ? WHERE unique_id = ?");
    $stmt->bind_param("ss", $vValue, $user_id);
    if($stmt->execute()){
      $response["status"] = true;
      $response["msg"] = $type." verification has be updated successfully.";
      return $response;
      exit();
    }else{
      $response["status"] = false;
      $response["msg"] = "There was an error updating ".$type." verification.";
      return $response;
      exit();
    }
  }
  
  
}
?>