<?php
 session_start();
 include "conn.php";
 include_once "controller.php";
 include_once "../../server/controller.php";
 AdminControl::checkSession();
 
   if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo "Invalid server request method only post method allowed";
     exit(); 
   }
   
   $admin_id = $_SESSION["admin_id"];
   
   if(!isset($_POST["firstname"]) || 
       !isset($_POST["lastname"]) ||
       !isset($_POST["role"]) || 
       !isset($_POST["email"]) ||
       !isset($_POST["phone"]) ||
       !isset($_POST["status"]) ||
       !isset($_POST["passkey"]) || 
       !isset($_POST["password"]) ||  
       !isset($_POST["permission"])){
     //echo invaid request if above is not sent to server
     echo "Invalid request check and try again";
     exit();
   }
   
   $fname = validate::validateString($conn, $_POST["firstname"]);
   $lname = validate::validateString($conn, $_POST["lastname"]);
   $role = validate::validateString($conn, $_POST["role"]);
   $email = validate::validateEmail($conn, $_POST["email"]);
   $phone = validate::validateInt($conn, $_POST["phone"]);
   $passkey = validate::validatePassword($conn, $_POST["passkey"]);
   $password = validate::validatePassword($conn, $_POST["password"]);
   $status = validate::validateString($conn, $_POST["status"]);
   $per = validate::validateString($conn, $_POST["permission"]);
   
   $sql = "SELECT * FROM admin WHERE email = ? OR phone = ?";
   $query = $conn->prepare($sql);
   $query->bind_param("ss", $email, $phone);
   $query->execute();
   $res = $query->get_result();
   if($res->num_rows > 0){
       echo "Admin with this email or phone number already exist";
       exit();
   }
   
   $admin_id = "ADMIN-".rand(time(), 9999);
   $acc_id = "ADMIN-".rand(time(), 9999);
   
   $sql2 = "INSERT INTO admin (firstname, lastname, admin_id, access_key, admin_role, admin_permission, phone, email, password, passkey, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
   $stmt2 = $conn->prepare($sql2);
   $stmt2->bind_param("sssssssssss", $fname, $lname, $admin_id, $acc_id, $role, $per, $phone, $email, $password, $passkey, $status);
   if($stmt2->execute()){
       echo "New admin account created successfully";
       exit();
   }else{
       echo "Something went wrong try again";
       exit();
   }
?>