<?php
  session_start();
  include "server/conn.php";
  include "server/controller.php";
  AdminControl::checkSession();
?>
<div class="topic"><i class="ri ri-notification-line"></i>Manage Notification</div>

<form class="form-design" id="notify-form" enctype="multipart/form-data">
  <div class="inputs">
    <span>Notification Title(<i>REQUIRED</i>)</span>
    <input type="text" name="title" id="title" placeholder="eg, Security Alert!!!" oninput="checkValue('title', 'title-err', 5, 'length', 'Invalid title minimum (5 letters)', '')">
    <b id="title-err"></b>
  </div>
  <div class="inputs">
    <span>Notification Type(<i>REQUIRED</i>)</span>
    <select name="type" id="type" onchange="checkValue('type', 'type-err', '', 'empty', 'Please select notification type', '')">
       <option value="">-- Select Type --</option>
       <option value="normal">Normal Notification "(No time required shows notification immediately)"</option>
       <option value="timer" disabled>Timer Notification "(choose time notification will appear on user dashboard)"</option>
    </select>
    <b id="type-err"></b>
  </div>
  <div class="inputs" id="timer-bx" style="display: none;">
    <span>Notification Timer</span>
    <select name="timer" id="timer" onchange="checkValue('timer', 'timer-err', '', 'empty', 'Please select timer', '')">
       <option value="">-- Select Type --</option>
       <option value="1-minute">1 Minutes</option>
       <option value="5-minute">5 Minutes</option>
       <option value="15-minute">15 Minutes</option>
       <option value="30-minute">30 Minutes</option>
       <option value="1-hour">1 hour</option>
       <option value="5-hours">5 hours</option>
       <option value="10-hours">10 hours</option>
       <option value="1-day">1 day</option>
       <option value="2-days">2 days</option>
       <option value="5-days">5 days</option>
    </select>
    <b id="timer-err"></b>
  </div>
  <div class="inputs">
    <span>Notification Message(<i>REQUIRED</i>)</span>
    <textarea type="text" name="message" id="message" oninput="checkValue('message', 'message-err', 15, 'length', 'Invalid message minimum (15 digits)', '')"></textarea>
    <b id="message-err"></b>
  </div>
  <div class="inputs">
    <span>Notification Image(<i>OPTIONAL</i>)</span>
    <input type="file" name="image" id="image" placeholder="eg, Security Alert!!!">
  </div>
  <div class="inputs">
    <span>Admin PassKey(<i>REQUIRED</i>)</span>
    <input type="password" name="passkey" id="passkey" placeholder="eg, Security Alert!!!" oninput="checkValue('passkey', 'passkey-err', 8, 'length', 'Invalid passkey minimum (8 digits)', '')">
    <b id="passkey-err"></b>
  </div>
  <button class="form-btn" type="button" onclick="send_notification()">SUBMIT</button>
</form>

<div class="topic" style="margin-top: 20px;"><i class="bi bi-clock"></i> Previous Notifications</div>
<div id="notify-inn">
<?php
 $stmt = $conn->prepare("SELECT * FROM notification ORDER BY id DESC");
 $stmt->execute();
 $res = $stmt->get_result();
 if($res->num_rows > 0){
   while($row = $res->fetch_assoc()){
     $img = "";
     $sts = "";
     if(!empty($row["image"])){
       $img = '<img src="../logos/logo.png'.$row["image"].'" alt="notification image" class="not-img">';
     }
     if($row["status"] === "On"){
       $sts = "active";
     }
     echo '
      <div class="form-design table-form" id="'.$row["id"].':notify-box">
       <div class="table-bx space">
        <b>Header</b><span class="span left">'.$row["header"].'</span>
       </div>
       <div class="table-bx space">
        <b>Message</b><span class="span left">'.$row["message"].'</span>
       </div>
       <div class="table-bx space">
        <b>Type</b><span class="span left">'.$row["no_type"].' notification</span>
       </div>
       <div class="table-bx space">
        <b>Status</b>
        <span class="span left" style="display: inline; position: relative;" onclick="update_notification_status(`'.$row["id"].'`, `'.$row["id"].':notify-toggler`)">
            <span class="toggler-span '.$sts.'" id="'.$row["id"].':notify-toggler"></span>
            <span class="toggler" style="margin-top: 1px;"></span>
        </span>
       </div>
       '.$img.'
       <button class="form-small-btn inline" onclick="delete_notification(`'.$row["id"].'`)"><i class="bi bi-trash"></i>Delete</button>
       <button class="form-small-btn inline blue"><i class="bi bi-pencil"></i>Edit</button>
       <button class="form-small-btn inline green" onclick="copyTxt(`'.$row["message"].'`)"><i class="bi bi-copy"></i>Copy message</button>
      </div>
     ';
   }
 }else{
   echo '
   <div class="empty">
     <i class="bi bi-exclamation-circle"></i>
     <span>No notification yet</span>
   </div>
   ';
 }
?>
</div>