<?php
 session_start();
 include_once "server/conn.php";
 include "../server/controller.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="../css/log-sign.css">
  <link rel="stylesheet" href="../css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="../css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Login || mBills</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('../css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
  </style>
</head>
<body>
   <div class="header">
    <i class="bi bi-arrow-left-square"></i>
    <b>Sign In</b>
    <span>Welcome back <?php echo $site["site_name"]; ?> admin, login your account securly</span>
  </div>
  
  <form class="form" id="log-in-form">
    <div class="inputs">
      <i class="bi bi-tag"></i>
      <input type="email" name="emailOrphone" id="emailOrphone" placeholder="Email">
    </div>
    <div class="inputs">
      <i class="bi bi-lock"></i>
      <input type="password" name="password" id="password" placeholder="Password">
      <i class="bi bi-eye"></i>
    </div>
    <div class="link-right">
      <a href="#">Forgotten password?</a>
    </div>
    <button type="submit" class="form-button"  id="submitBtn">Login</button>
  </form>
  
  <script>
  <?php include "../js/msg.js"; ?>
    const logInForm = document.getElementById("log-in-form");
    const submitBtn = document.getElementById("submitBtn");
    
    const email_or_phone = document.getElementById("emailOrphone");
    const password = document.getElementById("password");
    logInForm.addEventListener("submit", (e)=> {
      e.preventDefault();
      if(email_or_phone.value == "" || password.value == ""){
        email_or_phone.dispatchEvent(new Event("input"));
        password.dispatchEvent(new Event("input"));
      }else{
        showP(submitBtn);
        fetch("server/login.php", {
          method: "POST",
          body: new FormData(logInForm),
        })
        .then(response => response.text())
        .then(data => {
          removeP(submitBtn, 'Login');
          if(data.includes("successful")){
            showMessage("bi bi-check-circle", data, "suc");
            setTimeout(()=> {
              window.location = "dashboard.php";
            }, 2000);
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
    });
    function toggPass(thisId){
      if(thisId.checked){
        password.type = "text";
        confirmPassword.type = "text";
      }else{
        password.type = "password";
        confirmPassword.type = "password";
      }
    }
  </script>
</body>
</html>