
<?php
session_start();
include_once "server/conn.php";
include "../server/controller.php";

// Get site information
$site = Control::site($conn); // Ensure this returns site data

if (!$site) {
    echo "Site information could not be retrieved. Please check your database connection.";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
  <title>admin_login</title>
  <!-- Other meta tags and links -->
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Admin Login</title>

  <style>
    /* General reset */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Arial', sans-serif;
      background-color: #f4f4f9;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      flex-direction: column;
    }

    /* Success and Error message styling */
    .message {
      display: none;
      position: fixed;
      top: 20px;
      left: 50%;
      transform: translateX(-50%);
      padding: 10px 20px;
      border-radius: 5px;
      font-size: 16px;
      font-weight: bold;
      z-index: 1000;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      width: auto;
    }

    .success-message {
      background-color: #40b1f7;
      color: white;
    }

    .error-message {
      background-color: #ff4d4d;
      color: white;
    }

    .box {
      background-color: #fff;
      padding: 30px 40px;
      width: 100%;
      max-width: 420px;
      border-radius: 8px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      text-align: center;
    }

    .head {
      margin-bottom: 20px;
    }

    .head img {
      max-width: 120px;
      margin-bottom: 20px;
    }

    .head h2 {
      font-size: 28px;
      color: #333;
      margin-bottom: 8px;
      font-weight: bold;
    }

    .head p {
      font-size: 16px;
      color: #555;
      line-height: 1.5;
    }

    .inputs {
      margin-bottom: 20px;
    }

    .inputs span {
      display: block;
      color: #333;
      font-size: 14px;
      margin-bottom: 8px;
      font-weight: bold;
      text-align: left;
    }

    .inputs input {
      width: 100%;
      padding: 12px;
      border: 1px solid #ccc;
      border-radius: 5px;
      font-size: 16px;
      outline: none;
      transition: border-color 0.3s ease-in-out;
      box-sizing: border-box; /* Ensure padding is considered in the width */
    }

    .inputs input:focus {
      border-color: #40b1f7;
    }

    .password-wrapper {
      position: relative;
    }

    .link {
      text-align: right;
      margin-bottom: 25px;
    }

    .link a {
      color: #40b1f7;
      text-decoration: none;
      font-size: 14px;
    }

    .link a:hover {
      text-decoration: underline;
    }

    button {
      width: 100%;
      padding: 12px;
      background-color: #40b1f7;
      border: none;
      border-radius: 5px;
      color: #fff;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      transition: background-color 0.3s;
    }

    button:hover {
      background-color: #1a8bda;
    }

    /* Mobile-friendly styling */
    @media (max-width: 600px) {
      .box {
        padding: 20px;
        width: 90%;
      }
    }
  </style>
</head>
<body>
  <div id="successMessage" class="message success-message">
    Login Successful! Redirecting...
  </div>

  <div id="adminNotFound" class="message error-message">
    Admin not found.
  </div>

  <div id="incorrectLogin" class="message error-message">
    Login details incorrect.
  </div>

  <form class="box" id="log-in-form">
    <div class="head"
      <h2>Welcome Back to <?php echo isset($site["site_name"]) ? $site["site_name"] : 'Admin Dashboard'; ?></h2>
      <p>Secure login to your admin dashboard to manage all activities.</p>
    </div>

    <div class="inputs" id="emailOrphone:inputs">
      <span>Email or Phone Number</span>
      <input type="text" placeholder="info@fluterpay.ng" name="emailOrphone" id="emailOrphone" required>
    </div>

    <div class="inputs password-wrapper" id="password:inputs">
      <span>Password</span>
      <input type="password" placeholder="********" name="password" id="password" required>
    </div>

    <div class="link">
      <span><a href="forgot-password.php">Forgot your password?</a></span>
    </div>

    <button type="submit" id="submitBtn">LOG IN</button>
  </form>

  <script>
    // JavaScript to toggle password visibility
    function togglePasswordVisibility() {
      const passwordInput = document.getElementById("password");
      const toggleIcon = document.getElementById("togglePassword");

      if (passwordInput.type === "password") {
        passwordInput.type = "text";
        toggleIcon.classList.remove("fa-eye");
        toggleIcon.classList.add("fa-eye-slash");
      } else {
        passwordInput.type = "password";
        toggleIcon.classList.remove("fa-eye-slash");
        toggleIcon.classList.add("fa-eye");
      }
    }

    // Show the success message
    function showSuccessMessage(message) {
      const successMessage = document.getElementById("successMessage");
      successMessage.textContent = message;
      successMessage.style.display = "block";
      setTimeout(() => {
        successMessage.style.display = "none";
      }, 3000);
    }

    // Show the error message
    function showErrorMessage(message, type) {
      const errorMessage = document.getElementById(type);
      errorMessage.textContent = message;
      errorMessage.style.display = "block";
      setTimeout(() => {
        errorMessage.style.display = "none";
      }, 3000);
    }

    // Form submission handling
    const logInForm = document.getElementById("log-in-form");
    logInForm.addEventListener("submit", function (e) {
      e.preventDefault();
      const emailOrPhone = document.getElementById("emailOrphone").value;
      const password = document.getElementById("password").value;

      if (emailOrPhone && password) {
        const submitBtn = document.getElementById("submitBtn");
        submitBtn.textContent = "Logging in...";

        fetch("server/login.php", {
          method: "POST",
          body: new FormData(logInForm),
        })
        .then(response => response.text())
        .then(data => {
          if (data.includes("successful")) {
            showSuccessMessage("Login Successful! Redirecting...");
            setTimeout(() => {
              window.location = "dashboard.php";
            }, 2000);
          } else if (data.includes("Admin not found")) {
            showErrorMessage("Admin not found.", "adminNotFound");
            submitBtn.textContent = "LOG IN";
          } else if (data.includes("Incorrect details check and try again")) {
            showErrorMessage("Login details incorrect.", "incorrectLogin");
            submitBtn.textContent = "LOG IN";
          } else {
            showErrorMessage("incorrect login details.", "incorrectLogin");
            submitBtn.textContent = "LOG IN";
          }
        })
        .catch(error => {
          showErrorMessage("Error: " + error, "incorrectLogin");
          submitBtn.textContent = "LOG IN";
        });
      } else {
        showErrorMessage("Please fill in all fields.", "incorrectLogin");
      }
    });
  </script>
</body>
</html>