<?php 
include "server/conn.php";
include "../server/controller.php";

$site = Control::site($conn);

function countTotal($conn, $tableName){
  $stmt = $conn->prepare("SELECT COUNT(*) as total FROM ".$tableName);
  $stmt->execute();
  $result = $stmt->get_result();
  $fetch = $result->fetch_assoc();
  return $fetch["total"];
}

function sumTotal($conn, $tableName, $toCount){
  $stmt = $conn->prepare("SELECT *, SUM(".$toCount.") as totalsum FROM ".$tableName);
  $stmt->execute();
  $result = $stmt->get_result();
  $fetch = $result->fetch_assoc();
  return (!empty($fetch["totalsum"]) ? number_format($fetch["totalsum"], 2) : "0");
}

function sumTransactionAmount($conn) {
    $stmt = $conn->prepare("SELECT SUM(amount) as totalAmount FROM transaction");
    $stmt->execute();
    $result = $stmt->get_result();
    $fetch = $result->fetch_assoc();
    return (!empty($fetch["totalAmount"]) ? number_format($fetch["totalAmount"], 2) : "0");
}

// Determine greeting based on time
$hour = date("H");
if ($hour >= 5 && $hour < 12) {
    $greeting = "Good Morning";
    $greetingIcon = "bi bi-sun"; // Sun icon for morning
} elseif ($hour >= 12 && $hour < 17) {
    $greeting = "Good Afternoon";
    $greetingIcon = "bi bi-sun"; // Sun icon for afternoon
} elseif ($hour >= 17 && $hour < 22) {
    $greeting = "Good Evening";
    $greetingIcon = "bi bi-moon"; // Moon icon for evening
} else {
    $greeting = "Good Night";
    $greetingIcon = "bi bi-moon"; // Moon icon for night
}
?>
<div class="topic"><i class="<?php echo $greetingIcon; ?>"></i><?php echo $greeting; ?>, <?php echo $admin["firstname"]; ?></div>
<div class="grid two bottom">
  <div class="home-c">
    <i class="bi bi-person"></i>
    <h3>Total Users</h3>
    <b><?php echo countTotal($conn, "regtable"); ?></b>
  </div>
  <div class="home-c">
    <i class="bi bi-wallet"></i>
    <h3>Total Users Funds</h3>
    <b><?php echo sumTotal($conn, "regtable", "bal"); ?></b>
  </div>
  <div class="home-c">
    <i class="bi bi-credit-card"></i>
    <h3>Total Transactions</h3>
    <b><?php echo countTotal($conn, "transaction"); ?></b>
  </div>
  <div class="home-c">
    <i class="bi bi-share"></i>
    <h3>Total Referrals</h3>
    <b><?php echo countTotal($conn, "referral"); ?></b>
  </div>
  <div class="home-c">
    <i class="bi bi-tools"></i>
    <h3>Total Services</h3>
    <b><?php echo countTotal($conn, "services"); ?></b>
  </div>
  <div class="home-c">
    <i class="bi bi-currency-dollar"></i>
    <h3>Total Transaction Amount</h3>
    <b><?php echo sumTransactionAmount($conn); ?></b>
  </div>
  <div class="home-c">
    <i class="bi bi-bell"></i>
    <h3>Total Notification</h3>
    <b><?php echo countTotal($conn, "notification"); ?></b>
  </div>
  <div class="home-c">
    <i class="bi bi-shield-lock"></i>
    <h3>Total Admin</h3>
    <b><?php echo countTotal($conn, "admin"); ?></b>
  </div>
  
    </div>
<div class="form-design bottom">
  <div class="form-topic">Site Link</div>
  <span class="form-small-text"><?php echo $site["site_url"]; ?></span>
  <button class="form-small-btn inline" onclick="copyTxt('<?php echo $site["site_url"]; ?>')">Copy <i class="bi bi-copy"></i></button>
  <button class="form-small-btn inline">Visit <i class="bi bi-globe"></i></button>
</div>
<div class="form-design bottom">
  <div class="form-topic">Site Name</div>
  <span class="form-small-text"><?php echo $site["site_name"]; ?></span>
  <button class="form-small-btn" onclick="copyTxt('<?php echo $site["site_name"]; ?>')">Copy <i class="bi bi-copy"></i></button>
</div>