<?php
session_start();
include "server/conn.php";
include_once "../server/controller.php";
include_once "server/controller.php";
AdminControl::checkSession();
?>
<div class="topic"><i class="bi bi-plus-circle"></i>Fund User</div>

<form class="form-design" id="fund_form">
  <div class="form-topic">Please fill all fields to fund user accounts securely</div>
  
  <div class="inputs">
    <span>Email / Phone Number / User ID</span>
    <input type="text" name="identification" id="identification" placeholder="jhondoe@gmail.com" oninput="checkValue('identification', 'identification-err', '', 'empty', 'Invalid Email, phone number or user id', '')">
    <b id="identification-err"></b>
  </div>
  
  <div class="inputs">
    <span>Amount</span>
    <input type="number" name="amount" id="amount" placeholder="1000" oninput="checkValue('amount', 'amount-err', 50, 'value', 'Invalid amount minimum(NGN 50)', '')">
    <b id="amount-err"></b>
  </div>
  
  <div class="inputs">
    <span>Action</span>
    <select name="action" id="action" placeholder="1000" onchange="checkValue('action', 'action-err', '', 'empty', 'Please select action', '')">
        <option value="">-- Select Action --</option>
        <option value="debit">Debit</option>
        <option value="credit">Credit</option>
    </select>
    <b id="action-err"></b>
  </div>
  
  <div class="inputs">
    <span>Reason</span>
    <textarea type="text" name="reason" id="reason" oninput="checkValue('reason', 'reason-err', 5, 'length', 'Minimum letters required is 5', '')"></textarea>
    <b id="reason-err"></b>
  </div>
  
  <div class="inputs">
    <span>Admin Passkey</span>
    <input type="password" name="passkey" id="passkey" placeholder="***********" oninput="checkValue('passkey', 'passkey-err', 8, 'length', 'Invalid passkey', '')">
    <b id="passkey-err"></b>
  </div>
  
  <button class="form-btn" type="button" onclick="trigger_fund()">SUBMIT</button>
</form>

<div class="topic" style="margin-top: 20px;"><i class="bi bi-clock"></i>Previously funded users</div>
<div class="grid" id="fund-grid">
  <?php
  $stmt = $conn->prepare("SELECT * FROM adminfund ORDER BY id DESC");
  $stmt->execute();
  $result = $stmt->get_result();
  if($result->num_rows > 0){
    while($row = $result->fetch_assoc()){
      $get_user = Control::fetchDetail($conn, $row["identification"]);
      $get_admin = AdminControl::FetchDetails($conn, $row["admin_id"]);
      echo '
      <div class="table-form" id="'.$row["id"].':previous-notification">
        <div class="table-bx">
          <b>Admin: </b>
          <span class="span left">'.$get_admin["firstname"].' '.$get_admin["lastname"].'</span>
        </div>
        <div class="table-bx">
          <b>User: </b>
          <span class="span left">'.$get_user["fname"].' '.$get_user["lname"].'</span>
        </div>
        <div class="table-bx">
          <b>Amount: </b>
          <span class="span left">&#x20a6;'.number_format($row["amount"], 2).'</span>
        </div>
        <div class="table-bx">
          <b>Reason: </b>
          <span class="span left">'.$row["reason"].'</span>
        </div>
      </div>
      ';
    }
  }else{
    
  }
  ?>
</div>