<?php
 include "server/conn.php";
 include "../server/controller.php";
 
 if(!isset($_GET["user"]) && !isset($_POST["user"])){
   header("Location: dashboard.php");
   exit();
 }
 
 $user_id = (isset($_GET["user"]) ? $_GET["user"] : $_POST["user"]);
 
 $user = Control::fetchDetail($conn, $user_id);
 if($user["status"] === false){
   header("Location: dashboard.php");
   exit();
 }
 
 if($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["update"])){
   $fname = validate::validateString($conn, $_POST["firstname"]);
   $lname = validate::validateString($conn, $_POST["lastname"]);
   $email = validate::validateString($conn, $_POST["email"]);
   $phone = validate::validateInt($conn, $_POST["phone"]);
   $gender = validate::validateString($conn, $_POST["gender"]);
   $address = validate::validateString($conn, $_POST["address"]);
   $state = validate::validateString($conn, $_POST["state"]);
   $city = validate::validateString($conn, $_POST["city"]);
   $pass = validate::validatePassword($conn, $_POST["password"]);
   $pin = validate::validateString($conn, $_POST["pin"]);
   $data_disc = validate::validateString($conn, $_POST["data-discount"]);
   
   $sql = $conn->prepare("UPDATE regtable SET fname = ?, lname = ?, email = ?, phone = ?, gender = ?, address = ?, state = ?, city = ?, password = ?, pin = ?, data_discount = ? WHERE unique_id = ?");
   $sql->bind_param("ssssssssssss", $fname, $lname, $email, $phone, $gender, $address, $state, $city, $pass, $pin, $data_disc, $user_id);
   if($sql->execute()){
     echo '
       <script>
         alert("User profile update successful");
       </script>
     ';
   }else{
     echo '
       <script>
         alert("Unable to update user profile");
       </script>
     ';
   }
 }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="../css/fontawsome/css/all.min.css">
  <title>Document</title>
  <style>
   @font-face {
      font-family: 'Mitr';
      src: url('../css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
  body{
    background: #0001;
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
  }
  *{
    box-sizing: border-box;
    font-family: "Mitr", Sans-Serif;
  }
  .head{
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: #fff;
    height: 55px;
    background: #fff;
    display: flex;
    align-items: center;
    padding: 20px;
  }
  .head i{
    margin-right: 30px;
  }
  .head b{
    font-size: 13px;
    font-weight: 900;
    color: #444;
  }
    .form{
      display: block;
      margin: 0;
      width: 95%;
      background: #fff;
      border-radius: 7px;
      padding: 18px;
    }
    .grid{
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      grid-column-gap: 15px;
    }
    .inputs{
      display: block;
      margin: 0;
      margin-bottom: 10px;
    }
    .inputs span{
      font-size: 11px;
      display: block;
      margin: 0;
      margin-bottom: 3px;
      color: #555;
      font-weight: 100;
    }
    .inputs input{
      background: #fff;
      border: 1px solid #0006;
      height: 35px;
      border-radius: 6px;
      display: Block;
      margin: 0;
      width: 100%;
      padding: 10px;
    }
    .inputs input::placeholder{
      color: #0005;
    }
    .button i{
      margin-right: 10px;
    }
    .button{
      padding: 10px;
      background: #000;
      color: #fff;
      font-size: 11px;
      height: 42px;
      border: none;
      outline: none;
      border-radius: 6px;
      margin-top: 25px;
      min-width: 100px;
    }
    h3{
      font-weight: 900;
      display: block;
      margin: 0;
      margin-bottom: 30px;
      font-size: 16px;
      color: #666;
    }
  </style>
</head>
<body>
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <b> Edit Details</b>
  </div>
  <pre>
  </pre>
  
  <form method="POST" class="form" action="">
    <h3>Edit <?php echo $user["fname"].' '.$user["lname"]; ?> details</h3>
    <div class="grid">
      <input type="text" name="user" value="<?php echo $_GET["user"]; ?>"; hidden>
      <div class="inputs">
        <span>First Name</span>
        <input type="text" name="firstname" value="<?php echo $user["fname"]; ?>" placeholder="Jhon" cationred>
      </div>
      <div class="inputs">
        <span>Last Name</span>
        <input type="text" name="lastname" value="<?php echo $user["lname"]; ?>" placeholder="Doe" required>
      </div>
    </div>
      <div class="inputs">
        <span>Email</span>
        <input type="text" name="email" value="<?php echo $user["email"]; ?>" placeholder="Doe" required>
      </div>
      <div class="inputs">
        <span>Phone Number</span>
        <input type="text" name="phone" value="<?php echo $user["phone"]; ?>" placeholder="Doe" required>
      </div>
   <div class="grid">
      <div class="inputs">
        <span>Gender</span>
        <input type="text" name="gender" value="<?php echo $user["gender"]; ?>" placeholder="Doe" required>
      </div>
      <div class="inputs">
        <span>Address</span>
        <input type="text" name="address" value="<?php echo $user["address"]; ?>" placeholder="Doe" required>
      </div>
      <div class="inputs">
        <span>State</span>
        <input type="text" name="state" value="<?php echo $user["state"]; ?>" placeholder="Doe" required>
      </div>
      <div class="inputs">
        <span>City</span>
        <input type="text" name="city" value="<?php echo $user["city"]; ?>" placeholder="Doe" required>
      </div>
      <div class="inputs">
        <span>Password</span>
        <input type="password" name="password" value="<?php echo $user["user_id"]; ?>" placeholder="Doe" required>
      </div>
      <div class="inputs">
        <span>PIN</span>
        <input type="tel" name="pin" value="<?php echo $user["pin"]; ?>" placeholder="Doe" required>
      </div>
      <div class="inputs">
        <span>Data api discount</span>
        <input type="number" name="data-discount" value="<?php echo $user["data_discount"]; ?>" placeholder="Doe" required>
      </div>
    </div>
    <button type="submit" name="update" class="button"><i class="fas fa-save"></i> SAVE</button>
  </form>
  <script>
    <?php include "../js/msg.js"; ?>
  </script>
</body>
</html>