<?php
 session_start();
 include "server/conn.php";
 include "../server/controller.php";
 include "server/controller.php";
 AdminControl::checkSession();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/dashboard.css">
  <link rel="stylesheet" href="../css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="../css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
    <?php  
      $site = Control::site($conn);
    ?>
  <title>Admin Dashboard || <?php echo $site["site_name"]; ?></title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('../css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
    }
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
  </style>
</head>
<body>
  <header class="head">
    <i class="fas fa-bars" onclick="toggleMenu(this)"></i>
    <div class="m" id="menu">
      <div class="m-ls">
        <div class="m-t">
          <img src="../logos/<?php echo $site["site_logo"]; ?>" alt="Logo">
          <i class="fas fa-times" onclick="toggleMenu(this)"></i>
        </div>
          <div class="m-ls-lists" id="nav:1"><i id="nav:1" class="bi bi-house"></i><span id="nav:1">Dashboard</span><i id="nav:1" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:2"><i id="nav:2" class="bi bi-person"></i><span id="nav:2">Users</span><i id="nav:2" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:3"><i id="nav:3" class="bi bi-plus-circle"></i><span id="nav:3">Fund/debit users</span><i id="nav:3" class="fas fa-chevron-right"></i></div>
        <a href="verification.php"><div class="m-ls-lists"><i class="bi bi-lock"></i><span>Verify bvn</span><i class="fas fa-chevron-right"></i></div></a>
        <div class="m-ls-lists" id="nav:4"><i id="nav:4" class="bi bi-grid"></i><span id="nav:4">Services</span><i id="nav:4" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:5"><i id="nav:5" class="bi bi-envelope"></i><span id="nav:5">Send Mail</span><i id="nav:5" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:6"><i id="nav:6" class="bi bi-bar-chart"></i><span id="nav:6">Site Analysis</span><i id="nav:6" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:7"><i id="nav:7" class="bi bi-clock"></i><span id="nav:7">Transactions</span><i id="nav:7" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:9"><i id="nav:9" class="ri ri-notification-4-line"></i><span id="nav:9">Notification</span><i id="nav:9" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:10"><i id="nav:10" class="bi bi-code-slash"></i><span id="nav:10">Price and IDs</span><i id="nav:10" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:11"><i id="nav:11" class="bi bi-code-slash"></i><span id="nav:11">Api Settings</span><i id="nav:11" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:12"><i id="nav:12" class="bi bi-gear"></i><span id="nav:12">Site Settings</span><i id="nav:12" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:13"><i id="nav:13" class="bi bi-person"></i><span id="nav:13">Manage Account</span><i id="nav:13" class="fas fa-chevron-right"></i></div>
        <div class="m-ls-lists" id="nav:14"><i id="nav:14" class="ri-shield-keyhole-line"></i><span id="nav:14">System Users</span><i id="nav:14" class="fas fa-chevron-right"></i></div>
        <a href="logout.php"><div class="m-ls-lists"><i class="bi bi-lock"></i><span>Logout</span><i class="fas fa-chevron-right"></i></div></a>
      </div>
    </div>
    <div class="h-h-right">
        <!-- notification icon indicator --> 
         <div class="h-right">
           <i class="bi bi-bell"></i>
           <b class="indicator"></b>
         </div>
    </div>
  </header>
  
  <div class="innPage active" id="innPage"></div>
 <?php
 $uri = $_SERVER["REQUEST_URI"];
 ?>
  <script>
  const innPage = document.getElementById("innPage");
  const nav = document.querySelectorAll(".m-ls-lists");
  
  window.addEventListener("DOMContentLoaded", () => {
    setFrigament(new TabDashboard);
    <?php
        $adminFolder = "/mobile/admin";

        if($uri === "$adminFolder/dashboard.php" || $uri === "$adminFolder/dashboard_home.php"){
            echo '
                setFrigament(new TabDashboard);
                doClass(nav, "nav:1");
            ';
        } else if($uri === "$adminFolder/all_users.php"){
            echo '
                setFrigament(new TabUsers);
                doClass(nav, "nav:2");
            ';
        } else if($uri === "$adminFolder/fund_user.php"){
            echo '
                setFrigament(new TabFundUser);
                doClass(nav, "nav:3");
            ';
        } else if($uri === "$adminFolder/manage_services.php"){
            echo '
                setFrigament(new TabServices);
                doClass(nav, "nav:4");
            ';
        } else if($uri === "$adminFolder/send_mail.php"){
            echo '
                setFrigament(new TabSendMail);
                doClass(nav, "nav:5");
            ';
        } else if($uri === "$adminFolder/site_analysis.php"){
            echo '
                setFrigament(new TabAnalysis);
                doClass(nav, "nav:6");
            ';
        } else if($uri === "$adminFolder/manage_transactions.php"){
            echo '
                setFrigament(new TabTransactions);
                doClass(nav, "nav:7");
            ';
        } else if($uri === "$adminFolder/verification.php"){
            echo '
                setFrigament(new TabSupport);
                doClass(nav, "nav:8");
            ';
        } else if($uri === "$adminFolder/manage_notification.php"){
            echo '
                setFrigament(new TabNotification);
                doClass(nav, "nav:9");
            ';
        } else if($uri === "$adminFolder/price_id.php"){
            echo '
                setFrigament(new TabPriceAndId);
                doClass(nav, "nav:10");
            ';
        } else if($uri === "$adminFolder/api_settings.php"){
            echo '
                setFrigament(new TabApiSettings);
                doClass(nav, "nav:11");
            ';
        } else if($uri === "$adminFolder/site_settings.php"){
            echo '
                setFrigament(new TabSiteSettings);
                doClass(nav, "nav:12");
            ';
        } else if($uri === "$adminFolder/manage_account.php"){
            echo '
                setFrigament(new TabManageAccount);
                doClass(nav, "nav:13");
            ';
        } else if($uri === "$adminFolder/system_users.php"){
            echo '
                setFrigament(new TabSystemUsers);
                doClass(nav, "nav:14");
            ';
        }
    ?>
});
  
  <?php include "../js/msg.js"; ?>
  
function isEmail(input) {
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  return emailRegex.test(input)
}
   
function isURL(input) {
  const urlRegex = /^(https?:\/\/)?([^\s$.?#].[^\s]*)\.[a-z]{2,}([^\s]*)$/i;
 return urlRegex.test(input);
}

  
   function changeUrl(link, pgtitle){
       // Update the browser history
       const newUrl = link;
       const title = pgtitle; // Optional, you can set a title for the new state
       const state = { additionalInformation: 'Additional data' }; //Optional, you can pass additional state data

       // Push the new state to the history stack
       history.pushState(state, title, newUrl);
       document.title = pgtitle;
   }
  
  

window.addEventListener('popstate', (event) => {
    console.log('popstate event:', event);

    
    const basePath = '/mobile/admin';
    const state = event.state;
    const currentPath = window.location.pathname;

    
    if(currentPath === `${basePath}/dashboard.php` || currentPath === `${basePath}/dashboard_home.php`) {
        setFrigament(new TabDashboard);
        doClass(nav, "nav:1");
    } else if(currentPath === `${basePath}/all_users.php`) {
        setFrigament(new TabUsers);
        doClass(nav, "nav:2");
    } else if(currentPath === `${basePath}/fund_user.php`) {
        setFrigament(new TabFundUser);
        doClass(nav, "nav:3");
    } else if(currentPath === `${basePath}/manage_services.php`) {
        setFrigament(new TabServices);
        doClass(nav, "nav:4");
    } else if(currentPath === `${basePath}/send_mail.php`) {
        setFrigament(new TabSendMail);
        doClass(nav, "nav:5");
    } else if(currentPath === `${basePath}/site_analysis.php`) {
        setFrigament(new TabAnalysis);
        doClass(nav, "nav:6");
    } else if(currentPath === `${basePath}/manage_transactions.php`) {
        setFrigament(new TabTransactions);
        doClass(nav, "nav:7");
    } else if(currentPath === `${basePath}/customer_support.php`) {
        setFrigament(new TabSupport);
        doClass(nav, "nav:8");
    } else if(currentPath === `${basePath}/manage_notification.php`) {
        setFrigament(new TabNotification);
        doClass(nav, "nav:9");
    } else if(currentPath === `${basePath}/price_id.php`) {
        setFrigament(new TabPriceAndId);
        doClass(nav, "nav:10");
    } else if(currentPath === `${basePath}/api_settings.php`) {
        setFrigament(new TabApiSettings);
        doClass(nav, "nav:11");
    } else if(currentPath === `${basePath}/site_settings.php`) {
        setFrigament(new TabSiteSettings);
        doClass(nav, "nav:12");
    } else if(currentPath === `${basePath}/manage_account.php`) {
        setFrigament(new TabManageAccount);
        doClass(nav, "nav:13");
    } else if(currentPath === `${basePath}/system_users.php`) {
        setFrigament(new TabSystemUsers);
        doClass(nav, "nav:14");
    } else if(state) {
        document.getElementById("inn").innerHTML = state.additionalInformation;
    }
});
  
  
 const menuT = document.getElementById("menu");

function toggleMenu(thisI) {
    menuT.classList.toggle("active");
    innPage.classList.toggle("active");
    innPage.classList.toggle("n");
}

document.body.addEventListener("click", (e) => {
    const thisTarget = e.target;
    const basePath = `${window.location.origin}/mobile/admin`; 

    
    const navMapping = {
        "nav:1": { component: new TabDashboard, path: "dashboard_home.php", title: "Dashboard Home" },
        "nav:2": { component: new TabUsers, path: "all_users.php", title: "Users || mBills" },
        "nav:3": { component: new TabFundUser, path: "fund_user.php", title: "Fund User" },
        "nav:4": { component: new TabServices, path: "manage_services.php", title: "Services" },
        "nav:5": { component: new TabSendMail, path: "send_mail.php", title: "Send Mail" },
        "nav:6": { component: new TabAnalysis, path: "site_analysis.php", title: "Analysis" },
        "nav:7": { component: new TabTransactions, path: "manage_transactions.php", title: "Transactions" },
        "nav:8": { component: new TabSupport, path: "customer_support.php", title: "Customer Support" },
        "nav:9": { component: new TabNotification, path: "manage_notification.php", title: "Notification" },
        "nav:10": { component: new TabPriceAndId, path: "price_id.php", title: "Price and IDs" },
        "nav:11": { component: new TabApiSettings, path: "api_settings.php", title: "Api settings" },
        "nav:12": { component: new TabSiteSettings, path: "site_settings.php", title: "Site settings" },
        "nav:13": { component: new TabManageAccount, path: "manage_account.php", title: "Manage account" },
        "nav:14": { component: new TabSystemUsers, path: "system_users.php", title: "System users" }
    };

    // Check if the clicked target is in the nav mapping
    if (navMapping[thisTarget.id]) {
        const { component, path, title } = navMapping[thisTarget.id];
        setFrigament(component);
        doClass(nav, thisTarget.id);
        changeUrl(`${basePath}/${path}`, title);
    }
});
    
    function doClass(nav, thisTarget){
      nav.forEach(navs => {
        navs.classList.remove("active");
      });
      document.getElementById(thisTarget).classList.add("active");
    }
    
    function setFrigament(page){
      innPage.innerHTML = "";
      innPage.appendChild(page);
      if(menuT.className.includes("active")){
        toggleMenu("must-remove");
      }
    }
    
    function showLoader(status, text){
      const newLoad = document.createElement("div");
      newLoad.innerHTML = `
        <div class="loader" id="loader">
          <div class="roll"></div>
          <span class="loader-text">${text}</span>
        </div>
      `;
      if(status == "add"){
        document.body.appendChild(newLoad);
      }else if(status == "remove"){
        document.getElementById("loader").remove();
      }
    }
    function trigger_fund(){
      const fund_form = document.getElementById("fund_form");
      const identification = document.getElementById("identification");
      const action = document.getElementById("action");
      const amount = document.getElementById("amount");
      const reason = document.getElementById("reason");
      const passkey = document.getElementById("passkey");
      
      if(identification.value === "" || action.value === "" || amount.value < 50 || reason.value.length < 5 || passkey.value.length < 8){
        identification.dispatchEvent(new Event("input"));
        amount.dispatchEvent(new Event("input"));
        action.dispatchEvent(new Event("change"));
        reason.dispatchEvent(new Event("input"));
        passkey.dispatchEvent(new Event("input"));
      }else{
        showLoader("add", "Submitting...");
        fetch("server/fund-user.php", {
          method: "POST",
          body: new FormData(fund_form),
        })
        .then(response => response.text())
        .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            const newDiv = document.createElement("div");
            newDiv.innerHTML = `
            <div class="table-form">
              <div class="table-bx">
                <b>Admin Name</b>
                <span></span>
              </div>
              <div class="table-bx">
                <b>Full-name</b>
                <span></span>
              </div>
              <div class="table-bx">
                <b>Amount</b>
                <span>${amount.value}</span>
              </div>
              <div class="table-bx">
                <b>Reason</b>
                <span>${reason.value}</span>
              </div>
            </div>
            `;
            const fund_grid = document.getElementById("fund-grid");
            fund_grid.insertBefore(newDiv, fund_grid.firstChild);
            fund_form.reset();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
    }
    
    function toggleService(toggleId, toggle_id){
      const togg_id = document.getElementById(toggleId);
      fetch("server/update-service.php", {
        method: "POST",
        body: JSON.stringify({
          'toggle_id': toggle_id,
          }),
        header: {
          "Content-Type": "application/json",
        },
      })
      .then(response => response.text())
      .then(data => {
        if(data.includes("success")){
          togg_id.classList.toggle("active");
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      });
    }
    
    
    function updateapi(form_name, form_id){
      showLoader("add", "Updating...");
      const form = document.getElementById(form_name);
      fetch("server/update-api.php", {
        method: "POST",
        body: new FormData(form),
      })
      .then(response => response.text())
      .then(data => {
        showLoader("remove", "");
        if(data.includes("success")){
          showMessage("bi bi-check-circle", data, "suc");
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      })
    }
    
    
    function toggleApiStatus(toggle_slider, toggle_id, type, bx_id){
      const get_toggle_btn = document.getElementById(toggle_slider);
      const icons = document.querySelectorAll(type);
      const get_bx = document.getElementById(bx_id);
      const type_r = type.replace(".", "");
      const tglrs = document.querySelectorAll(".toggler-span" + type_r);
      
      fetch("server/update-api-status.php", {
        method: "POST",
        body: JSON.stringify({
          'toggle_id': toggle_id,
          'type': type_r,
          }),
        header: {
          "Content-Type": "application/json",
        },
      })
      .then(response => response.text())
      .then(data => {
        if(data.includes("success")){
          icons.forEach(icons_all => {
            if(type_r === "Airtime" || type_r === "airtime_pin" || type_r === "data_pin" || type_r === "Data" || type_r === "cable_tv" || type_r === "cable_tv_verify" ||type_r === "electricity" || type_r === "electricity_verify"){
                icons_all.remove();
            }
          });
          const newI = document.createElement("div");
          const cd = '<i class="bi bi-check ab ' + type_r + '"></i>';
          newI.innerHTML = cd;
          get_toggle_btn.classList.toggle("active");
          if(data.includes("On")){
            get_bx.appendChild(newI);
          }
          showMessage("bi bi-check-circle", data, "suc");
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      });
    }
    
    
    function send_notification(){
      const form = document.getElementById("notify-form");
      const title = document.getElementById("title");
      const type = document.getElementById("type");
      const timer = document.getElementById("timer");
      const timer_bx = document.getElementById("timer-bx");
      const message = document.getElementById("message");
      const passkey = document.getElementById("passkey");
      if(title.value.length < 5 || type.value === "" || message.value.length < 15 || passkey.value.length < 8){
        title.dispatchEvent(new Event("input"));
        type.dispatchEvent(new Event("change"));
        message.dispatchEvent(new Event("input"));
        passkey.dispatchEvent(new Event("input"));
      }else{
          showLoader("add", "Submitting...");
          fetch("server/send-notification.php", {
            method: "POST",
            body: new FormData(form),
          })
          .then(response => response.json())
          .then(data => {
            showLoader("remove", "");
            if(data.msg.includes("success")){
              showMessage("bi bi-check-circle", data.msg, "suc");
              const newDiv = document.createElement("div");
              newDiv.innerHTML = data.other;
              const notify_inn = document.getElementById("notify-inn");
              notify_inn.insertBefore(newDiv, notify_inn.firstChild);
            }else{
              showMessage("bi bi-exclamation-circle", data.msg, "err");
            }
          });
      }
    }
    
    
    function getUserDetails(thisBtn, user_id){
      let formerTxt = thisBtn.innerText;
      showP(thisBtn);
      showLoader("add", "Submitting...");
      fetch("server/users.php", {
        method: "POST",
        body: JSON.stringify({
          'user_id': user_id,
          }),
        header: {
          "Content-Type": "application/json",
        },
      })
      .then(response => response.text())
      .then(data => {
        var newPg = document.createElement("div");
        newPg.innerHTML = data;
        innPage.appendChild(newPg);
        removeP(thisBtn, formerTxt);
        showLoader("remove", "");
      });
    }
    
    function closeUserPage(user_page_id){
      const get_user_page = document.getElementById(user_page_id);
      get_user_page.remove();
    }
    
    function updateSiteSettings(thisBtn){
      const site_name = document.getElementById("site-name");
      const site_logo = document.getElementById("site-logo");
      const site_url = document.getElementById("site-url");
      const phone = document.getElementById("phone");
      const smtp_email = document.getElementById("smtp-email");
      const smtp_username = document.getElementById("smtp-password");
      const smtp_password = document.getElementById("smtp-password");
      const smtp_host = document.getElementById("smtp-host");
      const info_email = document.getElementById("info-email");
      const hi_email = document.getElementById("hi-email");
      const support_email = document.getElementById("support-email");
      const whatsapp = document.getElementById("whatsapp");
      const whatsapp_group = document.getElementById("whatsapp-group");
      const facebook = document.getElementById("facebook");
      const twitter = document.getElementById("twitter");
      const instagram = document.getElementById("instagram");
      const telegram = document.getElementById("telegram");
      const referral_bonus = document.getElementById("referral-bonus");
      const register_bonus = document.getElementById("register-bonus");
      const site_color = document.getElementById("site-color");
      const site_bg = document.getElementById("site-background");
      if(site_name.value.length < 4 || site_logo.value === "" || isURL(site_url.value) !== true || phone.value.length < 11 || isEmail(smtp_email.value) !== true || smtp_username.value.length < 4 || smtp_password.value.length < 8 || smtp_host.value.length < 4 || isEmail(info_email.value) !== true || isEmail(hi_email.value) !== true || isEmail(support_email.value) !== true || isURL(whatsapp.value) !== true || isURL(whatsapp_group.value) !== true || isURL(facebook.value) !== true || isURL(instagram.value) !== true || isURL(twitter.value) !== true || isURL(telegram.value) !== true || referral_bonus.value < 1 || register_bonus.value < 1 || site_color.value.length < 4 || site_bg.value.length < 3){
        site_name.dispatchEvent(new Event("input"));
        site_logo.dispatchEvent(new Event("input"));
        site_url.dispatchEvent(new Event("input"));
        phone.dispatchEvent(new Event("input"));
        smtp_email.dispatchEvent(new Event("input"));
        smtp_username.dispatchEvent(new Event("input"));
        smtp_password.dispatchEvent(new Event("input"));
        smtp_host.dispatchEvent(new Event("input"));
        info_email.dispatchEvent(new Event("input"));
        hi_email.dispatchEvent(new Event("input"));
        support_email.dispatchEvent(new Event("input"));
        whatsapp.dispatchEvent(new Event("input"));
        whatsapp_group.dispatchEvent(new Event("input"));
        facebook.dispatchEvent(new Event("input"));
        twitter.dispatchEvent(new Event("input"));
        instagram.dispatchEvent(new Event("input"));
        telegram.dispatchEvent(new Event("input"));
        referral_bonus.dispatchEvent(new Event("input"));
        register_bonus.dispatchEvent(new Event("input"));
        site_color.dispatchEvent(new Event("input"));
        site_bg.dispatchEvent(new Event("input"));
      }else{
        const site_setting_form = document.getElementById("site-setting-form");
        const formerTxt = thisBtn.innerText;
        showLoader("add", "Updating . . .");
        showP(thisBtn);
        
        fetch("server/update-site-setting.php", {
          method: "POST",
          body: new FormData(site_setting_form),
        })
        .then(response => response.text())
        .then(data => {
          if(data.includes("success")){
           showMessage("bi bi-check-circle", data, "suc");
          }else{
           showMessage("bi bi-exclamation-circle", data, "err");
          }
           showLoader("remove", "");
           removeP(thisBtn, formerTxt);
        })
      }
    }
    
    
    function delete_notification(notify_id){
      function do_del(){
        fetch("server/delete-notification.php", {
          method: "POST",
          body: JSON.stringify({
            "notify_id": notify_id,
          }),
          header: {
            "Content-Type": "application/json",
          },
        })
        .then(response => response.text())
        .then(data => {
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            document.getElementById(notify_id + ":notify-box").remove();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        });
      }
      showMessage("bi bi-info-circle", "Actions cannot be undone, are you sure you want to delete notification", "ver", "", do_del);
    }
    
    
    function update_notification_status(notify_id, notify_toggler){
      const get_notify_toggler = document.getElementById(notify_toggler);
      showLoader("add", "Updating . . .");
      fetch("server/update-notification-status.php", {
        method: "POST",
        body: JSON.stringify({
          "notify_id": notify_id,
        }),
        header: {
          "Content-Type": "application/json",
        },
      })
      .then(response => response.text())
      .then(data => {
        showLoader("remove", "");
        if(data.includes("success")){
          get_notify_toggler.classList.toggle("active");
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      });
    }
    
    
    function changeTabs(allTabsId, toShowId, this_btn, all_btns){
      const get_tabs = document.querySelectorAll(allTabsId);
      const get_btns = document.querySelectorAll(all_btns);
      const show_tabs = document.getElementById(toShowId);
      get_tabs.forEach(allTabs => {
        allTabs.style.display = "none";
      });
      show_tabs.style.display = "block";
      get_btns.forEach(allBtns => {
        allBtns.classList.remove("active")
      });
      this_btn.classList.add("active")
    }
    
    
    function delete_chat_session(chat_id, chat_box_id){
      function del_chat(){
        showLoader("add", "Deleting . . .");
        fetch("server/delete-chat-session.php", {
          method: "POST",
          body: JSON.stringify({
            "chat_id": chat_id,
          }),
          header: {
            "Content-Type": "application/json",
          },
        })
        .then(response => response.text())
        .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            document.getElementById(chat_box_id).remove();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
      showMessage("bi bi-info-circle", "Action cannot be undone. Are you sure you want to delete chat session", "ver", "", del_chat);
    }
    
    
    function toggleActive(bdy_id, fcn){
      document.getElementById(bdy_id).classList.toggle("active");
      if(fcn !== ""){
          document.getElementById(bdy_id).remove();
      }
    }
    
    
    function add_new_api(thisBtn){
      const formerTxt = thisBtn.innerText;
      const new_api_form = document.getElementById("new-api-form");
      const name = document.getElementById("name");
      const service = document.getElementById("service");
      const enter_service = document.getElementById("enter-service");
      const secret_key = document.getElementById("secret-key");
      const url = document.getElementById("url");
      const passkey = document.getElementById("passkey");
      if(name.value.length < 3 || service.value == "" || (service.value === "ADD_YOURS" && enter_service.value === "") || secret_key.value === "" || isURL(url.value) === false || passkey.value.length < 8){
        name.dispatchEvent(new Event("input"));
        service.dispatchEvent(new Event("change"));
        secret_key.dispatchEvent(new Event("input"));
        url.dispatchEvent(new Event("input"));
        passkey.dispatchEvent(new Event("input"));
        if(service.value === "ADD_YOURS"){
          enter_service.dispatchEvent(new Event("input"));
        }
      }else{
        showLoader("add", "Submitting . . .");
        showP(thisBtn);
        fetch("server/add-new-api.php", {
          method: "POST",
          body: new FormData(new_api_form),
        })
        .then(response => response.text())
        .then(data => {
          showLoader("remove", "");
          removeP(thisBtn, formerTxt);
          alert(data);
        });
      }
    }
    
    
    function deleteApi(api_bx, api_id){
      showLoader("add", "Deleting . . .");
      fetch("server/delete-api.php", {
        method: "POST",
        body: JSON.stringify({
          "api_id": api_id
        }),
        header: {
          "Content-Type": "application/json",
        },
      })
      .then(response => response.text())
      .then(data => {
        showLoader("remove", "");
        if(data.includes("success")){
          showMessage("bi bi-check-circle", data, "suc");
          document.getElementById(api_bx).remove();
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      });
    }
   
   
function editIds(id, service, provider_id, provider, ab, status) {
    const newForm = document.createElement("div");
    newForm.innerHTML = `
        <div class="fixed-body-form active" id="whl-bdy-two">
            <form class="form-design" style="max-width: 335px;" id="update-form-two">
            <div class="topic seperate">
             <span><i class="bi bi-pencil"></i> Edit ID</span>
             <button type="button" class="cancel-btn" onclick="toggleActive('whl-bdy-two', 'remove')">cancel</button>
            </div>
            <input type="text" id="edit-id" name="edit-id" value="${id}" style="display: none;">
            <div class="grid two">
                <div class="inputs no-bottom gap">
                    <span>Service</span>
                    <input type="text" id="edit-service" name="edit-service" value="${service}" placeholder="eg, Electricity">
                    <b class="small-txt">* must contain only letters *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Provider ID</span>
                    <input type="tel" id="edit-provider-id" name="edit-provider-id" value="${provider_id}" placeholder="eg, 1">
                    <b class="small-txt">* must contain only number *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Provider</span>
                    <input type="text" id="edit-provider" name="edit-provider" value="${provider}" placeholder="eg, Abuja Electricity, MTN">
                    <b class="small-txt">* must contain letters only *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Abrivation</span>
                    <input type="text" id="edit-ab" name="edit-ab" value="${ab}" placeholder="eg, AEDC, MTN">
                    <b class="small-txt">* must contain short words in place of provider *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Status</span>
                    <select name="edit-status" id="edit-status">
                        <option value="On" ${status === 'On' ? 'selected' : ''}>On</option>
                        <option value="Off" ${status === 'Off' ? 'selected' : ''}>Off</option>
                    </select>
                    <b class="small-txt">* Must select either to switch "On" or "Off". *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Admin Passkey</span>
                    <input type="password" id="passkey" name="passkey" placeholder="********">
                    <b class="small-txt">* must be up to 8 digits *</b>
                </div>
             </div>
             <button class="form-btn" type="button" onclick="updateId()">UPDATE</button>
            </form>
        </div>
    `;
    document.body.appendChild(newForm);
}


function editTypes(id, service_id, service_name, service, type, status) {
    const newForm = document.createElement("div");
    newForm.innerHTML = `
        <div class="fixed-body-form active" id="whl-bdy-three">
            <form class="form-design" style="max-width: 335px;" id="update-form-types">
            <div class="topic seperate">
             <span><i class="bi bi-pencil"></i> Edit Types</span>
             <button type="button" class="cancel-btn" onclick="toggleActive('whl-bdy-three', 'remove')">cancel</button>
            </div>
            <input type="text" id="edit-id" name="edit-id" value="${id}" style="display: none;">
            <div class="grid two">
                <div class="inputs no-bottom gap">
                    <span>Service ID</span>
                    <input type="text" id="edit-service" name="edit-service-id" value="${service_id}" placeholder="eg, Electricity">
                    <b class="small-txt">* must contain only number *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Service Name</span>
                    <input type="tel" id="edit-provider-id" name="edit-service-name" value="${service_name}" placeholder="eg, 1">
                    <b class="small-txt">* must contain only letter *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Provider</span>
                    <input type="text" id="edit-provider" name="edit-service" value="${service}" placeholder="eg, MTN, AIRTEL">
                    <b class="small-txt">* must contain letters only *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Type</span>
                    <input type="text" id="edit-ab" name="edit-type" value="${type}" placeholder="eg, SME, CORPOPATE, GIFTING">
                    <b class="small-txt">* must contain short words in place of provider *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Status</span>
                    <select name="edit-status" id="edit-status">
                        <option value="On" ${status === 'On' ? 'selected' : ''}>On</option>
                        <option value="Off" ${status === 'Off' ? 'selected' : ''}>Off</option>
                    </select>
                    <b class="small-txt">* Must select either to switch "On" or "Off". *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Admin Passkey</span>
                    <input type="password" id="passkey" name="passkey" placeholder="********">
                    <b class="small-txt">* must be up to 8 digits *</b>
                </div>
             </div>
             <button class="form-btn" type="button" onclick="updateTypes()">UPDATE</button>
            </form>
        </div>
    `;
    document.body.appendChild(newForm);
}
   
   
function editPrice(id, service_id, name, plan, service, amount, validity, status) {
    const newForm = document.createElement("div");
    newForm.innerHTML = `
        <div class="fixed-body-form active" id="whl-bdy">
            <form class="form-design" style="max-width: 335px; max-height: 90%; overflow-y: auto;" id="update-form">
            <div class="topic seperate">
             <span><i class="bi bi-pencil"></i> Edit Plan Details</span>
             <button type="button" class="cancel-btn" onclick="toggleActive('whl-bdy', 'remove')">cancel</button>
            </div>
            <input type="text" id="edit-id" name="edit-id" value="${id}" style="display: none;">
            <div class="grid two">
                <div class="inputs no-bottom gap">
                    <span>Service ID</span>
                    <input type="tel" id="edit-service-id" name="edit-service-id" value="${service_id}">
                    <b class="small-txt">* Must be in digits/numbers *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Name</span>
                    <input type="text" id="edit-name" name="edit-name" value="${name}">
                    <b class="small-txt">* Must be in Capital letters *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Plan</span>
                    <input type="text" id="edit-plan" name="edit-plan" value="${plan}">
                    <b class="small-txt">* eg, 500MB, 1GB, 2GB e.t.c. *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Service</span>
                    <input type="text" id="edit-service" name="edit-service" value="${service}">
                    <b class="small-txt">* Must be in Capital letters *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Amount</span>
                    <input type="tel" id="edit-amount" name="edit-amount" value="${amount}">
                    <b class="small-txt">* eg, 100, 200, 300, 400, 500. *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Validity</span>
                    <input type="text" id="edit-validity" name="edit-validity" value="${validity}">
                    <b class="small-txt">* Days, Month or Week should be written after the digits. *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Status</span>
                    <select name="edit-status" id="edit-status">
                        <option value="On" ${status === 'On' ? 'selected' : ''}>On</option>
                        <option value="Off" ${status === 'Off' ? 'selected' : ''}>Off</option>
                    </select>
                    <b class="small-txt">* Must select either to switch "On" or "Off". *</b>
                </div>
                <div class="inputs no-bottom gap">
                    <span>Admin Passkey</span>
                    <input type="password" id="passkey" name="passkey" placeholder="********">
                    <b class="small-txt">* must be up to 8 digits. *</b>
                </div>
             </div>
             <button class="form-btn" type="button" onclick="updatePrice()">UPDATE</button>
            </form>
        </div>
    `;
    document.body.appendChild(newForm);
}



function deletePrice(form_id, price_id){
  function del_p(){
      showLoader("add", "Deleting . . .");
      fetch("server/delete-service-price.php", {
        method: "POST",
        body: JSON.stringify({
          "price_id": price_id
        }),
        header: {
          "Content-Type": "application/json",
        },
      })
      .then(response => response.text())
      .then(data => {
        showLoader("remove", "");
        if(data.includes("success")){
          showMessage("bi bi-check-circle", data, "suc");
          document.getElementById(form_id).remove();
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      });
  }
  showMessage("bi bi-info-circle", "Actions cannot be undone. Are you sure you want to delete plan details.", "ver", "", del_p);
}
    
    
    
function updatePrice(){
   showLoader("add", "Updating . . .");
   const new_api_form = document.getElementById("update-form");
   fetch("server/update-service-details.php", {
     method: "POST",
     body: new FormData(new_api_form),
   })
   .then(response => response.text())
   .then(data => {
      showLoader("remove", "");
      if(data.includes("success")){
        showMessage("bi bi-check-circle", data, "suc");
        toggleActive("whl-bdy", "remove");
      }else{
        showMessage("bi bi-exclamation-circle", data, "err");
      }
    });
}


function add_new_service(){
  const plan_id = document.getElementById("new-service-id");
  const name = document.getElementById("new-name");
  const plan = document.getElementById("new-plan");
  const service = document.getElementById("new-service");
  const amount = document.getElementById("new-amount");
  const validity = document.getElementById("new-validity");
  const status = document.getElementById("new-status");
  const passkey = document.getElementById("e-passkey");
  if(plan_id.value === "" || name.value === "" || plan.value === "" || service.value === "" || amount.value === "" || validity.value === "" || status.value === "" || passkey.value.length < 8){
      plan_id.dispatchEvent(new Event("input"));
      name.dispatchEvent(new Event("input"));
      plan.dispatchEvent(new Event("input"));
      service.dispatchEvent(new Event("input"));
      amount.dispatchEvent(new Event("input"));
      validity.dispatchEvent(new Event("input"));
      status.dispatchEvent(new Event("change"));
      passkey.dispatchEvent(new Event("input"));
  }else{
     showLoader("add", "Submitting . . .");
     const new_plan_form = document.getElementById("new-plan-form");
     fetch("server/add-new-service.php", {
       method: "POST",
       body: new FormData(new_plan_form),
     })
     .then(response => response.text())
     .then(data => {
        showLoader("remove", "");
        if(data.includes("success")){
          showMessage("bi bi-check-circle", data, "suc");
          toggleActive("new-plan-bx", "remove");
        }else{
          showMessage("bi bi-exclamation-circle", data, "err");
        }
      });
  }
}
    
    
function updateId(){
   showLoader("add", "Updating . . .");
   const new_api_form = document.getElementById("update-form-two");
   fetch("server/update-id-details.php", {
     method: "POST",
     body: new FormData(new_api_form),
   })
   .then(response => response.text())
   .then(data => {
      showLoader("remove", "");
      if(data.includes("success")){
        showMessage("bi bi-check-circle", data, "suc");
        toggleActive("whl-bdy-two", "remove");
      }else{
        showMessage("bi bi-exclamation-circle", data, "err");
      }
    });
}


function updateTypes(){
   showLoader("add", "Updating . . .");
   const new_types_form = document.getElementById("update-form-types");
   fetch("server/update-types-details.php", {
     method: "POST",
     body: new FormData(new_types_form),
   })
   .then(response => response.text())
   .then(data => {
      showLoader("remove", "");
      if(data.includes("success")){
        showMessage("bi bi-check-circle", data, "suc");
        toggleActive("whl-bdy-three", "remove");
      }else{
        showMessage("bi bi-exclamation-circle", data, "err");
      }
    });
}

function getId(idName){
    return document.getElementById(idName);
}


function updatePassword(thisBtn){
    const oldP = getId("old-password");
    const newP = getId("new-password");
    const eNewP = getId("r-new-password");
    if(oldP.value.length < 8 || newP.value.length < 8 || eNewP.value !== newP.value){
        oldP.dispatchEvent(new Event("input"));
        newP.dispatchEvent(new Event("input"));
        eNewP.dispatchEvent(new Event("input"));
    }else{
       showLoader("add", "Updating . . .");
       const change_pass_form = getId("change-pass-form");
       fetch("server/update-password.php", {
         method: "POST",
         body: new FormData(change_pass_form),
       })
       .then(response => response.text())
       .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            change_pass_form.reset();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        });
    }
}


function updatePasskey(thisBtn){
    const oldP = getId("old-passkey");
    const newP = getId("new-passkey");
    const eNewP = getId("r-new-passkey");
    if(oldP.value.length < 8 || newP.value.length < 8 || eNewP.value !== newP.value){
        oldP.dispatchEvent(new Event("input"));
        newP.dispatchEvent(new Event("input"));
        eNewP.dispatchEvent(new Event("input"));
    }else{
       showLoader("add", "Updating . . .");
       const change_pass_form = getId("change-passkey-form");
       fetch("server/update-passkey.php", {
         method: "POST",
         body: new FormData(change_pass_form),
       })
       .then(response => response.text())
       .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            change_pass_form.reset();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        });
    }
}


function sendEmail(thisBtn){
    const topic = getId("topic");
    const header = getId("header");
    const msg = getId("message");
    const passkey = getId("passkey");
    
    if(topic.value.length < 3 || header.value.length < 3 || msg.value.length < 15 || passkey.value.length < 8){
        topic.dispatchEvent(new Event("input"));
        header.dispatchEvent(new Event("input"));
        msg.dispatchEvent(new Event("input"));
        passkey.dispatchEvent(new Event("input"));
    }else{
        showLoader("add", "Sending . . .");
       const send_mail_form = getId("send-mail-form");
       fetch("server/send-mail.php", {
         method: "POST",
         body: new FormData(send_mail_form),
       })
       .then(response => response.text())
       .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            send_mail_form.reset();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        });
    }
}


    function takeAction(user_id, type){
      function update_stats(){
        showLoader("add", "Updating . . .");
        fetch("server/take-action.php", {
          method: "POST",
          body: JSON.stringify({
            "user_id": user_id,
            "type": type,
          }),
          header: {
            "Content-Type": "application/json",
          },
        })
        .then(response => response.text())
        .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
      showMessage("bi bi-info-circle", "Action maynot be undone. Are you sure you want to " + type + " user account", "ver", "", update_stats);
    }
    
    
    
     function deleteAccount(user_id, type){
      const formData = new FormData();
      formData.append("user_id", user_id);
      
      function update_stats(){
        showLoader("add", "Updating . . .");
        fetch("server/delete-user.php", {
          method: "POST",
          body: formData,
        })
        .then(response => response.text())
        .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            setTimeout(()=> {
                window.location.reload();
            }, 1000);
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
      showMessage("bi bi-info-circle", "Action maynot be undone. Are you sure you want to " + type + " user account", "ver", "", update_stats);
    }
    
    
    
    function updateVerify(thisBtn, user_id, type, status){ 
        const formData = new FormData();
        formData.append("user_id", user_id);
        formData.append("type", type);
        formData.append("status", status);
        
        showLoader("add", "Updating . . .");
        fetch("server/update-verification.php", {
          method: "POST",
          body: formData,
        })
        .then(response => response.text())
        .then(data => {
          showLoader("remove", "");
          if(data.includes("success")){
            showMessage("bi bi-check-circle", data, "suc");
            document.getElementById(user_id + ":verify-box").remove();
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        });
    }
    
    
    function add_new_admin(){
       const fname = document.getElementById("firstname");
       const lname = document.getElementById("lastname");
       const role = document.getElementById("role");
       const email = document.getElementById("email");
       const phone = document.getElementById("phone");
       const passkey = document.getElementById("passkey");
       const password = document.getElementById("password");
       const status = document.getElementById("new-status");
       const per = document.getElementById("permission");
       
       if(fname.value.length < 3 || lname.value.length < 3 || role.value === "" || email.value === "" || phone.value.length < 11 || passkey.value.length < 8  || password.value.length < 8 || status.value === "" || per.value === ""){
         fname.dispatchEvent(new Event("input"));
         lname.dispatchEvent(new Event("input"));
         role.dispatchEvent(new Event("input"));
         email.dispatchEvent(new Event("input"));
         phone.dispatchEvent(new Event("input"));
         passkey.dispatchEvent(new Event("input"));
         password.dispatchEvent(new Event("input"));
         status.dispatchEvent(new Event("change"));
         per.dispatchEvent(new Event("change"));
       }else{
           const formData = new FormData();
           formData.append("firstname", fname.value);
           formData.append("lastname", lname.value);
           formData.append("role", role.value);
           formData.append("email", email.value);
           formData.append("phone", phone.value);
           formData.append("passkey", passkey.value);
           formData.append("password", password.value);
           formData.append("status", status.value);
           formData.append("permission", per.value);
           
          showLoader("add", "Submiting . . ."); 
          fetch("server/add-new-admin.php", {
              method: "POST",
              body: formData,
          })
          .then(response => response.text())
          .then(data => {
            showLoader("remove", "");
            if(data.includes("success")){
              showMessage("bi bi-check-circle", data, "suc");
              setTimeout(()=> {
                  window.location.reload();
              }, 2000);
            }else{
              showMessage("bi bi-exclamation-circle", data, "err");
            }
          });
       }
    }
    
    
    
    
    class TabDashboard {
      constructor(){
        const newPage = document.createElement("div");
        fetch("home.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
        });
        return newPage;
      }
    }
    
    class TabUsers {
      constructor(){
        const newPage = document.createElement("div");
        fetch("users.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabFundUser {
      constructor(){
        const newPage = document.createElement("div");
        fetch("fund-user.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabServices {
      constructor(){
        const newPage = document.createElement("div");
        fetch("services.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabSendMail {
      constructor(){
        const newPage = document.createElement("div");
        fetch("send-mail.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabAnalysis {
      constructor(){
        const newPage = document.createElement("div");
        fetch("analysis.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabTransactions {
      constructor(){
        const newPage = document.createElement("div");
        fetch("transactions.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabSupport {
      constructor(){
        const newPage = document.createElement("div");
        fetch("support.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabNotification {
      constructor(){
        const newPage = document.createElement("div");
        fetch("notification.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          const type = document.getElementById("type");
          const timer = document.getElementById("timer-bx");
          type.addEventListener("change", ()=> {
            if(type.value === "timer"){
              timer.style.display = "block";
            }else{
              timer.style.display = "none";
            }
          });
        });
        return newPage;
      }
    }
    
    class TabApiSettings {
      constructor(){
        const newPage = document.createElement("div");
        fetch("api-setting.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          //--------------------------------------------
          //--------------------------------------------
          const get_ser = document.getElementById("service");
          const get_inp = document.getElementById("enter-service");
          get_ser.addEventListener("change", ()=> {
            if(get_ser.value === "ADD_YOURS"){
              get_inp.classList.remove("disabled");
              get_inp.disabled = false;
            }else{
              get_inp.classList.add("disabled");
              get_inp.disabled = true;
              get_inp.style.border = "";
              document.getElementById("enter-service-err").innerHTML = "";
            }
          });
          //--------------------------------------------
        });
        return newPage;
      }
    }
    
    class TabPriceAndId {
      constructor(){
        const newPage = document.createElement("div");
        fetch("price-id.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabSiteSettings {
      constructor(){
        const newPage = document.createElement("div");
        fetch("site-setting.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabManageAccount {
      constructor(){
        const newPage = document.createElement("div");
        fetch("account.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
    
    class TabSystemUsers {
      constructor(){
        const newPage = document.createElement("div");
        fetch("system-users.php")
        .then((response) => response.text())
        .then((data) => {
          newPage.innerHTML = data;
          
        });
        return newPage;
      }
    }
  </script>
</body>
</html>
