<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Image Verification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 20px;
            text-align: center;
        }
        .container {
            max-width: 600px;
            margin: auto;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .image-box {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px;
            border-bottom: 1px solid #ddd;
            flex-direction: column;
        }
        .image-box img {
            border-radius: 5px;
            border: 1px solid #ccc;
            margin-bottom: 5px;
        }
        .buttons {
            display: flex;
            gap: 10px;
        }
        .buttons button {
            padding: 8px 12px;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            font-size: 14px;
        }
        .accept-btn {
            background-color: #4CAF50;
            color: white;
        }
        .reject-btn {
            background-color: #f44336;
            color: white;
        }
        .accept-btn:hover {
            background-color: #45a049;
        }
        .reject-btn:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Image Verification</h2>
<a href="verification.php">GO HOME</a>
    <?php 
    include "server/conn.php"; 
    include "server/controller.php"; 

    $sql = "SELECT id, utility FROM verification WHERE utility LIKE '%verifying%'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            echo "<div class='image-box'>";
            echo "<img src='../verification/" . $row["utility"] . "' width='100' height='100'>";
            echo "<a href='../verification/" . $row["utility"] . "' target='_blank'>View Image</a>"; // Hyperlink added
            echo "<div class='buttons'>";
            echo "<button class='accept-btn' onclick='acceptImage(" . $row["id"] . ", \"" . $row["utility"] . "\")'>Accept</button>";
            echo "<button class='reject-btn' onclick='rejectImage(" . $row["id"] . ", \"" . $row["utility"] . "\")'>Reject</button>";
            echo "</div>";
            echo "</div>";
        }
    } else {
        echo "<p>No images found, all images may have been reviewed.</p>";
    }
    ?>
</div>

<script>
function acceptImage(id, filename) {
    fetch('server/img_status.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: `action=accept&id=${id}&filename=${filename}`
    })
    .then(response => response.json())
    .then(data => alert(data.message))
    .catch(error => console.error('Error:', error));
}

function rejectImage(id, filename) {
    fetch('server/img_status.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: `action=reject&id=${id}&filename=${filename}`
    })
    .then(response => response.json())
    .then(data => alert(data.message))
    .catch(error => console.error('Error:', error));
}
</script>

</body>
</html>
