<?php 
session_start();
include "server/conn.php";
include "server/controller.php";
include "../server/controller.php";
AdminControl::checkSession();

$admin_id = $_SESSION["admin_id"];
?>
<div style="margin-bottom: 12px;"><i class="bi bi-code-slash"></i> Api Settings</div>

<?php
 function get_apis($conn, $service, $type){
   $stmt = $conn->prepare("SELECT * FROM api WHERE service LIKE ? AND NOT service LIKE ? AND NOT service LIKE ?");
   $serB = '%'.$service.'%';
   $serB_two = '%'.$service.'_verify%';
   $serB_three = '%'.$service.'_pin%';
   $stmt->bind_param("sss", $serB, $serB_two, $serB_three);
   $stmt->execute();
   $res = $stmt->get_result();
   $forms = "";
   $count = 0;
   
   if($res->num_rows > 0){
     while($row = $res->fetch_assoc()){
       $addCheck = "";
       $count++;
       if($row["status"] == "On"){
         $addCheck = '<i class="bi bi-check ab '.$type.'"></i>';
       }
       $forms .= '
        <form class="form-design-two do-'.$count.'" id="'.$row["id"].':api-form">
         '.$addCheck.'
          <div class="grid two bottom" style="margin-bottom:0px;">
          <input type="text" name="api-id" value="'.$row["id"].'" hidden>
            <div class="inputs" style="margin-bottom:4px;margin-top:0px">
              <span>Name</span>
              <input type="text" name="name" value="'.$row["name"].'" style="height:35px; margin-bottom:0px;">
            </div>
            <div class="inputs" style="margin-bottom:4px;margin-top:0px">
              <span>Contract Code</span>
              <input type="text" name="contract-code" value="'.$row["contract_code"].'" style="height:35px; margin-bottom:0px;" placeholder="(OPTIONAL)">
            </div>
          </div>
          <div class="inputs" style="margin-bottom:4px;margin-top:4px">
            <span>Service Name<i style="color: #0004;">(DISABLED)</i></span>
            <input type="text" name="service" value="'.$row["service"].'" style="height:35px;" class="disabled" disabled>
          </div>
          <div class="inputs" style="margin-bottom:4px;margin-top:4px">
            <span>Public Key</span>
            <input type="text" name="public-key" value="'.$row["public_key"].'" style="height:35px;" placeholder="(OPTIONAL)">
          </div>
          <div class="inputs" style="margin-bottom:4px;margin-top:4px">
            <span>Secret Key</span>
            <input type="text" name="secret-key" value="'.$row["secret_key"].'" style="height:35px;">
          </div>
          <div class="inputs" style="margin-bottom:4px;margin-top:4px">
            <span>URL</span>
            <input type="text" name="url" value="'.$row["url"].'" style="height:35px;">
          </div>
          
          <div class="tgl">
            <div>On/Off</div>
            <div class="tg-bx" style="position: relative;" onclick="toggleApiStatus(`'.$row["id"].':tg-status`, `'.$row["id"].'`, `.'.$type.'`, `'.$row["id"].':api-form`)">
              <div class="toggler"></div>
              <span class="toggler-span '.($row["status"] == "On" ? "active" : "").'" id="'.$row["id"].':tg-status"></span>
            </div>
          </div>
          
          <button type="button" class="form-small-btn inline red" onclick="deleteApi(`'.$row["id"].':api-form`, `'.$row["id"].'`)">Delete</button>
          <button type="button" class="form-small-btn inline green" onclick="updateapi(`'.$row["id"].':api-form`, `'.$row["id"].'`)">Update Details</button>
        </form>
       ';
     }
   }else{
     echo '';
   }
   return $forms;
 }
?>
<div class="msg green">
  <span class="spn">Add new api details</span>
  <button class="form-btn top-none" style="margin-top: 6px;height: 40px;" onclick="toggleActive('whole-body', '')">Add New</button>
  
  <div class="fixed-body-form" id="whole-body">
    <form action="" id="new-api-form" class="form-design" style="width: 330px; max-height: 95%; overflow: auto;">
      <!-------------------------------------------------->
      <div class="form-topic seperate bottom">
        <b style="color: #000;"><i class="bi bi-plus-circle"></i> Add new api</b>
        <button class="cancel-btn" type="button" onclick="toggleActive('whole-body', '')">cancel</button>
      </div>
      <!-------------------------------------------------->
      <div class="grid two">
        <div class="inputs" style="margin-bottom:0;">
          <span>Name</span>
          <input type="text" name="name" id="name" placeholder="(REQUIRED)" oninput="checkValue('name', 'name-err', 3, 'length', 'Invalid name', '')">
          <b class="small-txt">*Must contain only letters minimum (3 Letters)*</b>
          <b id="name-err"></b>
        </div>
        <!-------------------------------------------------->
        <div class="inputs" style="margin-bottom:0;">
          <span>Contract Code</span>
          <input type="text" name="contract-code" id="contract-code" placeholder="(OPTIONAL)" oninput="checkValue('contact-code', 'contact-code-err', '', 'empty', 'Invalid contract code', '')">
          <b id="contact-code-err"></b>
        </div>
      </div>
      <!-------------------------------------------------->
      <div class="inputs">
        <span>Select Service</span>
        <select name="service" id="service" onchange="checkValue('service', 'service-err', '', 'empty', 'Please select service', '')">
          <option value="">-- Select Service --</option>
          <option value="AIRTIME">AIRTIME</option>
          <option value="AIRTIME_PIN">AIRTIME PIN</option>
          <option value="DATA">DATA</option>
          <option value="DATA_PIN">DATA PIN</option>
          <option value="CABLE_TV">CABLE TV</option>
          <option value="CABLE_TV_VERIFY">CABLE TV VERIFY</option>
          <option value="EXAM_PIN">EXAM TV</option>
          <option value="BETTING">BETTING</option>
          <option value="BETTING_VERIFY">BETTING VERIFY</option>
          <option value="ELECTRICITY">ELECTRICITY</option>
          <option value="ELECTRICITY_VERIFY">ELECTRICITY VERIFY</option>
          <option value="BULK_SMS">BULK SMS</option>
          <option value="ADD_YOURS">Add Yours(Edit your own service name)</option>
        </select>
        <b id="service-err"></b>
      </div>
      <!-------------------------------------------------->
      <div class="inputs">
        <span>Enter Service</span>
        <input type="text" name="enter-service" class="disabled" id="enter-service" placeholder="(OPTIONAL)" oninput="checkValue('enter-service', 'enter-service-err', '', 'empty', 'Invalid service name', '')" disabled>
        <b class="small-txt">*Must contain only capital letters*</b>
        <b id="enter-service-err"></b>
      </div>
      <!-------------------------------------------------->
      <div class="inputs">
        <span>Public Key</span>
        <input type="text" name="public-key" id="public-key" placeholder="(OPTIONAL)" oninput="checkValue('public-key', 'public-key-err', '', 'empty', 'Invalid public key', '')">
        <b class="small-txt">*Can contain only general character except symbols*</b>
        <b id="public-key-err"></b>
      </div>
      <!-------------------------------------------------->
      <div class="inputs">
        <span>Secret Key</span>
        <input type="text" name="secret-key" id="secret-key" placeholder="(REQUIRED)" oninput="checkValue('secret-key', 'secret-key-err', '', 'empty', 'Invalid secret key', '')">
        <b class="small-txt">*Can contain only general character except symbols*</b>
        <b id="secret-key-err"></b>
      </div>
      <!-------------------------------------------------->
      <div class="inputs">
        <span>URL</span>
        <input type="text" id="url" name="url" placeholder="(REQUIRED)" oninput="checkValue('url', 'url-err', '', 'url', 'Invalid url', '')">
        <b class="small-txt">*Must includes https://, sitename, extension, then path*</b>
        <b id="url-err"></b>
      </div>
      <!-------------------------------------------------->
      <div class="inputs">
        <span>Admin Passkey</span>
        <input type="text" name="passkey" id="passkey" placeholder="(REQUIRED)" oninput="checkValue('passkey', 'passkey-err', '8', 'length', 'Invalid passkey', '')">
        <b class="small-txt">*Must be up to 8 digits*</b>
        <b id="passkey-err"></b>
      </div>
      <button class="form-btn" type="button" onclick="add_new_api(this)">SUBMIT</button>
    </form>
  </div>
</div>
<!-------------------------------------------------------->
<!-------------------------------------------------------->
<div class="many-btns">
  <button class="form-small-btn do inline top-none ash active" onclick="changeTabs('.session-tab', 'airtime-bx', this, '.form-small-btn.do')">Airtime</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'airtime-pin-bx', this, '.form-small-btn.do')">Airtime Pin</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'data-bx', this, '.form-small-btn.do')">Data</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'data-pin-bx', this, '.form-small-btn.do')">Data Pin</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'cable-tv-bx', this, '.form-small-btn.do')">Cable Tv</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'cable-tv-verify-bx', this, '.form-small-btn.do')">Cable Tv Verify</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'electricity-bx', this, '.form-small-btn.do')">Electricity</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'electricity-verify-bx', this, '.form-small-btn.do')">Electricity Verify</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'betting-bx', this, '.form-small-btn.do')">Betting</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'betting-verify-bx', this, '.form-small-btn.do')">Betting Verify</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'exam-pin-bx', this, '.form-small-btn.do')">Exam Pin</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'bulk-sms-bx', this, '.form-small-btn.do')">Bulk Sms</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'manual-funding-bx', this, '.form-small-btn.do')">Manual funding</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'manual-funding-verify-bx', this, '.form-small-btn.do')">Manual funding verify</button>
  <button class="form-small-btn do inline top-none ash" onclick="changeTabs('.session-tab', 'automated-funding-bx', this, '.form-small-btn.do')">Automated funding</button>
</div>

<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="airtime-bx" style="display: block;">
  <div class="topic"><i class="bi bi-telephone"></i> Airtime Api's</div>
   <?php
     echo get_apis($conn, "Airtime", "Airtime");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="airtime-pin-bx" style="display:none;">
  <div class="topic"><i class="bi bi-telephone"></i> Airtime Pin Api's</div>
   <?php
     echo get_apis($conn, "Airtime_pin", "airtime_pin");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="data-bx" style="display: none;">
  <div class="topic"><i class="bi bi-phone"></i> Data Api's</div>
   <?php
     echo get_apis($conn, "Data", "Data");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="data-pin-bx" style="display: none;">
  <div class="topic"><i class="bi bi-phone"></i> Data Pin Api's</div>
   <?php
     echo get_apis($conn, "Data_pin", "data_pin");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="cable-tv-bx" style="display: none;">
  <div class="topic"><i class="bi bi-tv"></i> Cable Tv Api's</div>
   <?php
     echo get_apis($conn, "cable_tv", "cable_tv");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="cable-tv-verify-bx" style="display: none;">
  <div class="topic"><i class="bi bi-tv"></i> Cable Tv Verify Api's</div>
   <?php
     echo get_apis($conn, "cable_tv_verify", "cable_tv_verify");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="electricity-bx" style="display: none;">
  <div class="topic"><i class="bi bi-lightbulb"></i> Electricity Api's</div>
   <?php
     echo get_apis($conn, "electricity", "electricity");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="electricity-verify-bx" style="display: none;">
  <div class="topic"><i class="bi bi-lightbulb"></i> Electricity Verify Api's</div>
   <?php
     echo get_apis($conn, "electricity_verify", "electricity_verify");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="betting-bx" style="display: none;">
  <div class="topic"><i class="ri-football-line"></i> Betting Api's</div>
   <?php
     echo get_apis($conn, "betting", "electricity_verify");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="exam-pin-bx" style="display: none;">
  <div class="topic"><i class="ri-football-line"></i> Exam Pin Api's</div>
   <?php
     echo get_apis($conn, "Exam_pin", "electricity_verify");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="betting-verify-bx" style="display: none;">
  <div class="topic"><i class="ri-football-line"></i> Betting Verify Api's</div>
   <?php
     echo get_apis($conn, "betting_verify", "electricity_verify");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="exam-bx" style="display: none;">
  <div class="topic"><i class="ri-graduation-cap-line"></i> Exam Pin Api's</div>
   <?php
     echo get_apis($conn, "exam_pin", "exam_pin");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="bulk-sms-bx" style="display: none;">
  <div class="topic"><i class="bi bi-chat"></i> Bulk Sms</div>
   <?php
     echo get_apis($conn, "bulk_sms", "electricity_verify");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="manual-funding-bx" style="display: none;">
  <div class="topic"><i class="bi bi-wallet"></i> Manual Funding Api's</div>
   <?php
     echo get_apis($conn, "paystack_funding", "Funding");
     echo get_apis($conn, "payvessel_initialize", "Funding");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="manual-funding-verify-bx" style="display: none;">
  <div class="topic"><i class="bi bi-wallet"></i> Manual Funding Verify Api's</div>
   <?php
     echo get_apis($conn, "verify_paystack", "Verify_Funding");
   ?>
</div>
<!---------------------------------------------------------->
<!---------------------------------------------------------->
<div class="session-tab" id="automated-funding-bx" style="display: none;">
  <div class="topic"><i class="bi bi-wallet"></i> Automated Funding Api's</div>
   <?php
     echo get_apis($conn, "payvessel", "Automated_funding");
     echo get_apis($conn, "strowallet", "Automated_funding");
     echo get_apis($conn, "flutterwave", "Automated_funding");
     echo get_apis($conn, "ncwallet", "Automated_funding");
   ?>
</div>