<?php
 include "server/conn.php";
 date_default_timezone_set('Africa/Lagos');

// Initialize variables
$total_today = 0;
$total_all_time = 0;
$total_gain_today = 0;
$total_transactions = 0;
$ret = 0;
$sales = 0;
$total_gain_month = 0;
$total_profit_today = 0; // New variable to store total profit for today

// Define profit per transaction type
$profit_data = 30; // Profit for data transaction
$profit_airtime = 2; // Profit for airtime transaction
$profit_bulk_sms = 1; // Profit for bulk SMS transaction
$profit_airtime_pin = 2; // Profit for airtime pin transaction
$profit_other_services = 100; // Profit for other services

// Get the transactions for the day and overall
$sql = $conn->prepare("SELECT * FROM transaction");
$sql->execute();
$res = $sql->get_result();
$result = [];

if($res->num_rows > 0){
    while($row = $res->fetch_assoc()){
        $result[] = $row;
    }
}

if(!empty($result)){
    foreach($result as $t){
        $today = date("Y-m-d");
        $storedTime = $t["date"];
        
        // Calculate totals for the day and overall
        $total_transactions++;
        $total_all_time += (int)$t["amount"]; // Overall transaction amount

        // Calculate the total transaction amount for today
        if(date("Y-m-d", strtotime($storedTime)) == $today){
            $ret++;
            $sales += (int)$t["amount"]; // Sales for today
            $total_today += (int)$t["amount"]; // Total transaction amount for the day

            // Calculate total gain for today (only for successful transactions)
            if($t["status"] == "success"){
                $total_gain_today += (int)$t["amount"]; // Total gain for today
            }

            // Calculate daily profit based on the type of transaction
            switch($t["transaction_type"]){
                case "data":
                    $total_profit_today += $profit_data; // Add data transaction profit
                    break;
                case "airtime":
                    $total_profit_today += $profit_airtime; // Add airtime transaction profit
                    break;
                case "bulk_sms":
                    $total_profit_today += $profit_bulk_sms; // Add bulk SMS transaction profit
                    break;
                case "airtime_pin":
                    $total_profit_today += $profit_airtime_pin; // Add airtime pin transaction profit
                    break;
                case "other_services":
                    $total_profit_today += $profit_other_services; // Add other services profit
                    break;
            }
        }

        // Calculate total gain for the current month (only for successful transactions)
        $month = date("m", strtotime($storedTime));
        $year = date("Y", strtotime($storedTime));
        if($t["status"] == "success" && $month == date("m") && $year == date("Y")){
            $total_gain_month += (int)$t["amount"];
        }
    }
}

?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Arial', sans-serif;
        background-color: #f4f7fc;
        color: #333; /* Set default text color */
        line-height: 1.6;
        padding: 0;
        margin: 0;
    }

    .topic {
        font-size: 28px;
        font-weight: 700;
        color: #fff; /* White color for title */
        background-color: #151285; /* Site color */
        text-align: center;
        padding: 15px;
        margin: 20px 0;
        border-radius: 8px;
    }

    .form-design {
        padding: 25px;
        margin: 20px;
        border-radius: 10px;
        background: #fff; 
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        color: #333;
    }

    .form-topic {
        font-size: 24px;
        font-weight: bold;
        color: #151285; /* Use site color for headings */
        margin-bottom: 20px;
    }

    .seperate {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
        gap: 20px;
    }

    .det {
        background: #f4f7fc;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
        width: 30%;
        text-align: center;
        color: #151285;
        transition: all 0.3s ease-in-out;
    }

    .det i {
        font-size: 35px;
        color: #fff;
        background-color: #4CAF50;
        padding: 12px;
        border-radius: 50%;
        margin-bottom: 10px;
    }

    .det span {
        font-size: 14px;
        color: #777;
        margin-top: 10px;
        display: block;
    }

    .det b {
        font-size: 22px;
        font-weight: 600;
        color: #151285;
        margin-top: 8px;
        display: block;
    }

    .det:hover {
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
        transform: translateY(-5px);
        cursor: pointer;
    }

    .form-design.green {
        background-color: #4CAF50;
        border: 1px solid #4CAF50;
    }

    /* Mobile responsiveness */
    @media (max-width: 768px) {
        .seperate {
            flex-direction: column;
            gap: 15px;
        }

        .det {
            width: 100%;
        }

        .form-design {
            margin: 10px;
            padding: 15px;
        }

        .topic {
            font-size: 24px;
        }

        .form-topic {
            font-size: 20px;
        }
    }
</style>

<div class="topic"><i class="bi bi-bar-chart"></i>Site Analysis</div>

<div class="form-design">
    <div class="seperate">
        <div class="det">
            <i class="bi bi-clock"></i>
            <span>Transaction</span>
            <b><?php echo $ret; ?></b>
        </div>
        <div class="det">
            <i class="bi bi-graph-up-arrow"></i>
            <span>Sales</span>
            <b>&#x20a6;<?php echo number_format($sales, 2); ?></b>
        </div>
        <div class="det">
            <i class="bi bi-currency-dollar"></i>
            <span>Total Transaction Amount Today</span>
            <b>&#x20a6;<?php echo number_format($total_today, 2); ?></b>
        </div>
        <div class="det">
            <i class="bi bi-currency-dollar"></i>
            <span>Overall Transaction Amount</span>
            <b>&#x20a6;<?php echo number_format($total_all_time, 2); ?></b>
        </div>
        <div class="det">
            <i class="bi bi-trophy"></i>
            <span>Total Gain Today (Successful)</span>
            <b>&#x20a6;<?php echo number_format($total_gain_today, 2); ?></b>
        </div>
        <div class="det">
            <i class="bi bi-calendar"></i>
            <span>Total Gain This Month</span>
            <b>&#x20a6;<?php echo number_format($total_gain_month, 2); ?></b>
        </div>
        <!-- Add Daily Profit Box -->
        <div class="det">
            <i class="bi bi-cash-stack"></i>
            <span>Daily Profit</span>
            <b>&#x20a6;<?php echo number_format($total_profit_today, 2); ?></b>
        </div>
    </div>
</div>

<div class="form-design">
    <div class="form-topic" style="margin-bottom: 20px;">TRANSACTION STATUS</div>
    <div class="seperate">
       <div class="det">
            <i class="bi bi-check-circle-fill" style="color: green;"></i>
            <span>Success Transaction</span>
            <b><?php echo getStatus($conn, "success"); ?></b>
        </div> 
        <div class="det">
            <i class="bi bi-x-circle-fill" style="color: red;"></i>
            <