<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/virtual-card.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Virtual Card || Fluterpay</title>
</head>
<body>
  <div class="header">
    <i class="fas fa-chevron-left"></i>
    <span>Virtual Card</span>
  </div>
  <div class="topic-tag">
    <div class="c-txt">Manage Your Virtual Card</div>
    <div class="sep-btn">
      <button class="active" onclick="toggleCurrency(this, '.grid.ngn')">NGN</button>
      <button onclick="toggleCurrency(this, '.grid.usd')">USD</button>
    </div>
  </div>
  
  
  <div class="grid ngn active">
    <!-------- Card design ------------>
    <!--- <div class="card">
      <div class="c-topic">
        <img src="images/1724225088350-removebg-preview.png" alt="logo" class="one">
        <img src="images/images-removebg-preview.png" alt="mastercard" class="two">
      </div>
      <div class="c-no">
        <b>**** **** **** ****</b>
        <i class="bi bi-eye"></i>
      </div>
      <div class="c-d-text">USD - Dollar Card</div>
    </div>
    
    <div class="c-btns">
      <div class="c-btn">
        <i class="bi bi-book e"></i>
        <div>
          <b>Card details</b>
          <span>View your virtual card details</span>
        </div>
        <i class="fas fa-chevron-right"></i>
      </div>
      <div class="c-btn" onclick="showFund()">
        <i class="bi bi-wallet2 e"></i>
        <div>
          <b>Fund Card</b>
          <span>Add funds to your virtual card</span>
        </div>
        <i class="fas fa-chevron-right"></i>
      </div>
    </div> -->
    
    <?php
     $sts_one = "NGN";
     $sql = $conn->prepare("SELECT * FROM cards WHERE unique_id = ? AND currency = ?");
     $sql->bind_param("ss", $user_id, $sts_one);
     $sql->execute();
     $res = $sql->get_result();
     if($res->num_rows > 0){
         $row = $res->fetch_assoc();
         echo '
    <div class="card">
      <div class="c-topic">
        <img src="images/1724225088350-removebg-preview.png" alt="logo" class="one">
        <img src="images/images-removebg-preview.png" alt="mastercard" class="two">
      </div>
      <div class="c-no">
        <b>'.chunk_split($row["card_number"], 4, ' ').'</b>
      </div>
      <div style="display: flex; justify-content: space-between;">
        <div class="c-d-text"><small>Card Holder</small>'.$row["card_name"].'</div>
        <div class="c-d-text"  style="text-align: center;"><small>Expire Date</small>'.date("y/m", strtotime($row["exp_date"])).'</div>
        <div class="c-d-text" style="text-align: right;"><small>CVV</small>'.$row["cvv"].'</div>
      </div>
    </div>
    
    <div class="c-btns">
      <div class="c-btn">
        <i class="bi bi-book e"></i>
        <div>
          <b>Card details</b>
          <span>View your virtual card details</span>
        </div>
        <i class="fas fa-chevron-right"></i>
      </div>
      <div class="c-btn" onclick="showFund(`NGN`, `'.$row["reference"].'`)">
        <i class="bi bi-wallet2 e"></i>
        <div>
          <b>Fund Card</b>
          <span>Add funds to your virtual card</span>
        </div>
        <i class="fas fa-chevron-right"></i>
      </div>
    </div>
         ';
     }else{
         echo '
    <div class="no-card">
      <span>Yo dont have any NGN card yet.</span>
      <button type="button" onclick="toggNew(`NGN`)"><i class="bi bi-plus"></i> Create One</button>
    </div>
         ';
     }
    ?>
  </div>
  
  
  
  
  <div class="grid usd">
    <?php
     $sts_two = "USD";
     $sql2 = $conn->prepare("SELECT * FROM cards WHERE unique_id = ? AND currency = ?");
     $sql2->bind_param("ss", $user_id, $sts_two);
     $sql2->execute();
     $res2 = $sql2->get_result();
     if($res2->num_rows > 0){
         $row = $res2->fetch_assoc();
         echo '
    <div class="card"> 
      <div class="c-topic">
        <img src="images/1724225088350-removebg-preview.png" alt="logo" class="one">
        <img src="images/images-removebg-preview.png" alt="mastercard" class="two">
      </div>
      <div class="c-no">
        <b>'.chunk_split($row["card_number"], 4, '  ').'</b>
      </div>
      <div style="display: flex; justify-content: space-between;">
        <div class="c-d-text"><small>Card Holder</small>'.$row["card_name"].'</div>
        <div class="c-d-text" style="text-align: right;"><small>CVV</small>'.$row["cvv"].'</div>
      </div>
    </div>
    
    <div class="c-btns">
      <div class="c-btn">
        <i class="bi bi-book e"></i>
        <div>
          <b>Card details</b>
          <span>View your virtual card details</span>
        </div>
        <i class="fas fa-chevron-right"></i>
      </div>
      <div class="c-btn" onclick="showFund(`NGN`, `'.$row["reference"].'`)">
        <i class="bi bi-wallet2 e"></i>
        <div>
          <b>Fund Card</b>
          <span>Add funds to your virtual card</span>
        </div>
        <i class="fas fa-chevron-right"></i>
      </div>
    </div>
         ';
     }else{
         echo '
            <div class="no-card">
              <span>Yo dont have any USD card yet.</span>
              <button type="button" onclick="toggNew(`USD`)"><i class="bi bi-plus"></i> Create One</button>
            </div>
         ';
     }
    ?>
  </div>
  
  
  
  
  
  <div class="fix-form no" id="fund-form">
    <form id="card-fund-form">
      <div class="f-topic">
        <span>Fund Card</span>
        <button type="button" onclick="showFund()">Cancel</button>
      </div>
      
      <input type="text" name="card-fund-currency" id="card-fund-currency" hidden>
      <input type="text" name="card-id" id="card-id" hidden>
      
      <div class="inputs">
        <span>Amount</span>
        <input type="number" name="fund-card-amount" id="fund-card-amount" placeholder="1000">
      </div>
      <button type="button" class="form-button" onclick="fundCard(this)">SUBMIT</button> 
    </form>
  </div>
  
  
  
  
  <!------------------------- create new card -------------------------------->
  <div class="fix-form no" id="new-form">
    <form id="new-card-form">
      <div class="f-topic">
        <span>Create new card</span>
        <button type="button" onclick="toggNew()">Cancel</button>
      </div>
      
      <div class="inputs disabled">
        <span>Name on card</span>
        <input type="text" name="card-name" id="card-name" placeholder="Jhon Doe" value="<?php echo $user["fname"].' '.$user["lname"]; ?>" oninput="checkValue('card-name', 'card-name-err', '', 'empty', 'Invalid card name', '')" disabled>
        <b id="card-name-err"></b>
      </div>
      <div class="inputs disabled">
        <span>Card Type</span>
        <input type="text" name="card-brand" id="card-brand" value="mastercard" placeholder="mastercard, visa" oninput="checkValue('card-brand', 'card-brand-err', '', 'empty', 'Invalid card type', '')" disabled>
        <b id="card-brand-err"></b>
      </div>
      <div class="inputs">
        <span>Postal Code</span>
        <input type="number" name="postal-code" id="postal-code" placeholder="08975709" oninput="checkValue('postal-code', 'postal-code-err', '5', 'length', 'Invalid postal-code', '')">
        <b id="postal-code-err"></b>
      </div>
            <div class="inputs">
        <span>Date of Birth</span>
        <input type="date" name="dob" id="dob" placeholder="YYYY/MM/DD" oninput="checkValue('dob', 'dob-err', '', 'empty', 'Invalid date of birth', '')">
        <b id="dob-err"></b>
      </div>
      <div class="inputs">
        <span>Currency</span>
        <select name="currency" id="currency" onchange="checkValue('currency', 'currency-err', '', 'empty', 'Please select currency', '')">
          <option value="">-- Select Currency --</option>
          <option value="NGN">NGN</option>
          <option value="USD">USD</option>
        </select>
        <b id="currency-err"></b>
      </div>
      <div class="inputs">
        <span>Amount to fund on card</span>
        <input type="number" name="fund-amount" id="fund-amount" placeholder="1000" oninput="checkValue('fund-amount', 'fund-amount-err', '', 'empty', 'Please enter amount', '')">
        <b id="fund-amount-err"></b>
        <b class="small-text">* Minimum funding is $5 for USD *</b>
        <b class="small-text">* Minimum funding is &#x20a6;5,000 *</b>
        <b class="small-text">* $5 - &#x20a6;8,000 *</b>
        <b class="small-text">* Card creation charges $1 - &#x20a6;1,600 *</b>
      </div>
      <button type="button" class="form-button" onclick="createCard(this)">SUBMIT</button>
    </form>
  </div>
  
  
  
  <script>
  <?php include "js/msg.js"; ?>
    function getId(idName){
      return document.getElementById(idName);
    }
    
    
    function toggleCurrency(thisBtn, showName){
      const grid = document.querySelectorAll(".grid");
      grid.forEach(grids => grids.classList.remove("active"));
      document.querySelector(showName).classList.add("active");
      
      const allBtn = document.querySelectorAll(".sep-btn button");
      allBtn.forEach(allB => allB.classList.remove("active"));
      thisBtn.classList.add("active");
    }
    
    
    function toggNew(idVal){
      getId("new-form").classList.toggle("no");
      getId("currency").value = idVal;
    }
    
    
    function showFund(cur, ref){
      getId("fund-form").classList.toggle("no");
      getId("card-fund-currency").value = cur;
      getId("card-id").value = ref;
    }
    
    function createCard(thisBtn){
        const cName = getId("card-name");
        const cBrand = getId("card-brand");
        const pCode = getId("postal-code");
        const dob = getId("dob");
        const currency = getId("currency");
        const amount = getId("fund-amount");
        const newCardForm = getId("new-card-form");
        let min = 8000;
        if(currency.value === "NGN"){
            min = 1000;
        }
        
        if(cName.value === "" || cBrand.value === "" || pCode.value.length < 5 || dob.value === "" || currency.value === "" || amount.value < min){
            cName.dispatchEvent(new Event("input"));
            cBrand.dispatchEvent(new Event("input"));
            pCode.dispatchEvent(new Event("change"));
            dob.dispatchEvent(new Event("change"));
            currency.dispatchEvent(new Event("change"));
            if(amount.value < min){
                showMessage("bi bi-exclamation-circle", "Minimum funding is " + min + " for " + currency.value, "err");
            }
        }else{
            let formerTxt = thisBtn.innerText;
            showP(thisBtn);
            fetch("server/create-card.php", {
                method: "POST",
                body: new FormData(newCardForm),
            })
            .then(response => response.text())
            .then(data => {
                removeP(thisBtn, formerTxt);
                if(data.includes("success")){
                    showMessage("bi bi-check-circle", data, "suc");
                    setTimeout(()=> {
                        window.location.reload();
                    }, 2000);
                }else{
                    showMessage("bi bi-exclamation-circle", data, "err");
                }
            })
        }
    }
    
    function fundCard(thisBtn){
        const fundForm = getId("card-fund-form");
        const cur = getId("card-fund-currency");
        const amount = getId("fund-card-amount");
        
        let min = 8000;
        
        if(cur.value === "NGN"){
            min = 1000;
        }
        
        if(amount.value < min){
            showMessage("bi bi-exclamation-circle", "Minimum funding for " + cur.value + " is " + min, "err");
        }else{
            let formerTxt = thisBtn.innerText;
            showP(thisBtn);
            fetch("server/fund-card.php", {
                method: "POST",
                body: new FormData(fundForm),
            })
            .then(response => response.text())
            .then(data => {
                removeP(thisBtn, formerTxt);
                if(data.includes("success")){
                    showMessage("bi bi-check-circle", data, "suc");
                    setTimeout(()=> {
                        window.location.reload();
                    }, 2000);
                }else{
                    showMessage("bi bi-exclamation-circle", data, "err");
                }
            })
        }
    }
  </script>
</body>
</html>