<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$verification = Control::fetchVerification($conn, $user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Email Verification || mBills #easylifeishere</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    .vr-bx{
        width: 320px;
        padding: 16px;
        margin-bottom: 20px;
        border-radius: 7px;
        border: 2px solid rgba(0%, 70%, 0%, 20%);
        background: rgba(0%, 70%, 0%, 10%);
        font-size: 11px;
        font-weight: 300;
        color: rgba(0%, 70%, 0%);
    }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Utility Bill Verification</span>
  </div>
  
  <form class="form-box" id="utility-form" enctype="multipart/form-data">
    <?php
     if(!empty($verification["utility_bill"])){
         header("Location: account-verification..php");
         exit();
     }
    ?>
    <div class="f-head">Kindly upload your utility image to verify</div>
    
    <div class="s-txt"></div>
    
    <div class="inputs">
      <span>Upload Image</span>
      <input type="file" accept=".jpg, .png, .jpeg, .webp" name="utility" id="utility" value="<?php echo trim(str_replace("_verifying", "", $verification["nin"])); ?>" onchange="checkValue('utility', 'utility-err', '', 'empty', 'PLease upload utility bill Image', '')">
      <b id="utility-err"></b>
    </div>
    <button type="button" class="button" onclick="submitUtility(this)">SUBMIT</button>
    
  </form>
  
  
  <div class="more-txt">
    For more information on what we do with and why we need your data. Please read our
    <a href="terms-and-condition.php">Terms & Services.</a>
  </div>
  
  <script>
    <?php include "js/msg.js"; ?>
    function resendOtp(thisInn){
        startCount(30, "resend", "Resend OTP");
    }
    
    function getId(idName){
        return document.getElementById(idName);
    }
    
    const utilityForm = getId("utility-form");
    function submitUtility(thisBtn){
        const utility = getId("utility");
        if(utility.value === ""){
            utility.dispatchEvent(new Event("change"));
        }else{
            let formerTxt = thisBtn.innerText;
            showP(thisBtn);
            fetch("server/verify-utility.php", {
                method: "POST",
                body: new FormData(utilityForm),
            })
            .then(response => response.text())
            .then(data => {
                removeP(thisBtn, formerTxt);
                if(data.includes("success")){
                  showMessage("bi bi-check2-circle", data, "suc");
                  window.location.reload();
                }else{
                  showMessage("bi bi-exclamation-circle", data, "err");
                }
            });
        }
    }
  </script>
  </body>
</html>