<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>User Transfer</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    
    }
    body{
      font-family: "Teko", sans-Serif;
    }
    <?php include "css/animation.css"; ?>
  </style>
</head>
<body class="">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>To Buypoint</span>
    <i class="fas fa-history" onclick="window.location.href='tranx.php';"></i>
        <!-- <div class="i-notify">
      <i class="ri-notification-line"></i>
    </div>
    
    <div class="d-b">
      <button class="d-btn" onclick="showDetails(this)"><img src="Uploads/avatar.png" alt="Profile Image"><i class="fas fa-chevron-down"></i></button>
      
      <div class="d-b-detail">
       <a href="profile.php"><button><i class="fas fa-user-circle"></i> Profile</button></a>
       <a href="setting.php"><button><i class="fas fa-cog"></i> Settings</button></a>
       <a href="logout.php"><button class="logout"><i class="fas fa-sign-out"></i> Log Out</button></a>
      </div>
    </div>
  
    <script>
      function showDetails(thisB){
        if(thisB.classList.contains("drop")){
          thisB.classList.add("drop-timer");
          setTimeout(()=> {
            thisB.classList.remove("drop-timer");
            thisB.classList.remove("drop");
          }, 280)
        }else{
          thisB.classList.add("drop");
        }
      }
    </script> -->  </div>
  <form class="serviceBox" id="transfer-form">
    <select name="bank" id="bank" onchange="checkValue('bank', 'bank-err', '', 'empty', 'Select Bank', '')" hidden>
      <option value="0505" selected>Buypoint</option>
    </select>
    
    
    
    <div class="inputs" id="phone:inputs" style="margin-top: 0;"><img src="logos/20241215_111230.jpg" alt="Header Image" style="border-radius: 10px; max-width: 100%; height: auto;">
      <span>Recipent Account</span>
      <input type="number" name="account-no" id="account-no" placeholder="Phone Number" oninput="checkValue('account-no', 'account-no-err', 10, 'length', 'Invalid account number', '')" pattern="[0-9]{11}" maxlength="10">
      <b id="account-no-err"></b>
    </div>
    


    <div class="inputs" id="amount:inputs">
      <span>Amount</span>
      <input type="tel" name="amount" id="amount" placeholder="1000" oninput="checkValue('amount', 'amount-err', 100, 'value', 'Enter a valid amount minimum(&#x20a6;50)', '')">
      <b id="amount-err"></b>
    </div>
    


    <div class="inputs" id="narration:inputs">
      <span>Narration</span>
      <input type="text" name="narration" id="narration" placeholder="Sent from Buypoint">
    </div> 
    
    
    <input type="text" name="bank-name" id="bank-name" value="Buypoint" hidden>
    <input type="text" name="account-name" id="account-name" hidden>
    <input type="text" name="session-id" id="session-id" hidden>
    
    
    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="number" class="disabled" name="discount" id="discount" placeholder="0.00" disabled>
    </div> 
    
        <div class="pay-method">
      <h2>How would you like to pay?</h2>
      <div>
        <input type="checkbox" name="pay_with_balance" id="pay_with_balance" checked disabled>
        <i class="bi bi-square"></i>
        <i class="bi bi-check-square-fill" style="color:blue"></i>
        <label for="pay_with_balance"><?php echo $user["format_balance"]; ?></label>
      </div>
    </div>    
        <div class="pin-body">
      <div class="pin-head">
       <button type="button" onclick="closePin(`pin-body`)">
          <i class="fas fa-arrow-left"></i>
          close
       </button>
        <h3>Confirm PIN</h3>
      </div>
      
      <div class="pin-txt">To proceed with this transaction, kindly enter your PIN</div>
      
     <div class="pin-inputs">
        <input type="password" inputmode="numeric" pattern="[0-9]*" id="pin-0" name="pin-1" maxlength="1" placeholder="•" oninput="moveToNext(this, `1`)" onkeydown="moveToPrev(event, `0`)">
        <input type="password" inputmode="numeric" pattern="[0-9]*" id="pin-1" name="pin-2" maxlength="1" placeholder="•" oninput="moveToNext(this, `2`)" onkeydown="moveToPrev(event, `1`)">
        <input type="password" inputmode="numeric" pattern="[0-9]*" id="pin-2" name="pin-3" maxlength="1" placeholder="•" oninput="moveToNext(this, `3`)" onkeydown="moveToPrev(event, `2`)">
        <input type="password" inputmode="numeric" pattern="[0-9]*" id="pin-3" name="pin-4" maxlength="1" placeholder="•" oninput="moveToNext(this, `4`)" onkeydown="moveToPrev(event, `3`)">
      </div>
      
      <div class="forgot-pin">
        Forgot PIN? <a href="setting.php">Reset Here</a>
      </div>
      
      <div class="pin-detail">
        <h2>Confirm Details <i class="bi bi-check2-circle"></i></h2>
        <table>
          <tr>
            <td>Bank</td>
            <td id="input-b"></td>
          </tr>
          <tr>
            <td>Account Name</td>
            <td id="input-nm"></td>
          </tr>
          <tr>
            <td>Total Amount</td>
            <td id="input-a"></td>
          </tr>
          <tr>
            <td>Narration</td>
            <td id="input-n"></td>
          </tr>
        </table>
      </div>
      
      <div class="pin-btn">
        <button type="button" onclick="sendMoney(this)">PAY</button>
      </div>
    </div>    
    <a href="dashboard.php" style="text-decoration: none; color: #3333ff"><i class="ri-home-smile-2-line">Dashboard</i></a>
    <button class="showPin" type="button" onclick="showPin()">PROCEED<i class="fas fa-arrow-right"></i></button>
  </form>
  
    <div class="form-f no" id="r-c-pin" onclick="showForm('r-c-pin', 'close', 'none', 250)">
    <form class="form" id="reset-form" onclick="event.stopPropagation()">
      <div class="f-head">
        <button type="button" onclick="showForm('r-c-pin', 'close', 'none', 250)"><i class="fas fa-times"></i> close</button>
        <span>Reset Transaction PIN</span>
      </div>
      
      <div class="f-txt green" id="put-msg"></div>
      
      <input type="text" name="type" value="pin" hidden>
      
      <input type="email" name="email" value="info@buypoint.com.ng" hidden>
      
      <div class="inputs">
        <span>Enter OTP Code</span>
        <input type="tel" class="i-input" name="otp-code" id="otp-code" placeholder="123478" maxlength="6" oninput="checkValue('otp-code', 'otp-code-err', 6, 'length', 'Invalid OTP code required(4 Digits)', '')">
        <b id="otp-code-err"></b>
      </div>
      
      <div class="inputs">
        <span>New PIN</span>
        <input type="tel" class="normal-i" name="r-new-pin" id="r-new-pin" placeholder="1234" maxlength="4" oninput="checkValue('r-new-pin', 'r-new-pin-err', 4, 'length', 'Invalid PIN required(4 Digits)', '')">
        <b id="r-new-pin-err"></b>
      </div>
      
      <div class="inputs">
        <span>Confirm PIN</span>
        <input type="tel" class="normal-i" name="r-confirm-pin" id="r-confirm-pin" placeholder="1234" maxlength="4" oninput="checkValue('r-confirm-pin', 'r-confirm-pin-err', document.getElementById('r-new-pin').value, 'not equal', 'Comfirm pin does not match new pin', '')">
        <b id="r-confirm-pin-err"></b>
      </div>
      
      <button type="button" class="f-s-btn" onclick="resetPin(this)">SUBMIT</button>
    </form>
  </div>
  <script>
    const otp_code = document.getElementById("otp-code");
    const r_new_pin = document.getElementById("r-new-pin");
    const c_new_pin = document.getElementById("r-confirm-pin");
    const reset_form = document.getElementById("reset-form");
    let sent = false;
    
    function resetPin(thisB){
      let formerTxt = thisB.innerHTML;
      if(otp_code.value.length < 6 || r_new_pin.value.length < 4 || r_new_pin.value.length > 4 || c_new_pin.value !== r_new_pin.value){
        otp_code.dispatchEvent(new Event("input"));
        r_new_pin.dispatchEvent(new Event("input"));
        c_new_pin.dispatchEvent(new Event("input"));
      }else{
        showP(thisB);
        fetch("server/reset-pin.php", {
          method: "POST",
          body: new FormData(reset_form),
        })
        .then(response => response.text())
        .then(data => {
          removeP(thisB, formerTxt);
          if(data.includes("success")){
            showMessage("bi bi-check2-circle", data, "suc");
            showForm('r-c-pin', 'close', 'none', 250)
          }else{
            showMessage("bi bi-exclamation-circle", data, "err");
          }
        })
      }
    }
    
        function sendMail(){
            fetch("server/send-reset-otp.php", {
                method: "POST",
                body: new FormData(reset_form),
            })
            .then(response => response.text())
            .then(data => {
              showMessage("bi bi-check-circle", data, "err");
              const pMsg = getId("put-msg");
              if(data.includes("INBOX")){
                  pMsg.innerHTML = data;
                  pMsg.classList.remove("red");
                  pMsg.classList.add("green");
              }else{
                  pMsg.innerHTML = data;
                  pMsg.classList.remove("green");
                  pMsg.classList.add("red");
              }
            })
        }
  </script>  
  <script>
     function showMessage(classIcon, message, classN, cancelF, okF){
    let classL = "";
    let title = "";
    if(classN == "err"){
      classL = "alertErr";
      title = "ERROR!";
    }else if(classN == "suc"){
      classL = "alertSuc";
      title = "SUCCESS!";
    }else if(classN == "ver"){
      classL = "alertSuc";
      title = "VERIFY!";
    }
    const newMsg = document.createElement("div");
    const cBtn = document.createElement("button");
    cBtn.innerHTML = "cancel";
    cBtn.id = "cancelBtn";
    cBtn.style.transition = "background 0.5s";
    const okBtn = document.createElement("button");
    okBtn.innerHTML = "ok";
    okBtn.id = "okBtn";
    okBtn.style.transition = "background 0.5s";
    newMsg.innerHTML = `
     <div class="adiv" id="adiv-box">
      <i class="${classIcon}" style="font-size: 50px;${classIcon.includes("bi") ? 'margin-bottom: -5px; margin-top: 11px;' : ''}"></i>
      <h2 style="font-size:18px; font-weight:900; color:#222; margin-bottom:2px; padding-left:20px; padding-right:20px; font-size: 14px;">${title}</h2>
      <span style="padding-left:20px; padding-right:20px; font-size: 11px; letter-spacing:0.6px; font-family: var(--mitr)">${message.replace("minimum", "minimum")}</span>
      <div class="button">
      
      </div>
     </div>
    `;
    newMsg.classList.add(classL);
    document.body.appendChild(newMsg);
    
    newMsg.querySelector(".button").appendChild(cBtn);
    newMsg.querySelector(".button").appendChild(okBtn);
    
    
    okBtn.addEventListener("click", ()=> {
      newMsg.style.opacity = "0.1";
      setTimeout(()=> {
        document.body.removeChild(newMsg);
        if(okF !== ""){
          okF();
        }
      }, 250);
    })
    
    
    cBtn.addEventListener("click", ()=> {
      newMsg.style.opacity = "0.1";
      setTimeout(()=> {
        document.body.removeChild(newMsg);
        if(cancelF !== ""){
          cancelF();
        }
      }, 250);
    })
    
  }
   
  function showP(btnIdTo){
    btnIdTo.style.opacity = "0.2";
    btnIdTo.innerHTML = "<div class='spin'></div>";
    btnIdTo.disabled = true;
  }
   
  function removeP(btnIdTo, formerTxt){
    btnIdTo.style.opacity = "1";
    btnIdTo.innerHTML = formerTxt;
    btnIdTo.disabled = false;
  }
    function moveToNext(thisInpGet, nextMove){
      if(thisInpGet.value.length === thisInpGet.maxLength){
        document.getElementById("pin-" + nextMove).focus();
      }
    }
    
    function moveToPrev(event, nextMove){
      if(event.key == "Backspace"){
        document.getElementById("pin-" + nextMove).value = "";
        document.getElementById("pin-" + (nextMove - 1)).focus();
      }
    }
    
    function goBack(){
      window.history.back();
    }
    
    function closePin(pinBox){
      const pinBxGet = document.querySelector("." + pinBox);
      pinBxGet.style.transition = "0.4s";
      pinBxGet.style.transform = "translateY(120%)";
      setTimeout(()=> {
        pinBxGet.style.display = "none";
        pinBxGet.style.transform = "translateY(0%)";
      }, 250)
    }
  
    function toggSelect(btnToGet, valueToSel, theValue, thisBtnId, clrBgAdd){
      document.getElementById(valueToSel).value = theValue;
      const selectButton = document.querySelectorAll(`.${btnToGet}`);
      selectButton.forEach(selEach => {
        selEach.classList.remove("active")
        selEach.style.background = "";
        selEach.querySelector("span").style.display = "none";
      });
      const selBtnGt = selectButton[thisBtnId];
      const selSpan = selBtnGt.querySelector("span");
      selBtnGt.classList.add("active");
      if(clrBgAdd == "MTN"){
        selBtnGt.style.background = "rgba(100%, 70%, 0%)";
        selSpan.style.color = "rgba(100%, 60%, 0%)";
      }else if(clrBgAdd == "GLO"){
        selBtnGt.style.background = "rgba(0%, 85%, 0%)";
        selSpan.style.color = "rgba(0%, 60%, 0%)";
      }else if(clrBgAdd == "9MOBILE"){
        selBtnGt.style.background = "rgba(15%, 0%, 0%)";
        selSpan.style.color = "rgba(15%, 0%, 0%)";
      }else if(clrBgAdd == "AIRTEL" || clrBgAdd == "STARTIME"){
        selBtnGt.style.background = "rgba(80%, 0%, 0%)";
        selSpan.style.color = "rgba(80%, 0%, 0%)";
      }else if(clrBgAdd == "DSTV"){
        selBtnGt.style.background = "rgba(0%, 50%, 70%)";
        selSpan.style.color = "rgba(0%, 40%, 60%)";
      }else if(clrBgAdd == "GOTV"){
        selBtnGt.style.background = "hsl(0, 0%, 85%)";
        selSpan.style.color = "hsl(0, 0%, 20%)";
      }else if(clrBgAdd == "WAEC"){
        selBtnGt.style.background = "rgba(50%, 0%, 50%)";
        selSpan.style.color = "rgba(50%, 0%, 50%)";
      }else if(clrBgAdd == "NECO" || clrBgAdd == "NABTEB"){
        selBtnGt.style.background = "rgba(0%, 60%, 0%)";
        selSpan.style.color = "rgba(0%, 60%, 0%)";
      }
      selSpan.style.display = "block";
      document.getElementById(valueToSel).dispatchEvent(new Event("change"));
    }
    
  function checkValue(valueToCheck, errPut, valueLess, type, errMsg, successErrMsg, sucMessage){
    let check = "";
    let valueGet_t = "";
    const valueGet = document.getElementById(valueToCheck);
    valueGet_t = document.getElementById(valueToCheck);
    if(type == "length"){
      check = valueGet.value.length < valueLess;
    }else if(type == "value"){
      check = valueGet.value < valueLess;
    }else if(type == "not equal"){
      check = valueGet.value !== valueLess;
    }else if(type == "equal"){
      check = valueGet.value == valueLess;
    }else if(type == "empty"){
      check = valueGet.value == valueLess;
    }else if(type == "email"){
      const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      check = regex.test(valueGet.value) == false;
    }else if(type == "url"){
      const regex = /^(https?:\/\/)?([^\s$.?#].[^\s]*)\.[a-z]{2,}([^\s]*)$/i;
      check = regex.test(valueGet.value) == false;
    }else if(type == "phone"){
      const regex = /^\d{11}$/;
      check = regex.test(valueGet.value) == false;
    }else if(type == "email or phone"){
      const regex_t = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      const regex = /^\d{11}$/;
      check = regex.test(valueGet.value) == false && regex_t.test(valueGet.value) ==  false;
    }
    const createIcon = document.createElement("i");
    createIcon.id = "check";
    if(check){
      const innPut = document.getElementById(errPut);
      if(innPut.innerHTML.includes("</i>")){
        innPut.innerHTML = `<b class='err' style="margin-left:3px; font-weight:500; font-size:11.2px; margin-top:5px; color: rgba(80%, 0%, 0%); display: flex; font-family: var(--mitr); letter-spacing: 0.4px; animation: over 0.5s;">${errMsg}</b>`;
      }else if(innPut.innerHTML === ""){
        innPut.innerHTML = `<b class='err' style="margin-left:3px; font-weight:500; font-size:11.2px; margin-top:5px; color: rgba(80%, 0%, 0%); display: flex; font-family: var(--mitr); letter-spacing: 0.4px; animation: over 0.5s;">${errMsg}</b>`;
      }
      valueGet_t.style.border = "1px solid rgba(90%, 0%, 0%)";
      createIcon.className = "fas fa-info-circle";
      createIcon.id = "checkErr";
      
      document.getElementById(valueToCheck + ":1").style.border = "1px solid rgba(80%, 0%, 0%)";
    }else{
      if(successErrMsg !== ""){
        const innPut = document.getElementById(errPut);
        innPut.innerHTML = `<b class="suc">${sucMessage}</b>`;
        
        valueGet_t.style.border = "";
        createIcon.className = "fas fa-check-circle";
        createIcon.id = "check";
        
      document.getElementById(valueToCheck + ":1").style.border = "";
      }else{
        const innPut = document.getElementById(errPut);
        innPut.innerHTML = "";
        
        valueGet_t.style.border = "";
        createIcon.className = "fas fa-check-circle";
        createIcon.id = "check";
        
        document.getElementById(valueToCheck + ":1").style.border = "";
      }
    }
  }
  
  function showChecking(checkingR, msg){
    checkingR.innerHTML = `
      <b class='err' style="margin-left:3px; font-weight:600; font-size:11px; margin-top:5px; color: rgba(0%, 60%, 0%); display: flex; font-family: var(--mitr); letter-spacing: 0.4px;">
      <i class="fas fa-spinner fa-spin" style="margin-right: 6px;"></i>
      ${msg}
      </b>
    `;
  }
  
  function showError(checkingR, msg){
    checkingR.innerHTML = `
      <b class='err' style="margin-left:3px; font-weight:600; font-size:11px; margin-top:5px; color: rgba(90%, 0%, 0%); display: flex; font-family: var(--mitr); letter-spacing: 0.4px;">
      <i class="bi bi-x-circle" style="margin-right: 6px;"></i>
      ${msg}
      </b>
    `;
  }
  
  function showSuccess(checkingR, msg){
    checkingR.innerHTML = `
      <b class='err' style="margin-left:3px; font-weight:600; font-size:11px; margin-top:5px; color: rgba(0%, 60%, 0%); display: flex; font-family: var(--mitr); letter-spacing: 0.4px;">
      <i class="bi bi-check-circle" style="margin-right: 6px;"></i>
      ${msg}
      </b>
    `;
  }
  
  function addActive(dropToAdd, planDetail){
    const get_drop_icon = dropToAdd.querySelector("i");
    document.querySelectorAll(".drop-btn").forEach(allDrop => {
      if(allDrop.classList.contains("active")){
        allDrop.click();
      }
    })
    
    
    if(dropToAdd.classList.contains("active")){
      const plan_detail_get = document.getElementById(planDetail)
      plan_detail_get.style.height = "0px";
      get_drop_icon.className = "fas fa-chevron-down";
      
      setTimeout(()=> {
       dropToAdd.classList.remove("active");
       plan_detail_get.style.height = "";
      }, 300);
    }else{
       dropToAdd.classList.add("active");
       get_drop_icon.className = "fas fa-chevron-up";
    }
  }
  
  function removeDrop(to_select, select_value, thisBtn, queryAll, toClick){
    const toS = document.getElementById(to_select);
    toS.value = select_value;
    toS.dispatchEvent(new Event("change"));
    const cl = document.getElementById(toClick);
    
    const cl_r = (toClick.replace(":", "")).replace("1", "") + ":inputs";
    const d_g = document.getElementById(cl_r);
    
    const select_all_divs = d_g.querySelectorAll("." + queryAll);
    select_all_divs.forEach(toRemove => {
      toRemove.classList.remove("active");
      if(toRemove.querySelector("input")){
        toRemove.querySelector("input").remove();
      }
    });
    thisBtn.classList.add("active");
    
    const newInput = document.createElement("input");
    newInput.type = "checkbox";
    newInput.setAttribute("checked", true);
    newInput.disabled = true;
    newInput.className = "input";
    thisBtn.appendChild(newInput);
    
    cl.click();
    cl.querySelector("span").innerHTML = thisBtn.querySelector("span").innerHTML;
  }
  
  function greetUser(to_put){
     const msg_inn = document.getElementById(to_put);
     const newadate = new Date();
     const timeNow = newadate.getHours();
     if(timeNow < 12){
       msg_inn.innerHTML = "Good Morning";
     }else if(timeNow < 18){
       msg_inn.innerHTML = "Good Afternoon";
     }else{
       msg_inn.innerHTML = "Good Evening";
     }
  }
  
   function copyTxt(textValue){
     const newTextArea = document.createElement("textarea");
     newTextArea.value = textValue;
     document.body.appendChild(newTextArea);
     newTextArea.select();
     newTextArea.setSelectionRange(0, 9999);
     document.execCommand("copy");
     document.body.removeChild(newTextArea);
     showMessage("bi bi-check2-circle", "Copied To Clipboard", "suc");
   }
   
    function startCount(count_txt, couIn, resend_txt){
        let count = count_txt;
        let interval = setInterval(() => {
          count--;
          const resendBtn = document.getElementById(couIn);
          resendBtn.innerHTML = "Resend In " + count;
          resendBtn.disabled = true;
          resendBtn.classList.add("disabled");
          
          if(count < 1){
            resendBtn.innerHTML = resend_txt;
            resendBtn.disabled = false;
            count = count_txt;
            clearInterval(interval);
            resendBtn.classList.remove("disabled");
          }
        }, 1000);
    }
    
    
document.querySelectorAll("button").forEach(allButton => {
    allButton.addEventListener("mousemove", (event)=> {
      createRipple(event, true, "");
    });
  });

  function createRipple(event, isClick, thisE) {
    var el = event.currentTarget;
    var btnWidth = el.clientWidth;
    var elRect = el.getBoundingClientRect();
    var rippleOffset = 0;
    var btnOffsetTop = elRect.top + rippleOffset;
    var btnOffsetLeft = elRect.left;
    var posMouseX = isClick ? event.clientX : elRect.left + btnWidth / 2;
    var posMouseY = isClick ? event.clientY + rippleOffset : elRect.top + btnWidth / 2 + rippleOffset;
    var rippleX = posMouseX - btnOffsetLeft;
    var rippleY = posMouseY - btnOffsetTop;
    if(thisE === "black"){
      var baseCSS = "\n          position: absolute;\n          width: " + btnWidth * 2 + "px;\n          height: " + btnWidth * 2 + "px;\n          border-radius: 50%;\n          transition: transform 1500ms, opacity 0.2;\n          transition-timing-function: cubic-bezier(0.250, 0.460, 0.450, 0.940);\n          background: #0005;\n          background-position: center;\n          background-repeat: no-repeat;\n          background-size: 100%;\n          left: " + (rippleX - btnWidth) + "px;\n          top: " + (rippleY - btnWidth) + "px;\n          transform: scale(0);\n          pointer-events: none;\n      ";
    }else{
      var baseCSS = "\n          position: absolute;\n          width: " + btnWidth * 2 + "px;\n          height: " + btnWidth * 2 + "px;\n          border-radius: 50%;\n          transition: transform 1500ms, opacity 100ms;\n          transition-timing-function: cubic-bezier(0.250, 0.460, 0.450, 0.940);\n          background: #fff;\n          background-position: center;\n          background-repeat: no-repeat;\n          background-size: 100%;\n          left: " + (rippleX - btnWidth) + "px;\n          top: " + (rippleY - btnWidth) + "px;\n          transform: scale(0.2);\n";
    }
    // Prepare the dom
    var rippleEffect = document.createElement("span");
    rippleEffect.style.cssText = baseCSS;

    // Add some css for prevent overflow errors
    el.style.overflow = "hidden";

    // Check if the element is not static because the ripple is in absolute
    if (window.getComputedStyle(el).position === "static") {
        el.style.position = "relative";
    }

    el.appendChild(rippleEffect);

    // start animation
    requestAnimationFrame(function () {
        rippleEffect.style.cssText = baseCSS + " transform: scale(1); opacity: 0.1;";
    });

    setTimeout(function () {
        rippleEffect.remove();
    }, 1000);
  }      function showForm(formId, form_t, form_d, delay){
     const formGt = document.getElementById(formId);
     if(form_t == "open"){
       formGt.style.display = form_d;
     }else if(form_t == "close"){
       formGt.classList.add("r");
       setTimeout(()=> {
         formGt.classList.remove("r");
         formGt.style.display = form_d;
         formGt.querySelector("form").reset();
       }, delay);
     }
   }
   function showFormT(formId, form_t, form_d, delay){
     const formGt = document.getElementById(formId);
     if(form_t == "open"){
       formGt.style.display = form_d;
       sendMail();
     }else if(form_t == "close"){
       formGt.classList.add("r");
       setTimeout(()=> {
         formGt.classList.remove("r");
         formGt.style.display = form_d;
         formGt.querySelector("form").reset();
       }, delay);
     }
   }
   function eyeClick(input_id, thisC, eye_class){
     const inputGt = document.getElementById(input_id);
     if(thisC.className == "ri-eye-line"){
       inputGt.type = eye_class;
       thisC.className = "ri-eye-off-line";
     }else{
       inputGt.type = "password";
       thisC.className = "ri-eye-line";
     }
   }
  
  function showResetPin(){
    showForm('r-c-pin', 'open', 'flex', '');
  }   
   const transfer_form = document.getElementById("transfer-form");
   const bank = document.getElementById("bank");
   const account_no = document.getElementById("account-no");
   const account_name = document.getElementById("account-name");
   const bank_name = document.getElementById("bank-name");
   const account_no_err = document.getElementById("account-no-err");
   const amount = document.getElementById("amount");
   const narration = document.getElementById("narration");
   const discount = document.getElementById("discount");
   const ssId = document.getElementById("session-id");
   
   
   bank.addEventListener("change", ()=> {
     bank_name.value = bank.options[bank.selectedIndex].text;
   });
   
   
   account_no.addEventListener("input", ()=> {
     
     if(account_no.value.length > 9){
       if(bank.value === ""){
         alert(bank.value);
         bank.dispatchEvent(new Event("change"));
       }else{
         showChecking(account_no_err, "Verifying account name");
         fetch("server/verify-bank-name.php", {
           method: "POST",
           body: new FormData(transfer_form),
         })
         .then(response => response.json())
         .then(data => {
           if(data.status == true){
             account_name.value = data.account_name;
             ssId.value = data.session_id;
             showSuccess(account_no_err, data.account_name);
           }else{
             ssId.value = "";
             account_name.value = "";
             showError(account_no_err, data.msg);
           }
         })
         .catch(err => {
           alert("Server/Network error");
         });
       }
     }
     
   });
   
   
   amount.addEventListener("input", (e)=> {
     discount.value = parseInt(e.target.value) + 10;
   });
   
   function showPin(){
     if(bank.value === "" || account_no.value.length < 10 || amount.value < 100){
       bank.dispatchEvent(new Event("change"));
       account_no.dispatchEvent(new Event("input"));
       amount.dispatchEvent(new Event("input"));
     }else if(account_name.value === ""){
       showMessage("bi bi-exclamation-circle", "Please verify bank name", "err");
     }else{
       document.getElementById("input-b").innerText = bank_name.value;
       document.getElementById("input-nm").innerText = account_name.value;
       document.getElementById("input-a").innerText = "NGN " + (discount.value).toLocaleString();
       document.getElementById("input-n").innerText = narration.value;
       document.querySelector(".pin-body").style.display = "flex";
     }
   }
   
   function sendMoney(thisBtn){
     let formerTxt = thisBtn.innerText;
     showP(thisBtn);
     
     fetch("server/send-money.php", {
       method: "POST",
        body: new FormData(transfer_form),
     })
     .then(response => response.text())
     .then(data => {
       removeP(thisBtn, formerTxt);
       if(data.includes("<table>")){
          const newD = document.createElement("div");
          newD.innerHTML = data;
          closePin("pin-body");
          document.body.appendChild(newD);
       }else{
         showMessage("bi bi-exclamation-circle", data, "err");
       }
     })
     .catch(err => {
       alert("Server/Network error");
     });
   }
  </script>
    </body>
</html>