<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/service.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Bank Transfer</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    body{
      font-family: "Teko", sans-Serif;
    }
    <?php include "css/animation.css"; ?>
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>To <?php echo $site["site_name"]; ?> <!-- Display site name -->
      </div>
</span>
    <?php include "includes/user.php"; ?>
  </div>
  <form class="serviceBox" id="transfer-form">
    <select name="bank" id="bank" onchange="checkValue('bank', 'bank-err', '', 'empty', 'Select Bank', '')" hidden>
      <option value="0505" selected>fluterpay</option>
    </select>
    
    
    
    <div class="inputs" id="phone:inputs" style="margin-top: 0;">
      <span>Recipent Account</span>
      <input type="number" name="account-no" id="account-no" placeholder="Phone Number" oninput="checkValue('account-no', 'account-no-err', 10, 'length', 'Invalid account number', '')" pattern="[0-9]{11}" maxlength="10">
      <b id="account-no-err"></b>
    </div>
    


    <div class="inputs" id="amount:inputs">
      <span>Amount</span>
      <input type="tel" name="amount" id="amount" placeholder="1000" oninput="checkValue('amount', 'amount-err', 100, 'value', 'Enter a valid amount minimum(&#x20a6;50)', '')">
      <b id="amount-err"></b>
    </div>
    


    <div class="inputs" id="narration:inputs">
      <span>Narration</span>
      <input type="text" name="narration" id="narration" placeholder="Sent from <?php echo $site["site_name"]; ?>">
    </div> 
    
    
    <input type="text" name="bank-name" id="bank-name" value="<?php echo $site["site_name"]; ?>"
" hidden>
    <input type="text" name="account-name" id="account-name" hidden>
    <input type="text" name="session-id" id="session-id" hidden>
    
    
    <div class="inputs">
      <span>Amount To Pay</span>
      <input type="number" class="disabled" name="discount" id="discount" placeholder="0.00" disabled>
    </div> 
    
    <?php include "inc/select-method.php"; ?>
    
    <?php include "inc/bank-transfer.php"; ?>
    
    <button class="showPin" type="button" onclick="showPin()">PROCEED <i class="fas fa-arrow-right"></i></button>
 
  </form>
  
  <?php include "inc/reset-pin.php"; ?>
  
  <script>
   <?php include "zn/msg.js"; ?>
   <?php include "zn/other.js"; ?>
   
   const transfer_form = document.getElementById("transfer-form");
   const bank = document.getElementById("bank");
   const account_no = document.getElementById("account-no");
   const account_name = document.getElementById("account-name");
   const bank_name = document.getElementById("bank-name");
   const account_no_err = document.getElementById("account-no-err");
   const amount = document.getElementById("amount");
   const narration = document.getElementById("narration");
   const discount = document.getElementById("discount");
   const ssId = document.getElementById("session-id");
   
   
   bank.addEventListener("change", ()=> {
     bank_name.value = bank.options[bank.selectedIndex].text;
   });
   
   
   account_no.addEventListener("input", ()=> {
     
     if(account_no.value.length > 9){
       if(bank.value === ""){
         alert(bank.value);
         bank.dispatchEvent(new Event("change"));
       }else{
         showChecking(account_no_err, "Verifying account name");
         fetch("zen/verify-bank-name.php", {
           method: "POST",
           body: new FormData(transfer_form),
         })
         .then(response => response.json())
         .then(data => {
           if(data.status == true){
             account_name.value = data.account_name;
             ssId.value = data.session_id;
             showSuccess(account_no_err, data.account_name);
           }else{
             ssId.value = "";
             account_name.value = "";
             showError(account_no_err, data.msg);
           }
         })
         .catch(err => {
           alert("zen/Network error");
         });
       }
     }
     
   });
   
   
   amount.addEventListener("input", (e)=> {
     discount.value = parseInt(e.target.value) + 10;
   });
   
   function showPin(){
     if(bank.value === "" || account_no.value.length < 10 || amount.value < 100){
       bank.dispatchEvent(new Event("change"));
       account_no.dispatchEvent(new Event("input"));
       amount.dispatchEvent(new Event("input"));
     }else if(account_name.value === ""){
       showMessage("bi bi-exclamation-circle", "Please verify bank name", "err");
     }else{
       document.getElementById("input-b").innerText = bank_name.value;
       document.getElementById("input-nm").innerText = account_name.value;
       document.getElementById("input-a").innerText = "NGN " + (discount.value).toLocaleString();
       document.getElementById("input-n").innerText = narration.value;
       document.querySelector(".pin-body").style.display = "flex";
     }
   }
   
   function sendMoney(thisBtn){
     let formerTxt = thisBtn.innerText;
     showP(thisBtn);
     
     fetch("zen/send-money.php", {
       method: "POST",
        body: new FormData(transfer_form),
     })
     .then(response => response.text())
     .then(data => {
       removeP(thisBtn, formerTxt);
       if(data.includes("<table>")){
          const newD = document.createElement("div");
          newD.innerHTML = data;
          closePin("pin-body");
          document.body.appendChild(newD);
       }else{
         showMessage("bi bi-exclamation-circle", data, "err");
       }
     })
     .catch(err => {
       alert("zen/Network error");
     });
   }
  </script>
  <?php
      $int = (INT)$user["bal"];
      $low = 100;
      if($int < $low){
          echo '
          <script>
             function redir(){
                 window.location.href = "dashboard.php";
             }
            showMessage("bi bi-info-circle", "Wallet below minimum vending amount NGN '.number_format($int).'", "ver", redir, redir);
          </script>
          ';
      }
    ?>
  </body>
</html>