<?php
session_start();
include_once "server/conn.php"; // Include your database connection
require "server/controller.php"; // Include your controller for fetching user details

if (!isset($_SESSION["pin_verify"])) {
    header("Location: login.php"); // Redirect to login if session is not set
    exit();
}

$user_id = $_SESSION["pin_verify"]; // Get the user ID from session

// Get the fingerprint data from the POST request
$data = json_decode(file_get_contents("php://input"), true);
$fingerprintData = $data['fingerprint'] ?? '';

if (empty($fingerprintData)) {
    echo json_encode(["status" => "error", "message" => "Fingerprint data is required."]);
    exit();
}

// Check if the user already has fingerprint data
$query = "SELECT fingerprint_data FROM regtable WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    if (!empty($user['fingerprint_data'])) {
        echo json_encode(["status" => "error", "message" => "Fingerprint data already exists."]);
        exit();
    }
}

// Update the user's fingerprint data in the database
$updateQuery = "UPDATE regtable SET fingerprint_data = ? WHERE id = ?";
$updateStmt = $conn->prepare($updateQuery);
$updateStmt->bind_param("si", $fingerprintData, $user_id);

if ($updateStmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Fingerprint registered successfully!"]);
} else {
    echo json_encode(["status" => "error", "message" => "Error updating fingerprint data: " . $conn->error]);
}

$updateStmt->close();
$stmt->close();
$conn->close();
?>