// sw.js

// Listen for 'install' event
self.addEventListener('install', function(event) {
  console.log('Service Worker installed');
  self.skipWaiting(); // Activate the service worker immediately
});

// Listen for 'activate' event
self.addEventListener('activate', function(event) {
  console.log('Service Worker activated');
});

// Listen for 'push' event
self.addEventListener('push', function(event) {
  const data = event.data ? event.data.json() : { title: 'No title', body: 'No body' };

  const options = {
    body: data.body,
    icon: 'logos/logo.png',
    badge: 'logos/logo.png'
  };

  event.waitUntil(
    self.registration.showNotification(data.title, options)
  );
});

// Listen for messages from the page
self.addEventListener('message', function(event) {
  if (event.data && event.data.type === 'showNotification') {
    const { title, body } = event.data;
    
    const options = {
      body: body,
      icon: 'logos/logo.png',
      badge: 'logos/logo.png'
    };

    self.registration.showNotification(title, options);
  }
});

// Optional: Handle notification click event
self.addEventListener('notificationclick', function(event) {
  event.notification.close();
  event.waitUntil(
    clients.openWindow('/')
  );
});
