<?php
session_start();
 include "server/conn.php";
 include "server/controller.php";
 
 $user_id = $_SESSION["user_id"];
 $user = Control::fetchDetail($conn, $user_id);
 
 
$sql = "SELECT type, date, status, amount, reference, description FROM transaction WHERE unique_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $user["unique_id"]);
$stmt->execute();
$query = $stmt->get_result();

$transactionTypes = array();
$transactionAmounts = array();
$transactionDates = array();
$transactionStatus = array();
$transactionReferences = array();
$transactionDescriptions = array();

while ($row = $query->fetch_assoc()) {
    $transactionTypes[] = $row["type"];
    $transactionAmounts[] = $row["amount"];
    $transactionDates[] = $row["date"];
    $transactionStatus[] = $row["status"];
    $transactionReferences[] = $row["reference"];
    $transactionDescriptions[] = $row["description"];
}


$transactionStats = array();
foreach (array_unique($transactionTypes) as $type) {
    $stats = array(
        'type' => $type,
        'count' => 0,
);
    foreach ($transactionTypes as $key => $transactionType) {
        if ($transactionType === $type) {
            $stats['count']++;
            $stats['totalAmount'] += $transactionAmounts[$key];
        }
    }
    $transactionStats[] = $stats;
}

$moneyIn = 0;
$moneyOut = 0;

foreach ($transactionTypes as $key => $transactionType) {
    if ($transactionType === 'Wallet Topup') {
        $moneyIn += $transactionAmounts[$key];
    } elseif ($transactionType === 'Transfer') {
        $moneyOut += $transactionAmounts[$key];
    }
}

// Get unique months for transactions
$months = array();
foreach ($transactionDates as $date) {
    $month = date('F Y', strtotime($date));
    $months[] = $month;
}
$uniqueMonths = array_unique($months);

// Filter transactions by month
$filteredTransactions = array();
if (isset($_GET['month'])) {
    $selectedMonth = $_GET['month'];
    foreach ($transactionDates as $key => $date) {
        $month = date('F Y', strtotime($date));
        if ($month === $selectedMonth) {
            $filteredTransactions[] = array(
                'type' => $transactionTypes[$key],
                'amount' => $transactionAmounts[$key],
            );
        }
    }
$moneyIn = 0;
    $moneyOut = 0;
    foreach ($filteredTransactions as $transaction) {
        if ($transaction['type'] === 'Wallet Topup') {
            $moneyIn += $transaction['amount'];
        } elseif ($transaction['type'] === 'Transfer') {
            $moneyOut += $transaction['amount'];
        }
    }
}


?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Transaction History || Cidapay</title>
  <style>
    <?php  
      $site = Control::site($conn);
    ?>
:root{
  --site-clr: <?php echo $site["site_color"] ?>;
  --bg: <?php echo $site["site_background"]; ?>;
  --box-shadow: 0.5px 3px 5px 2px hsl(0, 0%, 85%);
  --box-shadow-two: 0.5px 3px 5px 2px hsl(0, 0%, 83%);
  --box-shadow-three: 0 0 3px 1.1px #fff,
                      1px 1px 3px 0 hsl(0, 0%, 80%);
  --box-shadow-four: 0 0 3px 2px #fff,
                      2px 3px 3px 0 hsl(0, 0%, 80%);
  --poppins: "Poppins", Sans-Serif;
  --mitr: "Mitr", Sans-Serif;
}
body{
  font-family: var(--poppins);
  background: var(--bg);
  padding: 4px;
  margin-top:60px;
  letter-spacing: 1px;
}
body.active{
  background: hsl(0, 0%, 10%);
}
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    a{
      text-decoration: none;
    }
    a:link{
      cursor: none;
    }
    div, session, input, textarea, span, b, h1, h2, h3, h4, h5, h6, i, table, tr{
      box-sizing: border-box;
      font-family: var(--mitr);
    }
    .head{
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      height: 40px;
      background: #fff;
      display: flex;
      align-items: center;
      padding: 20px;
      height: 55px;
      z-index: 12;
    }
    body.active .head{
      background: hsl(0, 0%, 23%);
      color: hsl(0, 0%, 95%);
    }
    .head i{
      font-size: 15px;
      margin-left: 5px;
      margin-right: 27px;
    }
    .head span{
      font-size: 11px;
      color: #222;
    }
    body.active .head span{
      color: hsl(0, 0%, 95%);
    }
    .all-t{
      margin-top: 125px;
    }
    
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="window.history.back()"></i>
    <span>Statistics</span>
  </div>
<!-- Chart container -->
<canvas id="transactionChart" width="400" height="400"></canvas>

<!-- Chart.js library -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const transactionStats = <?= json_encode($transactionStats) ?>;
const labels = transactionStats.map(stat => stat.type);
const data = transactionStats.map(stat => stat.totalAmount);
const counts = transactionStats.map(stat => stat.count);

const ctx = document.getElementById('transactionChart').getContext('2d');
const transactionChart = new Chart(ctx, {
  type: 'doughnut',
  data: {
    labels: labels,
    datasets: [
      {
        label: 'Transaction Amounts',
        data: data,
        backgroundColor: [
          'rgba(255, 99, 132, 0.2)',
          'rgba(54, 162, 235, 0.2)',
          'rgba(255, 206, 86, 0.2)',
          'rgba(75, 192, 192, 0.2)',
          'rgba(153, 102, 255, 0.2)',
          'rgba(255, 159, 64, 0.2)'
        ],
        borderColor: [
          'rgba(255, 99, 132, 1)',
          'rgba(54, 162, 235, 1)',
          'rgba(255, 206, 86, 1)',
          'rgba(75, 192, 192, 1)',
          'rgba(153, 102, 255, 1)',
          'rgba(255, 159, 64, 1)'
        ],
        borderWidth: 1
      },
      {
        label: 'Transaction Counts',
        data: counts,
        backgroundColor: [
          'rgba(255, 99, 132, 0.5)',
          'rgba(54, 162, 235, 0.5)',
          'rgba(255, 206, 86, 0.5)',
          'rgba(75, 192, 192, 0.5)',
          'rgba(153, 102, 255, 0.5)',
          'rgba(255, 159, 64, 0.5)'
        ],
        borderColor: [
          'rgba(255, 99, 132, 1)',
          'rgba(54, 162, 235, 1)',
          'rgba(255, 206, 86, 1)',
          'rgba(75, 192, 192, 1)',
          'rgba(153, 102, 255, 1)',
          'rgba(255, 159, 64, 1)'
        ],
        borderWidth: 1
      }
    ]
  },
  options: {
    scales: {
      y: {
        beginAtZero: true
 }
    }
  }
});


</script>

<!-- Money In/Out Section -->
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Money In</h5>
                <p class="card-text">Total: <?= number_format($moneyIn, 2) ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Money Out</h5>
                <p class="card-text">Total: <?= number_format($moneyOut, 2) ?></p>
            </div>
        </div>
    </div>
</div>

<!-- Filter Dropdown -->
<div class="row">
    <div class="col-md-12">
        <form>
            <select name="month" onchange="this.form.submit()">
    <?php foreach ($uniqueMonths as $month) : ?>
        <option 
            value="<?= $month ?>" 
            <?= $month === $_GET['month'] ?? false ? 'selected' : '' ?>
        >
            <?= $month ?>
        </option>
    <?php endforeach; ?>
</select>

        </form>
    </div>
</div>



<div>
<h3>Transaction Legend:</h3>
<ul>
<li><span style="background-color: rgba(255, 99, 132, 0.2); padding: 5px;"></span> Transfer</li>
<li><span style="background-color: rgba(54, 162, 235, 0.2); padding: 5px;"></span> Airtime</li>
<li><span style="background-color: rgba(255, 206, 86, 0.2); padding: 5px;"></span> Data</li>
<li><span style="background-color: rgba(75, 192, 192, 0.2); padding: 5px;"></span> Wallet Topup</li>
<li><span style="background-color: rgba(153, 102, 255, 0.2); padding: 5px;"></span> Exam Pin</li>
<li><span style="background-color: rgba(255, 159, 64, 0.2); padding: 5px;"></span> Cable TV</li>
<li><span style="background-color: rgba(0, 128, 0, 0.2); padding: 5px;"></span> Bill Payment</li>
<li><span style="background-color: rgba(255, 0, 0, 0.2); padding: 5px;"></span> Withdrawal</li>
<li><span style="background-color: rgba(0, 0, 255, 0.2); padding: 5px;"></span> Deposit</li>
</ul>
</div> 