<?php
 include_once "server/conn.php";
 include "server/controller.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <title>Create Account</title>
  <style>
    @font-face {
      font-family: 'Poppins', sans-serif;
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    :root{
  --poppins: "Poppins", Sans-Serif;
  --mitr: "Mitr", Sans-Serif;
      --site-clr: linear-gradient(to left,#5e1d3d,#5e1d3d);
      --bg: hsl(0, 0%, 99%);
    }

   
       
  #password:inputs {
  position: relative;
}

#toggle-password-visibility {
  position: absolute;
  right: 10px;
  top: 50%;
  transform: translateY(-50%);
  cursor: pointer;
  z-index: 1;
}


.password-container {
  position: relative;
}

#password {
  width: 100%;
  padding-right: 25px; /* add padding for icon */
  box-sizing: border-box;
}


body {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
 background: #ffffff;
  background-size: cover;
 
}
span, h1, h2, h3, h4, h5, h6, div, button, table, p, b, i, section, form, em, input, textarea{
  font-family: 'Poppins', sans-serif;
}
a{
  text-decoration: none;
}
button{  
  letter-spacing: 0px;
}
.box{
  padding: 20px;
  border-radius: 5px;
  width: 335px;
  box-sizing: border-box;
  margin-bottom: 20px;
  margin-top: 15px;
  box-shadow: none;
  background: transparent;
  /*box-shadow: 0 4px 7px 2px #0001;*/
}
.head-two{
  margin-bottom: 3px;
  text-align: center;
}
.head-two img{
  width: 100px;
  height: 50px;
  margin-bottom: 3px;
  margin-top: 3px;
 
}
.box .head{
  margin-bottom: 22px;
  text-align: center;
}
.box .head img{
  width: 100%;
  height: 100PX;
  object-fit:cover;
  margin-bottom: 10px;
  margin-top: 5px;
 
}
.box .head h2{
  font-size: 17px;
  margin-top: 0;
  margin-bottom: 6px;
  text-align: left;
  font-weight: 800;
  color:blue;
  text-align:center;
}
.box .inputs #check{
  color: #000000;
  font-size: 15px;
  position: absolute;
  top: 41px;
  right: 7px;
  padding: 1px;
  background: #fff;
  border-radius: 50%;
}

.box .inputs #checkErr{
  color: #000000;
  font-size: 15px;
  position: absolute;
  top: 41px;
  right: 7px;
  padding: 1px;
  background: #fff;
  border-radius: 50%;
}
.box .head span{
  font-size: 13px;
  display: block;
  line-height: 17px;
  text-align: center;
  color: #777;
}
.box .inputs{
  margin-bottom: 5px;
  margin-top: 5px;
  position: relative;
 
}
.box .inputs span{
  font-size: 12px;
  color: #5e1d3d;
  font-weight: 600;
  letter-spacing: 0px;
}
.box .inputs .err i,
.box .inputs .suc i{
  font-size: 13px;
  margin-right: 7px;
}
.box .inputs .err,
.box .inputs .suc{
  padding: 2px;
  border-radius: 6px;
  font-size: 10px;
  font-weight: 00;
  display: flex;
  width: 100%;
  box-sizing: border-box;
  margin-top: 4px;
  align-items: center;
}
.box .inputs .err{
  color: rgba(80%, 0%, 0%);
}
.box .inputs .suc{
  color: rgba(0%, 60%, 0%);
}
.box .inpSep{
  display: flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
}
.box .inpSep .inputs{
  width: 48%;
}
.box .inputs input[type="password"]{
  font-size: 15px;
}
.box .inputs select,
.box .inputs input{
  padding: 15px;
  height: 55px;
  border:none;
  width: 100%;
  box-sizing: border-box;
  border-bottom: 5px solid #5e1d3d;
  font-size: 15px;
  font-weight: 500;
  outline: none;
  font-family: 'Poppins', sans-serif;
  background: var(--input-bg);
  border-radius: 15px;
}
.box .inputs input:focus{
    border-bottom-color:blue;
}
@keyframes over{
  from{
    transform: translateY(-7px);
    opacity: 0;
  }
  to{
    transform: translateY(0px);
    opacity: 1;
  }
}
@keyframes overUp{
  from{
    transform: translateY(0px);
    opacity: 1;
  }
  to{
    transform: translateY(-6px);
    opacity: 0;
  }
}
.box .inputs input::placeholder{
  font-weight: 500;
  color: #0003;
  font-size: 11px;
}

.box button.b{
  margin-top: 10px;
}
.box button{
  padding: 10px;
  height: 48px;
  border: none;
  outline: none;
  background: var(--site-clr);
  color: #fff;
  line-height: 0;
  border-radius: 15px;
  width: 100%;
  margin-top: 25px;
  font-family: 'Poppins', sans-serif;
  font-size: 11px;
  font-weight: 900;
}
.box button i{
  margin-left: 7px;
}
.box .sep{
  display: flex;
  justify-content: start;
  align-items: center;
  margin-bottom: 20px;
  margin-top: 10px;
}
.box .sep input{
  width: 11px;
  height: 11px;
}
.box .sep.t-c{
  text-align: center;
  margin-bottom: 0;
  margin-top: 35px;
  display: flex;
  justify-content: center;
}
.box .sep.t-c input{
  margin-right: 10px;
  width: 15px;
  height: 15px;
}
.box .sep.t-c label{
  font-size: 10px;
  font-weight: 600;
  font-family: 'Poppins', sans-serif;
}
.box .sep label{
  font-size: 10px;
  font-weight: 500;
  color: #333;
}
.box .link{
  text-align: center;
  font-size: 12px;
  font-weight: 500;
  color: #000;
}
.box .link a{
  color: #0000ff;
  font-weight: 600;
}
.box .link span{
  display: block;
  margin-top: 13px;
  margin-bottom: 10px;
  letter-spacing: 0.6px;
  font-size: 10px;
}
.b-b{
  display: flex;
  align-items: end;
  justify-content: flex-end;
  margin-top: 10px;
  width: 320px;
  box-sizing: border-box;
}
.b-b button{
  padding: 20px;
  height: 30px;
  background: var(--site-clr);
  color: #fff;
  font-weight: 700;
  font-size: 10px;
  line-height: 0;
  border-radius: 20px;
  border: none;
  outline: none;
  letter-spacing: 0.6px;
  font-family: 'Poppins', sans-serif;
}
.box button.resend-btn{
  border: none;
  background: transparent;
  color: var(--site-clr);
  font-size: 12px;
  font-weight: 500;
  margin-top: 10px;
  width: auto;
  padding: 0;
}
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 26px;
  border-radius: 15px;
  background: #fff;
  width: 260px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.7);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr,
.alertSuc{
  position: fixed;
  top: 0;
  bottom: 0;
  right: 0;
  left: 0;
  z-index: 60;
  display: flex;
  align-items: center;
  justify-content: center;
  background: hsl(0, 0%, 10%, 0.4);
  transition: 0.25s;
}
.alertErr .adiv,
.alertSuc .adiv{
  padding: 0px;
  border-radius: 16px;
  background: #fff;
  width: 290px;
  box-shadow: border-box;
  word-break: break-word;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
  animation: zoomInMsg 0.2s;
  transition: 0.25s;
  overflow: hidden;
}
@keyframes zoomInMsg{
  from{
    transform: scale(0.9);
    opacity: 0.1;
  }
  to{
    transform: scale(1);
    opacity: 1;
  }
}
.alertErr .adiv i,
.alertSuc .adiv i{
  font-size: 50px;
  margin-bottom: 5px;
  margin-top: 20px;
}
.alertErr .adiv span,
.alertSuc .adiv span{
  font-size: 13px;
  font-weight: 400;
  color: #222;
  margin-top: 10px;
  margin-bottom: 18px;
  text-align: center;
  padding: 0px;
  padding-left: 13px;
  padding-right: 13px;
}
.alertSuc .adiv i{
  color: rgba(0%, 50%, 0%);
}
.alertErr .adiv i{
  color: rgba(80%, 0%, 0%);
}
.alertErr .adiv .button,
.alertSuc .adiv .button{
  display: inline-flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 0;
  border-top: 1px solid hsl(0, 0%, 70%);
  padding-top: 0px;
}
.alertErr .adiv .button button,
.alertSuc .adiv .button button{
  padding: 10px;
  color: #fff;
  line-height: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  outline: none;
  border-radius: 0px;
  height: 45px;
  width: 50%;
  font-size: 12px;
  font-family: 'Poppins', sans-serif;
  background: #fff;
  color: #666;
  border: none;
}
.alertErr .adiv .button button:hover,
.alertSuc .adiv .button button:hover,
.alertErr .adiv .button button:active,
.alertSuc .adiv .button button:active{
  background: hsl(0, 0%, 90%);
}
.alertSuc .adiv .button #cancelBtn,
.alertErr .adiv .button #cancelBtn{
  border-right: 0.8px solid hsl(0, 0%, 70%);
}
.alertErr .adiv .button #okBtn,
.alertSuc .adiv .button #okBtn{
  border-left: 0.8px solid hsl(0, 0%, 70%);
}
.spin{
  padding: 2px;
  height: 25px;
  width: 25px;
  border: 2.7px solid #fff;
  border-top: 2.7px solid #0003;
  background: transparent;
  border-radius: 50%;
  animation: infinitySpin 0.5s linear infinite;
  display: inline-block;
  box-sizing: border-box;
}
@keyframes infinitySpin{
  0%{
    transform: rotate(0deg);
  }
  100%{
    transform: rotate(360deg);
  }
}
  </style>
</head>
<body>
  <form class="box" id="sign-up-form">
    <div class="head">
     
       <h2 class="welcome-text" style="color: #5e1d3d;">Create Account</h2>
      <span>Lets get you a free but powerful  account.</span>
    </div>
    
   
    </div>
    <div class="inputs" id="sel-1">
      <div class="inputs" id="firstname:inputs">
        <span>First Name</span>
        <input type="text" placeholder="jhon" name="fname" id="firstname" oninput="checkValue('firstname', 'firstname-err', 3, 'length', 'invalid name', '')">
        <b id="firstname-err"></b>
      </div>
      
      <div class="inputs" id="lastname:inputs">
        <span>Last Name</span>
        <input type="text" placeholder="doe" name="lname" id="lastname" oninput="checkValue('lastname', 'lastname-err', 3, 'length', 'invalid name', '')">
        <b id="lastname-err"></b>
      </div>
    </div>
    
   
    
    <div class="inputs" id="phone:inputs">
      <span>Phone Number</span>
      <input type="tel" placeholder="08139980032" name="phone" id="phone" oninput="checkValue('phone', 'phone-err', 11, 'length', 'Invalid phone number', '')">
      <b id="phone-err"></b>
    </div>
    
    <div class="inputs" id="email:inputs">
      <span>Email</span>
      <input type="email" placeholder="anyakad69@gmai.com" name="email" id="email" oninput="checkValue('email', 'email-err', '', 'email', 'Invalid email', '')">
      <b id="email-err"></b>
    </div>
    
    <div class="inputs" id="pin:inputs">
      <span>PIN(4 Digits)</span>
      <input type="tel" maxlength="4" placeholder="1234" name="pin" id="pin" oninput="checkValue('pin', 'pin-err', 4, 'length', 'Invalid PIN required(4 digits)', '')">
      <b id="pin-err"></b>
    </div>
  <div class="inputs">
    <div class="inputs" id="password:inputs">
      <span>Password</span>
      <input type="password" placeholder="*********" name="password" id="password" oninput="
        checkValue('password', 'password-err', 8, 'length', 'Password must me up to 8 digits', '');
      ">
      <b id="password-err"></b>
    </div>
    
    <div class="inputs" id="password:confirm:inputs">
      <span>Confirm Password</span>
      <input type="Password" placeholder="********" name="confirm-password" id="password:confirm" oninput="checkValue('password:confirm', 'password-confirm-error', document.getElementById('password').value, 'not equal', `Confirm password doesn't match password`, '')">
      <b id="password-confirm-error"></b>
    </div>
  </div>
    
    <div class="inputs">
      <span>Referral Id(optional)</span>
      <input type="text" placeholder="eg, 65hg62kmgd8" name="referral-id" value="">
    </div>
    
    
   <div class="sep t-c"> 
  <input type="checkbox" id="tnc" name="tnc"> 
  <label for="tnc">I agree to Buypoint 
    <a href="terms-and-conditions.php" style="color: var(--site-clr); text-decoration: none;">Terms of services</a> 
  </label> 
  <br> 
  
  <span id="tnc-error" style="color: red; font-size: 12px; display: none;">Please accept Terms and Conditions.</span> 
</div> 

<br> 
<button class="b" type="submit" id="smtBtn">REGISTER<i class="fas fa-chevron-right"></i></button>

<script>
    document.getElementById('smtBtn').addEventListener('click', function() {
  const tncCheckbox = document.getElementById('tnc');
  const tncError = document.getElementById('tnc-error');

  if (!tncCheckbox.checked) {
    tncError.style.display = 'block';
    return false;
  } else {
    tncError.style.display = 'none';
  }
});

</script>
    <div class="link">
      <span style="color: #5e1d3d;">Already have an account <a href="login.php" style="color: #5e1d3d; text-decoration: none;">Login?</a></span>

    </div>
    <div class="link">
<span style="text-align: right; color: #333;">
    <a href="https://wa.link/tju8rd" style="color: #5e1d3d; text-decoration: none; transition: color 0.3s ease-in-out;" 
       onmouseover="this.style.color='black';" 
       onmouseout="this.style.color='#5e1d3d';">
       Contact Support
    </a>
</span>
  </form>
  <script>
  <?php include "js/msg.js"; ?>
    function isEmail(input) {
        // Regular expression for validating email addresses
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(input);
    }
  
    const signUpForm = document.getElementById("sign-up-form");
    const signBtn = document.getElementById("smtBtn");
    
    const firstname = document.getElementById("firstname");
    const lastname = document.getElementById("lastname");
    const phone = document.getElementById("phone");
    const email = document.getElementById("email");
    const pin = document.getElementById("pin");
    const password = document.getElementById("password");
    const confirmPassword = document.getElementById("password:confirm");
    
    signUpForm.addEventListener("submit", (e)=> {
      e.preventDefault();
      
      let formerTxt = signBtn.innerText;
      if(firstname.value.length <  3 || lastname.value.length < 3 || phone.value.length < 11 || isEmail(email.value) == false || pin.value.length < 4 || password.value.length < 8 || confirmPassword.value !== password.value){
        firstname.dispatchEvent(new Event("input"));
        lastname.dispatchEvent(new Event("input"));
        phone.dispatchEvent(new Event("input"));
        email.dispatchEvent(new Event("input"));
        pin.dispatchEvent(new Event("input"));
        password.dispatchEvent(new Event("input"));
        confirmPassword.dispatchEvent(new Event("input"));
      }else{
          if(!isNaN(pin.value)){
            showP(signBtn);
            fetch("server/signup.php", {
              method: "POST",
              body: new FormData(signUpForm),
            })
            .then(response => response.text())
            .then(data => {
              if(data.includes("successfully")){
                showMessage("fas fa-check-circle", data, "suc");
                setTimeout(()=> {
                  window.location = "login.php";
                }, 2000);
              }else{
                showMessage("fas fa-times-circle", data, "err");
              }
              removeP(signBtn, formerTxt);
            })
          }else{
            showMessage("fas fa-times-circle", "Please enter a valid pin (must be a number)", "err");
          }
        }
    });
    function toggPass(thisId){
      if(thisId.checked){
        password.type = "text";
        confirmPassword.type = "text";
      }else{
        password.type = "password";
        confirmPassword.type = "password";
      }
    }
  </script>
</body>
</html>