<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
$fetchDiscount = Control::fetchDiscount($conn, "Airtime");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/other.css">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <title>Account Settings</title>
  <style>
    @font-face {
      font-family: 'Mitr';
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    <?php  
      $site = Control::site($conn);
    ?>
    :root{
      --site-clr: <?php echo $site["site_color"] ?>;
      --bg: <?php echo $site["site_background"]; ?>;
    }
    <?php include "css/animation.css"; ?>
     .sms-toggle {
  background-color: green; 
  color: #fff;
  padding: 10px 20px;
  border: none;
  border-radius: 5px;
  cursor: pointer;
}

.sms-toggle.off {
  background-color: #e74c3c; 
}
.b{
      .head :  
  color: #3333ff;
  padding: 10px 20px;
  border: none;
  border-radius: 5px;
  cursor: pointer;
  width:100%;
}
.setting {
            display: flex;
            align-items: center;
            justify-content: space-between;
            background-color: #ffffff;
            padding: 12px 15px;
            border-radius: 8px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            transition: 0.3s ease-in-out;
            text-decoration: none;
            color: #333;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            
        }

        /* Hover Effect */
        .setting:hover {
            background-color: #fafafa;
            color: white;
            box-shadow: 0px 6px 12px rgba(0, 0, 0, 0.2);
        }

        /* Icon Styling */
        .setting i {
            font-size: 18px;
            color: #007bff;
            transition: 0.3s;
        }

        /* Change icon color on hover */
        .setting:hover i {
            color: white;
        }

        /* Ripple Effect Placeholder (if you have a JS function) */
        .setting:active {
            opacity: 0.8;
        }
  </style>
</head>
<body class="<?php echo ($user["mode"] == "On" ? "active" : ""); ?>">
  <div class="head">
    <i class="fas fa-chevron-left" onclick="goBack()"></i>
    <span>Account Settings</span>
    <a href="logout.php" style="text-decoration: none; color: #333"><i class="fas fa-sign-out"></i></a>
  </div>
  
  <div class="setting-box">
    
    <h2 class="h2">Account</h2>
    
    <a href="account-setting.php"><div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-group-line"></i>
      <span>Update Profile</span>
      <i class="fas fa-chevron-right"></i>
    </div></a>
    
    <a href="profile.php"><div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-user-line"></i>
      <span>Profile</span>
      <i class="fas fa-chevron-right"></i>
    </div></a>
    
    <a href="account-verification.php"><div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-check-line"></i>
      <span>Account Verification</span>
      <i class="fas fa-chevron-right"></i>
    </div></a>
    
    <div class="setting" onclick="showForm('c-statement', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')" hidden>
      <i class="ri-bank-line"></i>
      <span>Account Statement</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onclick="showForm('c-password', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-key-line"></i>
      <span>Change Password</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onclick="showForm('c-pin', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-lock-line"></i>
      <span>Change Transaction PIN</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onclick="showFormT('r-c-pin', 'open', 'flex', '')" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-lock-line"></i>
      <span>Reset Transaction PIN</span>
      <i class="fas fa-chevron-right"></i>
    </div>
    
    <div class="setting" onmousemove="createRipple(event, true, 'black')">
      <i class="ri-sun-line"></i>
      <span>Toggle Mode</span>
      <div class="toggle">
        <span class="span <?php echo ($user["mode"] == "On" ? "active" : ""); ?>" id="mode-t" onclick="toggleMode('mode-t')"></span>
        <b class="b" onclick="toggleMode('mode-t')"></b>
      </div>
    </div>
    
  
    
    <div class="setting" onmousemove="createRipple(event, true, 'black')" hidden="true">
      <i class="ri-shield-line"></i>
      <span>Two Factor Authentication</span>
      <div class="toggle">
        <span class="span"></span>
        <b class="b"></b>
      </div>
    </div>
    
  </div>
  
  <?php include "includes/account-statement.php"; ?>
  <?php include "includes/change-password.php"; ?>
  <?php include "includes/change-pin.php"; ?>
  <?php include "includes/reset-pin.php"; ?>
  
  <script>
   
function toggleSMS() {
  const b = document.getElementById('sms-toggle');
  const smsStatus = b.classList.contains('off') ? 'On' : 'Off';
  fetch(`server/alert.php?sms_status=${smsStatus}`)
    .then(response => response.text())
    .then(data => {
      b.classList.toggle('off');
      b.classList.toggle('active');
      b.textContent = smsStatus === 'On' ? 'Turn Off' : 'Turn On';
      if (smsStatus === 'On') {
        showMessage("bi bi-info-circle", "NOTE that you will be charged NGN 4.00 per sms sent for transfer sms,deposit sms and bills alerts.(you can turn this settings off anytime)", "suc");
      } else {
        showMessage("bi bi-info-circle", "Opted out successfully", "suc");
      }
    })
    .catch(error => console.error('Error toggling SMS:', error));
}
</script> 
  <script>
  
    <?php include "js/msg.js"; ?>
   function toggleMode(clickId){
     const click_id_gt = document.getElementById(clickId);
       fetch("server/update-mode.php")
       .then(response => response.text())
       .then(data => {
         if(data.includes("successfully")){
           click_id_gt.classList.toggle("active");
           document.body.classList.toggle("active");
         }
       });
   }
   <?php include "js/other.js"; ?>
  </script>
  </body>
</html>