<?php
session_start();
include_once "server/conn.php";
require "server/controller.php";
if(!isset($_GET["user_id"]) && !isset($_SESSION["user_id"])){
  header("Location: login.php");
  exit();
}

$user_id = (isset($_GET["user_id"]) ? $_GET["user_id"] : $_SESSION["user_id"]);
$user = Control::fetchDetail($conn, $user_id);
$site = Control::site($conn);

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <link rel="stylesheet" href="css/fontawsome/css/all.min.css">
  <link rel="stylesheet" href="css/bootstrap-icon/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <link rel="manifest" href="js/manifest.json">
  <title>Dashboard || More</title>
  <style>
    @font-face {
      font-family: 'Poppins', sans-serif;
      src: url('css/mitr/Mitr-Regular.ttf') format('truetype'); /* Adjust the path as needed */
      font-weight: normal;
      font-style: normal;
    }
    :root{
      --site-clr: #151185;
      --bg: hsl(0, 0%, 99%);
    }
    *{
        box-sizing: border-box;
    }
   
    .head{
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        background: #ffffffff;
        padding: 15px;
        height: 55px;
        display: flex;
        align-items: center;
    }
    .head i{
        margin-right: 27px;
        margin-left: 10px;
    }
    .head span{
        font-size: 13px;
        font-weight: 900;
        color: #000;
        display: block;
    
    }
    .grid a{
        text-decoration: none;
    }
    
    .services i{
        
        
       
        align-items: center;
        justify-content: center;
        width: 53px;
        height: 50px;
        color:white;
        display: flex;
        
        border-radius: 10px;
        border: none;
        background: linear-gradient(to left,#5e1d3d,#5e1d3d);
    }
    .services span{
        display: block;
        margin: 0;
        font-size: 10px;
        font-weight: 300;
        text-align: center;
        color: #444;
    }
    @keyframes fadeSlideIn {
  from {
    opacity: 0;
    transform: translateY(20px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

body {
  animation: fadeSlideIn 0.8s ease-out;
}
    
    
    body {
    font-family: 'Poppins', sans-serif;
    background-color: #ffffff;
    margin: 0;
    padding: 10px;
}

.topic {
    font-size: 24px;
    font-weight: bold;
    margin-bottom: 10px;
    color: #333;
}

.sml-tp {
    font-size: 14px;
    color: #777;
    margin-bottom: 15px;
}

.grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 15px;
    margin-bottom: 20px;
}

.services {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    background: white;
    padding: 5px;
    border-radius: 8px;
    box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
    text-align: center;
    transition: all 0.3s ease;
    cursor: pointer;
    font-family: 'Poppins', sans-serif;
   
}

.services:hover {
    background: #ffc000;
    color: white;
    transform: translateY(-5px);
}

.services i {
    font-size: 24px;
    margin-bottom: 5px;
}

.services span {
    font-size: 16px;
    font-weight: 500;
}

a {
    text-decoration: none;
    color: #5e1d3d;
}

    .sml-tp{
        display: flex;
        align-items: ceñter;
        width: 100%;
        color: #555;
        font-size: 11px;
        margin-top: 10px;
        margin-bottom: 25px;
    }
    .sml-tp i{
        margin-right: 10px;
    }
@media only screen and (max-width: 600px) {
    .grid{
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        grid-column-gap: 17px;
        grid-row-gap: 22px;
    }
}
@media only screen and (min-width: 601px) and (max-width: 1440px) {
    .grid{
        display: grid;
        grid-template-columns: repeat(7, 1fr);
        grid-column-gap: 16px;
        grid-row-gap: 16px;
    }
}

  </style>
</head>
<body class="">
    <div class="head">
        <i class="fas fa-chevron-left" onclick="goBack()"></i>
        <span>All Services</span>
    </div>
    <pre>
        
    </pre>
    
    <div class="topic">Payments</div>
    <div class="sml-tp"><i class="bi bi-info-circle"></i>Payment Services</div>
     <div class="grid">
     <a href="bank-transfer.php"><div class="services">
            <i class="bi bi-send"></i>
            <span>Money Transfer</span>
        </div></a>
    
        <a href="payment-link.php"><div class="services">
            <i class="bi bi-link"></i>
            <span>Payment Link</span>
        </div></a>
      
    </div>
     <pre>
    </pre>
    <div class="topic">Bills</div>
    <div class="sml-tp"><i class="bi bi-info-circle"></i>Bills Payment Services</div>
    <div class="grid">
        <a href="airtime.php"><div class="services">
            <i class="bi bi-phone"></i>
            <span>Airtime</span>
        </div></a>
        <a href="data.php"><div class="services">
            <i class="ri-arrow-up-down-line"></i>
            <span>Data</span>
        </div></a>
        <a href="cable.php"><div class="services">
            <i class="ri-tv-line"></i>
            <span>Cable TV</span>
        </div></a>
        <a href="electricity.php"><div class="services">
            <i class="ri-lightbulb-line"></i>
            <span>Electricity</span>
        </div></a>
        <a href="airtime-pin.php"><div class="services">
            <i class="bi bi-printer"></i>
            <span>Airtime Pin</span>
        </div></a>
        <a href="exam.php"><div class="services">
            <i class="fa fa-graduation-cap"></i>
            <span>Exam Pin</span>
        </div></a>
       
        <a href="betting.php"><div class="services">
            <i class="ri-football-line"></i>
            <span>Betting</span>
        </div></a>
        <a href="bulk-sms.php"><div class="services">
            <i class="ri-message-line"></i>
            <span>Bulk SMS</span>
        </div></a>
       
    </div>
    <pre>
    </pre>
    <div class="topic">Earn</div>
    <div class="sml-tp"><i class="bi bi-info-circle"></i>Rewards</div>
    <div class="grid">
      
        <a href="referral.php"><div class="services">
            <i class="ri-group-line"></i>
            <span>Referrals</span>
        </div></a>
       <a href="docs/plans.php"><div class="services">
            <i class="bi bi-code-slash"></i>
            <span>Pricing</span>
        </div></a>
    </div>
    
    <pre>
    </pre>
    <div class="topic">Cards</div>
    <div class="sml-tp"><i class="bi bi-info-circle"></i> Card Services</div>
    <div class="grid">
       <a href="coming soon.php"><div class="services">
            <i class="bi bi-credit-card"></i>
            <span>Virtual Card</span>
        </div></a>
         <a href="coming soon.php"><div class="services">
            <i class="ri-bank-card-line"></i>
            <span>Dollar Card</span>
        </div></a>
         <a href="coming soon.php"><div class="services">
            <i class="fa fa-credit-card"></i>
            <span>Physical Card</span>
        </div></a>
    </div>
    <pre>
    </pre>
    <div class="topic">Finance</div>
    <div class="sml-tp"><i class="bi bi-info-circle"></i> Finacial Services</div>
    <div class="grid">
        
        <a href=""><div class="services">
            <i class="bi bi-piggy-bank"></i>
            <span>Savings</span>
        </div></a>
        <a href="coming soon.php"><div class="services">
            <i class="ri-gift-line"></i>
            <span>Gift Cards</span>
        </div></a>
        <a href="coming soon.php"><div class="services">
            <i class="fa fa-hand-holding-usd"></i>
            <span>Loans</span>
        </div></a>
       
    </div>
    
    <script>
       function showMessage(classIcon, message, classN, cancelF, okF){
    let classL = "";
    let title = "";
    if(classN == "err"){
      classL = "alertErr";
      title = "ERROR!";
    }else if(classN == "suc"){
      classL = "alertSuc";
      title = "SUCCESS!";
    }else if(classN == "ver"){
      classL = "alertSuc";
      title = "VERIFY!";
    }
    const newMsg = document.createElement("div");
    const cBtn = document.createElement("button");
    cBtn.innerHTML = "cancel";
    cBtn.id = "cancelBtn";
    cBtn.style.transition = "background 0.5s";
    const okBtn = document.createElement("button");
    okBtn.innerHTML = "ok";
    okBtn.id = "okBtn";
    okBtn.style.transition = "background 0.5s";
    newMsg.innerHTML = `
     <div class="adiv" id="adiv-box">
      <i class="${classIcon}" style="font-size: 50px;${classIcon.includes("bi") ? 'margin-bottom: -5px; margin-top: 11px;' : ''}"></i>
      <h2 style="font-size:18px; font-weight:900; color:#222; margin-bottom:2px; padding-left:20px; padding-right:20px; font-size: 14px;">${title}</h2>
      <span style="padding-left:20px; padding-right:20px; font-size: 11px; letter-spacing:0.6px; font-family: 'Poppins', sans-serif;">${message.replace("minimum", "minimum")}</span>
      <div class="button">
      
      </div>
     </div>
    `;
    newMsg.classList.add(classL);
    document.body.appendChild(newMsg);
    
    newMsg.querySelector(".button").appendChild(cBtn);
    newMsg.querySelector(".button").appendChild(okBtn);
    
    
    okBtn.addEventListener("click", ()=> {
      newMsg.style.opacity = "0.1";
      setTimeout(()=> {
        document.body.removeChild(newMsg);
        if(okF !== ""){
          okF();
        }
      }, 250);
    })
    
    
    cBtn.addEventListener("click", ()=> {
      newMsg.style.opacity = "0.1";
      setTimeout(()=> {
        document.body.removeChild(newMsg);
        if(cancelF !== ""){
          cancelF();
        }
      }, 250);
    })
    
  }
   
  function showP(btnIdTo){
    btnIdTo.style.opacity = "0.2";
    btnIdTo.innerHTML = "<div class='spin'></div>";
    btnIdTo.disabled = true;
  }
   
  function removeP(btnIdTo, formerTxt){
    btnIdTo.style.opacity = "1";
    btnIdTo.innerHTML = formerTxt;
    btnIdTo.disabled = false;
  }
    function moveToNext(thisInpGet, nextMove){
      if(thisInpGet.value.length === thisInpGet.maxLength){
        document.getElementById("pin-" + nextMove).focus();
      }
    }
    
    function moveToPrev(event, nextMove){
      if(event.key == "Backspace"){
        document.getElementById("pin-" + nextMove).value = "";
        document.getElementById("pin-" + (nextMove - 1)).focus();
      }
    }
    
    function goBack(){
      window.history.back();
    }
    
    function closePin(pinBox){
      const pinBxGet = document.querySelector("." + pinBox);
      pinBxGet.style.transition = "0.4s";
      pinBxGet.style.transform = "translateY(120%)";
      setTimeout(()=> {
        pinBxGet.style.display = "none";
        pinBxGet.style.transform = "translateY(0%)";
      }, 250)
    }
  
    function toggSelect(btnToGet, valueToSel, theValue, thisBtnId, clrBgAdd){
      document.getElementById(valueToSel).value = theValue;
      const selectButton = document.querySelectorAll(`.${btnToGet}`);
      selectButton.forEach(selEach => {
        selEach.classList.remove("active")
        selEach.style.background = "";
        selEach.querySelector("span").style.display = "none";
      });
      const selBtnGt = selectButton[thisBtnId];
      const selSpan = selBtnGt.querySelector("span");
      selBtnGt.classList.add("active");
      if(clrBgAdd == "MTN"){
        selBtnGt.style.background = "rgba(100%, 70%, 0%)";
        selSpan.style.color = "rgba(100%, 60%, 0%)";
      }else if(clrBgAdd == "GLO"){
        selBtnGt.style.background = "rgba(0%, 85%, 0%)";
        selSpan.style.color = "rgba(0%, 60%, 0%)";
      }else if(clrBgAdd == "9MOBILE"){
        selBtnGt.style.background = "rgba(15%, 0%, 0%)";
        selSpan.style.color = "rgba(15%, 0%, 0%)";
      }else if(clrBgAdd == "AIRTEL" || clrBgAdd == "STARTIME"){
        selBtnGt.style.background = "rgba(80%, 0%, 0%)";
        selSpan.style.color = "rgba(80%, 0%, 0%)";
      }else if(clrBgAdd == "DSTV"){
        selBtnGt.style.background = "rgba(0%, 50%, 70%)";
        selSpan.style.color = "rgba(0%, 40%, 60%)";
      }else if(clrBgAdd == "GOTV"){
        selBtnGt.style.background = "hsl(0, 0%, 85%)";
        selSpan.style.color = "hsl(0, 0%, 20%)";
      }else if(clrBgAdd == "WAEC"){
        selBtnGt.style.background = "rgba(50%, 0%, 50%)";
        selSpan.style.color = "rgba(50%, 0%, 50%)";
      }else if(clrBgAdd == "NECO" || clrBgAdd == "NABTEB"){
        selBtnGt.style.background = "rgba(0%, 60%, 0%)";
        selSpan.style.color = "rgba(0%, 60%, 0%)";
      }
      selSpan.style.display = "block";
      document.getElementById(valueToSel).dispatchEvent(new Event("change"));
    }
    
  function checkValue(valueToCheck, errPut, valueLess, type, errMsg, successErrMsg, sucMessage){
    let check = "";
    let valueGet_t = "";
    const valueGet = document.getElementById(valueToCheck);
    valueGet_t = document.getElementById(valueToCheck);
    if(type == "length"){
      check = valueGet.value.length < valueLess;
    }else if(type == "value"){
      check = valueGet.value < valueLess;
    }else if(type == "not equal"){
      check = valueGet.value !== valueLess;
    }else if(type == "equal"){
      check = valueGet.value == valueLess;
    }else if(type == "empty"){
      check = valueGet.value == valueLess;
    }else if(type == "email"){
      const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      check = regex.test(valueGet.value) == false;
    }else if(type == "url"){
      const regex = /^(https?:\/\/)?([^\s$.?#].[^\s]*)\.[a-z]{2,}([^\s]*)$/i;
      check = regex.test(valueGet.value) == false;
    }else if(type == "phone"){
      const regex = /^\d{11}$/;
      check = regex.test(valueGet.value) == false;
    }else if(type == "email or phone"){
      const regex_t = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      const regex = /^\d{11}$/;
      check = regex.test(valueGet.value) == false && regex_t.test(valueGet.value) ==  false;
    }
    const createIcon = document.createElement("i");
    createIcon.id = "check";
    if(check){
      const innPut = document.getElementById(errPut);
      if(innPut.innerHTML.includes("</i>")){
        innPut.innerHTML = `<b class='err' style="margin-left:3px; font-weight:500; font-size:11.2px; margin-top:5px; color: rgba(80%, 0%, 0%); display: flex; font-family: 'Poppins', sans-serif; letter-spacing: 0.4px; animation: over 0.5s;">${errMsg}</b>`;
      }else if(innPut.innerHTML === ""){
        innPut.innerHTML = `<b class='err' style="margin-left:3px; font-weight:500; font-size:11.2px; margin-top:5px; color: rgba(80%, 0%, 0%); display: flex; font-family: 'Poppins', sans-serif; letter-spacing: 0.4px; animation: over 0.5s;">${errMsg}</b>`;
      }
      valueGet_t.style.border = "1px solid rgba(90%, 0%, 0%)";
      createIcon.className = "fas fa-info-circle";
      createIcon.id = "checkErr";
      
      document.getElementById(valueToCheck + ":1").style.border = "1px solid rgba(80%, 0%, 0%)";
    }else{
      if(successErrMsg !== ""){
        const innPut = document.getElementById(errPut);
        innPut.innerHTML = `<b class="suc">${sucMessage}</b>`;
        
        valueGet_t.style.border = "";
        createIcon.className = "fas fa-check-circle";
        createIcon.id = "check";
        
      document.getElementById(valueToCheck + ":1").style.border = "";
      }else{
        const innPut = document.getElementById(errPut);
        innPut.innerHTML = "";
        
        valueGet_t.style.border = "";
        createIcon.className = "fas fa-check-circle";
        createIcon.id = "check";
        
        document.getElementById(valueToCheck + ":1").style.border = "";
      }
    }
  }
  
  function showChecking(checkingR, msg){
    checkingR.innerHTML = `
      <b class='err' style="margin-left:3px; font-weight:600; font-size:11px; margin-top:5px; color: rgba(0%, 60%, 0%); display: flex; font-family: 'Poppins', sans-serif; letter-spacing: 0.4px;">
      <i class="fas fa-spinner fa-spin" style="margin-right: 6px;"></i>
      ${msg}
      </b>
    `;
  }
  
  function showError(checkingR, msg){
    checkingR.innerHTML = `
      <b class='err' style="margin-left:3px; font-weight:600; font-size:11px; margin-top:5px; color: rgba(90%, 0%, 0%); display: flex; font-family: 'Poppins', sans-serif; letter-spacing: 0.4px;">
      <i class="bi bi-x-circle" style="margin-right: 6px;"></i>
      ${msg}
      </b>
    `;
  }
  
  function showSuccess(checkingR, msg){
    checkingR.innerHTML = `
      <b class='err' style="margin-left:3px; font-weight:600; font-size:11px; margin-top:5px; color: rgba(0%, 60%, 0%); display: flex; font-family: 'Poppins', sans-serif; letter-spacing: 0.4px;">
      <i class="bi bi-check-circle" style="margin-right: 6px;"></i>
      ${msg}
      </b>
    `;
  }
  
  function addActive(dropToAdd, planDetail){
    const get_drop_icon = dropToAdd.querySelector("i");
    document.querySelectorAll(".drop-btn").forEach(allDrop => {
      if(allDrop.classList.contains("active")){
        allDrop.click();
      }
    })
    
    
    if(dropToAdd.classList.contains("active")){
      const plan_detail_get = document.getElementById(planDetail)
      plan_detail_get.style.height = "0px";
      get_drop_icon.className = "fas fa-chevron-down";
      
      setTimeout(()=> {
       dropToAdd.classList.remove("active");
       plan_detail_get.style.height = "";
      }, 300);
    }else{
       dropToAdd.classList.add("active");
       get_drop_icon.className = "fas fa-chevron-up";
    }
  }
  
  function removeDrop(to_select, select_value, thisBtn, queryAll, toClick){
    const toS = document.getElementById(to_select);
    toS.value = select_value;
    toS.dispatchEvent(new Event("change"));
    const cl = document.getElementById(toClick);
    
    const cl_r = (toClick.replace(":", "")).replace("1", "") + ":inputs";
    const d_g = document.getElementById(cl_r);
    
    const select_all_divs = d_g.querySelectorAll("." + queryAll);
    select_all_divs.forEach(toRemove => {
      toRemove.classList.remove("active");
      if(toRemove.querySelector("input")){
        toRemove.querySelector("input").remove();
      }
    });
    thisBtn.classList.add("active");
    
    const newInput = document.createElement("input");
    newInput.type = "checkbox";
    newInput.setAttribute("checked", true);
    newInput.disabled = true;
    newInput.className = "input";
    thisBtn.appendChild(newInput);
    
    cl.click();
    cl.querySelector("span").innerHTML = thisBtn.querySelector("span").innerHTML;
  }
  
  function greetUser(to_put){
     const msg_inn = document.getElementById(to_put);
     const newadate = new Date();
     const timeNow = newadate.getHours();
     if(timeNow < 12){
       msg_inn.innerHTML = "Good Morning";
     }else if(timeNow < 18){
       msg_inn.innerHTML = "Good Afternoon";
     }else{
       msg_inn.innerHTML = "Good Evening";
     }
  }
  
   function copyTxt(textValue){
     const newTextArea = document.createElement("textarea");
     newTextArea.value = textValue;
     document.body.appendChild(newTextArea);
     newTextArea.select();
     newTextArea.setSelectionRange(0, 9999);
     document.execCommand("copy");
     document.body.removeChild(newTextArea);
     showMessage("bi bi-check2-circle", "Copied To Clipboard", "suc");
   }
   
    function startCount(count_txt, couIn, resend_txt){
        let count = count_txt;
        let interval = setInterval(() => {
          count--;
          const resendBtn = document.getElementById(couIn);
          resendBtn.innerHTML = "Resend In " + count;
          resendBtn.disabled = true;
          resendBtn.classList.add("disabled");
          
          if(count < 1){
            resendBtn.innerHTML = resend_txt;
            resendBtn.disabled = false;
            count = count_txt;
            clearInterval(interval);
            resendBtn.classList.remove("disabled");
          }
        }, 1000);
    }
    
    
document.querySelectorAll("button").forEach(allButton => {
    allButton.addEventListener("mousemove", (event)=> {
      createRipple(event, true, "");
    });
  });

  function createRipple(event, isClick, thisE) {
    var el = event.currentTarget;
    var btnWidth = el.clientWidth;
    var elRect = el.getBoundingClientRect();
    var rippleOffset = 0;
    var btnOffsetTop = elRect.top + rippleOffset;
    var btnOffsetLeft = elRect.left;
    var posMouseX = isClick ? event.clientX : elRect.left + btnWidth / 2;
    var posMouseY = isClick ? event.clientY + rippleOffset : elRect.top + btnWidth / 2 + rippleOffset;
    var rippleX = posMouseX - btnOffsetLeft;
    var rippleY = posMouseY - btnOffsetTop;
    if(thisE === "black"){
      var baseCSS = "\n          position: absolute;\n          width: " + btnWidth * 2 + "px;\n          height: " + btnWidth * 2 + "px;\n          border-radius: 50%;\n          transition: transform 1500ms, opacity 0.2;\n          transition-timing-function: cubic-bezier(0.250, 0.460, 0.450, 0.940);\n          background: #0005;\n          background-position: center;\n          background-repeat: no-repeat;\n          background-size: 100%;\n          left: " + (rippleX - btnWidth) + "px;\n          top: " + (rippleY - btnWidth) + "px;\n          transform: scale(0);\n          pointer-events: none;\n      ";
    }else{
      var baseCSS = "\n          position: absolute;\n          width: " + btnWidth * 2 + "px;\n          height: " + btnWidth * 2 + "px;\n          border-radius: 50%;\n          transition: transform 1500ms, opacity 100ms;\n          transition-timing-function: cubic-bezier(0.250, 0.460, 0.450, 0.940);\n          background: #fff;\n          background-position: center;\n          background-repeat: no-repeat;\n          background-size: 100%;\n          left: " + (rippleX - btnWidth) + "px;\n          top: " + (rippleY - btnWidth) + "px;\n          transform: scale(0.2);\n";
    }
    // Prepare the dom
    var rippleEffect = document.createElement("span");
    rippleEffect.style.cssText = baseCSS;

    // Add some css for prevent overflow errors
    el.style.overflow = "hidden";

    // Check if the element is not static because the ripple is in absolute
    if (window.getComputedStyle(el).position === "static") {
        el.style.position = "relative";
    }

    el.appendChild(rippleEffect);

    // start animation
    requestAnimationFrame(function () {
        rippleEffect.style.cssText = baseCSS + " transform: scale(1); opacity: 0.1;";
    });

    setTimeout(function () {
        rippleEffect.remove();
    }, 1000);
  }    </script>
</body>
</html>