<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

    session_start();
    include_once "conn.php";
    require "controller.php";
    require "api_call.php";
    validate::checkSession();
    
    $user_id = $_SESSION["user_id"];
    
    if($_SERVER["REQUEST_METHOD"] !== "POST"){
        echo "Invalid server request method";
        exit();
    }
    
    $user = Control::fetchDetail($conn, $user_id);
    if($user["status"] === false){
        echo $user["msg"];
        exit();
    }
    
    if(!isset($_FILES["utility"])){
      echo "Invalid request please try again.";
      exit();
    }
    
    $utility = $_FILES["utility"];
    
    $t_file = basename($utility["name"]);
    $ext = strtolower(pathinfo($t_file, PATHINFO_EXTENSION));
    $supp = ["jpg", "jpeg", "png"];
    
    
    if ($utility["size"] > 5000000) {
        echo "Sorry, your file is too large.";
        $uploadOk = 0;
    }
    
    if(!in_array($ext, $supp)){
        echo "You can only upload image Jpeg, Jpg, Png";
        exit();
    }
    
    $file_name = rand(time(), 99999).".".$ext."_verifying";
    
    $sql = $conn->prepare("UPDATE verification SET utility = ? WHERE unique_id = ?");
    $sql->bind_param("ss", $file_name, $user_id);
    if($sql->execute()){
        move_uploaded_file($utility["tmp_name"], "../verification/".$file_name);
        echo "success!! your nin verification is under review, you will be sent an email notification when approved";
        Control::updateBalance($conn, $user_id, "debit", 20);
        exit();
    }else{
        echo "Something went wrong";
        exit();
    }
?>