<?php
    session_start();
    include_once "conn.php";
    require "controller.php";
    require "api_call.php";
    validate::checkSession();
    
    $user_id = $_SESSION["user_id"];
    
    if($_SERVER["REQUEST_METHOD"] !== "POST"){
        echo "Invalid server request method";
        exit();
    }
    
    $user = Control::fetchDetail($conn, $user_id);
    if($user["status"] === false){
        echo $user["msg"];
        exit();
    }
    
    if(!isset($_POST["nin"])){
      echo "Invalid request please try again";
      exit();
    }
    
    $nin = validate::validateInt($conn, $_POST["nin"]);
    $nin_verify = $nin."_verifying";
    
    $sql = $conn->prepare("UPDATE verification SET nin = ? WHERE unique_id = ?");
    $sql->bind_param("ss", $nin_verify, $user_id);
    if($sql->execute()){
        echo "success!! your nin verification is under review, you will be sent an email notification when approved";
        Control::updateBalance($conn, $user_id, "debit", 20);
        exit();
    }else{
        echo "Something went wrong";
        exit();
    }
?>