<?php
 session_start();
 include_once "conn.php";
 include "controller.php";
 include "api_call.php";
 validate::checkSession();
 $user_id = $_SESSION["user_id"];
 $site = Control::site($conn);
 
 if($_SERVER["REQUEST_METHOD"] === "GET"){
   
   function showBox($status, $msg, $table){
     global $site;
     $icon = "";
     $msgS = "";
     if($status == "success"){
       $icon = "ri-checkbox-circle-line";
     }else if($status == "failed"){
       $icon = "ri-close-circle-line";
     }else if($status == "unmobileized"){
       $icon = "ri-forbid-line";
     }
     
     return '
      <html>
      <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <meta http-equiv="X-UA-Compatible" content="ie=edge">
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
      <style>
    @font-face {
      font-family: "Poppins";
      src: url("http://'.$_SERVER["HTTP_HOST"].'/mobile/css/poppins/Poppins-Regular.ttf") format("truetype");
      font-weight: normal;
      font-style: normal;
    }
    :root{
      --site-clr: '.$site["site_color"].';
      --bg: '.$site["site_background"].';
    }
      body{
        display: flex;
        align-items: start;
        justify-content: center;
      }
       .box-v{
         padding: 0px;
         width: 310px;
         background: #fff;
         box-sizing: border-box;
         text-align: center;
         font-family: "Poppins", Sans-serif;
         margin-top: 20px;
         border-radius: 10px;
       }
       .b-h{
         margin-bottom: 20px;
         display: flex;
         align: items; center;
         flex-direction: column;
       }
       .b-h i{
         font-size: 60px;
         margin-bottom: 5px;
       }
       .b-h h2{
         margin: 0;
         font-weight: 900;
         font-size: 15px;
       }
       table{
         width: 100%;
         box-sizing: border-box;
         word-break: break-word;
       }
       table tr{
         font-size: 9px;
         text-align: left;
         height: 40px;
         box-sizing: border-box;
         width: 100%;
       }
       table tr td:nth-child(1){
         min-width: 60px;
         font-weight: 500;
         font-size: 11px;
         color: #666;
       }
       table tr td:nth-child(2){
         min-width: 70%;
         font-weight: 700;
         font-size: 12px;
         color: #000;
         font-family: "";
       }
       .buttons{
         display: flex;
         align-items: center;
         justify-content: space-between;
         margin-top: 20px;
       }
       button{
         padding: 10px;
         border: 0.9px solid var(--site-clr);
         background: var(--site-clr);
         color: #fff;
         font-weight: 900;
         width: 100%;
         height: 45px;
         border-radius: 3px;
         font-family: "Poppins", Sans-serif;
       }
       button.no{
         border: 0.9px solid #000;
         background: #fff;
         font-weight: 500;
         color: #000;
       }
       i[class="ri-checkbox-circle-line"]{
         color: rgba(0%, 70%, 0%);
         font-weight: 200;
       }
       i[class="ri-forbid-line"]{
         color: rgba(90%, 0%, 0%);
       }
       i[class="ri-close-circle-line"]{
         color: rgba(90%, 60%, 0%);
       }
      </style>
      </head>
      <body>
        <div class="box-v">
          <div class="b-h">
            <i class="'.$icon.'"></i>
            <h2>'.$msg.'</h2>
          </div>
          '.$table.'
          <div class="buttons">
            <button onclick="window.location = `http://'.$_SERVER["HTTP_HOST"].'/mobile/dashboard.php`">GO HOME</button>
          </div>
        </div>
      </body>
      </html>
     ';
   }
   
   if(!isset($_GET["reference"]) || !isset($_GET["mbref"])){
     echo showBox("unmobileized", "Unmobileized page access your account maybe blocked if you try again", "");
     exit();
   }
   
   $mbRef = validate::validateString($conn, $_GET["mbref"]);
   $reference = validate::validateString($conn, $_GET["reference"]);
   
   $fetchT = Control::fetchTransaction($conn, $user_id, $mbRef);
   if($fetchT["status"] == false){
     echo showBox("unmobileized", "Unmobileized page access your account maybe blocked if you try again?", "");
     exit();
   }
   
   if($fetchT["details"][0]["status"] == "success"){
     echo showBox("success", "Transaction already completed", '
     <table>
       <tr>
         <td>Status</td>
         <td>'.$fetchT["details"][0]["status"].'</td>
       </tr>
       <tr>
         <td>Reference</td>
         <td>'.$fetchT["details"][0]["reference"].'</td>
       </tr>
       <tr>
         <td>Amount</td>
         <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
       </tr>
       <tr>
         <td>Date</td>
         <td>'.$fetchT["details"][0]["date"].'</td>
       </tr>
     </table>
     ');
     exit();
   }
   
   $verify = Api::verify_paystack($conn, $reference);
   if($verify["status"] == false){
     echo showBox("unmobileized", $verify["msg"], "");
     exit();
   }
   
   Control::updateBalance($conn, $user_id, "credit",  $fetchT["details"][0]["amount"]);
   Control::updateTStatus($conn, $user_id, $mbRef, "success");
   
     echo showBox("success", $verify["msg"], '
     <table>
       <tr>
         <td>Status</td>
         <td>success</td>
       </tr>
       <tr>
         <td>Reference</td>
         <td>'.$fetchT["details"][0]["reference"].'</td>
       </tr>
       <tr>
         <td>Type</td>
         <td>'.$fetchT["details"][0]["type"].'</td>
       </tr>
       <tr>
         <td>Amount</td>
         <td>NGN '.number_format($fetchT["details"][0]["amount"], 2).'</td>
       </tr>
       <tr>
         <td>Old Bal</td>
         <td>NGN '.number_format($fetchT["details"][0]["old_bal"], 2).'</td>
       </tr>
       <tr>
         <td>New Bal</td>
         <td>NGN '.number_format($fetchT["details"][0]["new_bal"], 2).'</td>
       </tr>
       <tr>
         <td>Date</td>
         <td>'.$fetchT["details"][0]["date"].'</td>
       </tr>
     </table>
     ');
     exit();
 }
?>