<?php
    session_start();
    include_once "conn.php";
    require "controller.php";
    require "api_call.php";
    validate::checkSession();
    
    $user_id = $_SESSION["user_id"];
    
    if($_SERVER["REQUEST_METHOD"] !== "POST"){
        echo "Invalid server request method";
        exit();
    }
    
    $user = Control::fetchDetail($conn, $user_id);
    if($user["status"] === false){
        echo $user["msg"];
        exit();
    }
     if(!isset($_POST["bvn"]) || !isset($_POST["dob"])){
      echo "Invalid request please try again";
      exit();
    }
  
    $bvn = validate::validateInt($conn, $_POST["bvn"]);
    $dob = validate::validateInt($conn, $_POST["dob"]);
    $bvn_verify = $bvn."_verifying";
    
    $sql = $conn->prepare("UPDATE verification SET bvn = ?, dob = ? WHERE unique_id = ?");
    $sql->bind_param("sss", $bvn_verify, $dob, $user_id);
    if($sql->execute()){
        echo "success!! your bvn verification is under review, you will be sent an email notification when approved";
        exit();
    }else{
        echo "Something went wrong";
        exit();
    }
?>