<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 date_default_timezone_set("Africa/Lagos");
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
   echo "Invalid server request method";
   exit();
 }
 
   $bank_code = validate::validateInt($conn, $_POST["bank"]);
   $account_no = validate::validateInt($conn, $_POST["account-no"]);
   
   if($bank_code === "0505"){
       $user = Control::fetchDetail($conn, "0".$account_no);
       if($user["status"] === false){
           echo json_encode([
             "status" => false,
             "msg" => "Unable to verify bank name",
           ]); 
           exit();
       }else{
           echo json_encode([
             "status" => true,
             "account_name" => $user["fname"]." ".$user["lname"],
             "session_id" => $user["unique_id"],
           ]);
           exit();
       }
   }
   
   $verify = Api::verify_bank_name($conn, $bank_code, $account_no);
   echo json_encode($verify);
?>