<?php
session_start();
include_once "conn.php";
require "controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
$user = Control::fetchDetail($conn, $user_id);
if($_SERVER["REQUEST_METHOD"] == "POST"){
  if(!isset($_POST["type"])){
    echo "Err! Unmobileized Action";
    exit();
  }
  
  $type = validate::validateString($conn, $_POST["type"]);
  if($type == "password"){
      $old_password = $_POST["old-password"];
      $new_password = validate::validatePassword($conn, $_POST["new-password"]);
      if(!password_verify($old_password, $user["password"])){
        echo json_encode(["status" => false, "msg" => "Err old password incorrect please check and try again"]);
        exit();
      }
      $updatePassword = Control::updatePassword($conn, $user_id, $new_password);
      echo json_encode(["status" => $updatePassword["status"], "msg" => $updatePassword["msg"]]);
  }else if($type == "pin"){
    $old_pin = validate::validateInt($conn, $_POST["old-pin"]);
    $new_pin = validate::validateInt($conn, $_POST["new-pin"]);
    
    $checkPin = Control::checkPin($conn, $user_id, $old_pin);
    if($checkPin["status"] == false){
      echo json_encode(["status" => false, "msg" => "Err! old pin is incorrect please check and try again"]);
      exit();
    }
    
    $updatePin = Control::updatePin($conn, $user_id, $new_pin);
    echo json_encode(["status" => $updatePin["status"], "msg" => $updatePin["msg"]]);
  }
}
?>