<?php
    session_start();
    include_once "conn.php";
    require "controller.php";
    validate::checkSession();
    
    $user_id = $_SESSION["user_id"];
    
    if($_SERVER["REQUEST_METHOD"] !== "POST"){
        echo "Invalid server request method";
        exit();
    }
    
    $user = Control::fetchDetail($conn, $user_id);
    if($user["status"] === false){
        echo $user["msg"];
        exit();
    }
    
    $fname = validate::validateString($conn, $_POST["firstname"]);
    $lname = validate::validateString($conn, $_POST["lastname"]);
    $state = validate::validateString($conn, $_POST["state"]);
    $city = validate::validateString($conn, $_POST["city"]);
    $address = validate::validateString($conn, $_POST["address"]);
    $gender = validate::validateString($conn, $_POST["gender"]);
    
    $sql = $conn->prepare("UPDATE regtable SET fname = ?, lname = ?, state = ?, city = ?, address = ?, gender = ? WHERE unique_id = ?");
    $sql->bind_param("sssssss", $fname, $lname, $state, $city, $address, $gender, $user_id);
    if($sql->execute()){
        echo "Profile updated successful";
        exit();
    }else{
        echo "Unable to update profile try again";
        exit();
    }
    
    $sql->close();
?>