<?php
session_start();
include_once "conn.php";
include "controller.php";
validate::checkSession();

$user_id = $_SESSION["user_id"];
date_default_timezone_set("Africa/Lagos");

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $start_date = validate::validateInt($conn, $_POST["start-date"]);
    $end_date = validate::validateInt($conn, $_POST["end-date"]);
    
    // Convert dates to datetime objects
    $start_datetime = date_create($start_date);
    $end_datetime = date_create($end_date);
    
    // Format datetime objects to MySQL datetime format
    $start_datetime_formatted = date_format($start_datetime, "Y-m-d H:i:s");
    $end_datetime_formatted = date_format($end_datetime, "Y-m-d H:i:s");

    $transactions = [];
    $sql = "SELECT * FROM transaction WHERE unique_id = ? AND date BETWEEN ? AND ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $user_id, $start_datetime_formatted, $end_datetime_formatted);
    $stmt->execute();
    $query = $stmt->get_result();
    
    if ($query->num_rows > 0) {
        while ($row = $query->fetch_assoc()) {
            $transactions[] = $row;
        }
        
        if (!empty($transactions)) {
            foreach ($transactions as $t) {
                echo "<div style='font-size:7.8px; text-align:left;'>".$t["type"]."<br>:".$t["reference"]."<br>:".$t["date"]."</div><br>";
            }
        } else {
            echo "No transactions found between the specified dates.";
        }
    } else {
        echo "No transactions found for this user.";
    }
}
?>
