<?php
session_start();
include_once "conn.php";
require "controller.php";
require "mail.php";

if($_SERVER["REQUEST_METHOD"] !== "POST"){
  echo "Invalid server request method only post method allowed";
  exit();
}

$email = validate::validateEmail($conn, $_POST["email"]);

$g_user = Control::fetchDetail($conn, $email);
if($g_user["status"] === false){
  echo $g_user["msg"];
  exit();
}

$site = Control::site($conn);

$code = rand(100000, 999999);
$msg = '
<!DOCTYPE html>
 <html>
   <head>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap">
    <title>Password reset OTP</title>
     <style>
       body{
         font-family: "Poppins", Sans-serif;
       }
       .welcome{
         margin: 0;
         font-size: 15px;
         margin-bottom: 10px;
         display: block;
         font-weight: 500;
         font-family: "Poppins", Sans-serif;
       }
       .mesaage{
         margin: 0;
         font-size: 13px;
         margin-top: 20px;
         margin-bottom: 40px;
         display: block;
       }
       .mesaage b{
         font-weight: 800;
         font-size: 30px;
         margin-left: 10px;
       }
       .spam{
         margin: 0;
         font-size: 14px;
         margin-top: 40px;
         display: block;
       }
     </style>
   </head>
   <body>
     <div class="box">
       <b class="welcome">Hello, '.$g_user["fname"].'</b>
       <span class="message">
        Dear valued user, for your security, we have generated a One Time Passcode (OTP) for you to reset your password. Please use the following code to proceed with your password reset process <b>'.$code.'</b>
       </span>
       
       <div class="spam">If this was not done by you please change your password and contact support for assistance <a href="mailto: '.$site["support_email"].'">'.$site["support_email"].'</a> or <a href="http://'.$_SERVER["HTTP_HOST"].'/mobile/login.php">Login</a> now to change password</div>
     </div>
   </body>
 </html>
';

  $mailU = sendOtpMail($conn, $g_user["unique_id"], $email, "Password Reset OTP", $msg, 
  "A 6-digit One Time Passcode (OTP) has been sent to your email. Please check both your INBOX and SPAM FOLDER to retrieve it");
  if($mailU["status"] !== true){
    echo $mailU["msg"];
    exit();
  }else{
    $_SESSION["reset-code"] = $code;
    echo $mailU["msg"];
  }
?>