<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
  require "mail.php";
 date_default_timezone_set("Africa/Lagos");
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   
   $bank = validate::validateInt($conn, $_POST["bank"]);
   $bank_name = validate::validateString($conn, $_POST["bank-name"]);
   
   $account_no = validate::validateInt($conn, $_POST["account-no"]);
   $account_name = validate::validateString($conn, $_POST["account-name"]);
   
   $narration = validate::validateString($conn, $_POST["narration"]);
   $ssId = validate::validateString($conn, $_POST["session-id"]);
   
   $amount = validate::validateInt($conn, $_POST["amount"]) + 20;
   
   
   $pin_1 = validate::validateInt($conn, $_POST["pin-1"]);
   $pin_2 = validate::validateInt($conn, $_POST["pin-2"]);
   $pin_3 = validate::validateInt($conn, $_POST["pin-3"]);
   $pin_4 = validate::validateInt($conn, $_POST["pin-4"]);
   
   $pin_join = $pin_1.$pin_2.$pin_3.$pin_4;
   
   $checkPin = Control::checkPin($conn, $user_id, $pin_join);
   if($checkPin["status"] == false){
     echo $checkPin["msg"];
     exit();
   }
   $checkSql = $conn->prepare("SELECT * FROM contacts WHERE unique_id = ? AND acc_name = ? AND bank = ?");
$checkSql->bind_param("sss", $user_id, $account_no, $bank_name);
$checkSql->execute();
$result = $checkSql->get_result();

if ($result->num_rows > 0) {
    // Bank details already exist
} else {
    $sql = $conn->prepare("INSERT INTO contacts (acc_name, bank, name, unique_id) VALUES (?, ?, ?, ?)");
    $sql->bind_param("ssss", $account_no, $bank_name, $account_name, $user_id);
    if ($sql->execute()) {
       echo "sccess";
    } else {
        // Error inserting bank details
    }
}
   $checkBalance = Control::checkBalance($conn, $user_id, $amount);
   if($checkBalance["status"] === false){
     echo $checkBalance["msg"];
     exit();
   }

    $int = (INT)$amount;
   if($int < 1){
       Control::updateUserPrevilage($conn, $user_id, "RESTRICTED");
       session_destroy();
   }
    $user_id = $_SESSION["user_id"];
   $user = Control::fetchDetail($conn, $user_id);
   if($user["status"] !== "VERIFIED"){
       echo "Your account is ".$user["status"]." you cant perform any action please contact customer care";
       unset($_SESSION["user_id"]);
       exit();
   }
    $checkV = Control::fetchVerification($conn, $user_id);
    if(empty($checkV["bvn"])){
        echo "Please Complete Your BVN Verification To be Enabled To Do Transfer";
  
        exit();
    }

// Determine user tier based on verification status
$user_tier = '';
if (!empty($checkV["nin"]) && !empty($checkV["bvn"])) {
    $user_tier = 'Tier 3';
} elseif (!empty($checkV["bvn"])) {
    $user_tier = 'Tier 2';
} else {
    $user_tier = 'Tier 1';
}

// Define daily limits for each tier
$daily_limits = [
    'Tier 1' => 50000,
    'Tier 2' => 150000,
    'Tier 3' => 250000,
];

// Check single transfer limit
if ($user_tier == 'Tier 1' && $amount > 50000) {
    echo "Maximum single transfer is 50,000. Please upgrade to Tier 2.";
    exit();
} elseif ($user_tier == 'Tier 2' && $amount > 150000) {
    echo "Maximum single transfer is 150,000. Please upgrade to Tier 3.";
    exit();
} elseif ($user_tier == 'Tier 3' && $amount > 250000) {
    echo "Maximum single transfer is 250,000.";
    exit();
}

// Calculate total transferred today
$query = "SELECT SUM(amount) AS total_transferred 
          FROM transaction 
          WHERE unique_id = '$unique_id' AND DATE(date) = CURDATE() AND type='Transfer'";
$result = mysqli_query($conn, $query);
$data = mysqli_fetch_assoc($result);
$total_transferred_today = $data['total_transferred'] ?? 0;

// Get daily limit for user tier
$daily_limit = $daily_limits[$user_tier] ?? 0;

// Check daily transfer limit
if ($total_transferred_today + $amount > $daily_limit) {
    echo "You have exceeded your daily transfer limit of NGN " . number_format($daily_limit, 2) . " for " . $user_tier;
    exit();
}



   $generateId = Control::generateId("CD", 10);
   
   if($ssId === $user_id && $ssId === $user["unique_id"]){
       Control::updateUserPrevilage($conn, $user_id, "RESTRICTED");
       session_destroy();
       echo "Your account has been restricted for trying to initate transfer to yourself";
       exit();
   }
   
   if($bank === "0505"){
      $sendMoney = Api::make_user_transfer($conn, $amount - 10, $ssId);
      if($sendMoney["status"] === true){
          $description = "Wallet funding of ".$amount." from ".$user["fname"]." ".$user["lname"]."(".$user["phone"].") Narraton: ".$narration;
          $sAmt = $amount - 20;
          $sentUser = Control::fetchDetail($conn, $ssId);
          Control::insertTransaction($conn, $ssId, $generateId, "Wallet Topup", $sentUser["phone"], "Cidapay", "success", $sentUser["bal"] - $sAmt, $sentUser["bal"], $sAmt, "", $description, date("D, d-M-Y h:i a"));
      }
   }else{
      $sendMoney = Api::make_transfer($conn, $amount - 20, $bank, $account_no, $narration, $ssId);
   }
   if($sendMoney["status"] == false){
     error_log ($sendMoney["msg"]);
      $description2 = "Bank transfer of NGN ".$amount." to ".$account_name."(".$account_no.") Failed";
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Transfer", $account_no, $account_name, "failed", $user["bal"], $user["bal"] - $amount, $amount, "", $description2, date("D, d-M-Y h:i a"));
     echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/eror.png" alt="success image">
         <h2>Failed</h2>
       </div>
       <table>
         <table>
         <tr>
           <td>Bank</td>
           <td>'.$bank_name.'</td>
         </tr>
         <tr>
           <td>Account Name</td>
           <td>'.$account_name.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
         <tr>
           <td>Reference</td>
           <td>'.$generateId.' <i class="bi bi-copy"></i></td>
         </tr>
       </table>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload()">TRY AGAIN</button>
       </div>
      </div>
    </div>
   ';
  
     exit();
   }
   
   $debit_user = Control::updateBalance($conn, $user_id, "debit", $amount);
   if($debit_user["status"] == false){
     echo $debit_user["msg"];
     exit();
   }
 
 
   $description = "Bank transfer of NGN ".$amount." to ".$account_name."(".$account_no.") at charge of NGN 20";
   
   $insertTransaction = Control::insertTransaction($conn, $user_id, $generateId, "Transfer", $account_no, $account_name, "success", $user["bal"], $user["bal"] - $amount, $amount, "", $description, date("D, d-M-Y h:i a"));
   if($insertTransaction["status"] == false){
     echo $insertTransaction["msg"];
     exit();
   }
   
echo '
    <div class="finish">
      <div class="finish-box">
       <div class="finish-box-head">
         <img src="images/check.png" alt="success image">
         <h2>SUCCESS</h2>
       </div>
       <table>
         <tr>
           <td>Bank</td>
           <td>'.$bank_name.'</td>
         </tr>
         <tr>
           <td>Account Name</td>
           <td>'.$account_name.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
         <tr>
           <td>Reference</td>
           <td>'.$generateId.' <i class="bi bi-copy"></i></td>
         </tr>
       </table>
       <div class="buttons">
         <button class="no-bg" onclick="window.location = `reciept.php?ref='.$generateId.'`;">VIEW RECIEPT</button>
         <button class="bg" onclick="window.location.reload()">SEND AGAIN</button>
       </div>
      </div>
    </div>
   ';
  $site = Control::site($conn);

$msg = '
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Document</title>
  <link href="https://fonts.googleapis.com/css2?family=Mitr:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    *{
      box-sizing: border-box;
      font-family: "Mitr", Sans-Serif;
    }
    .head{
      background: linear-gradient(to left,#3333ff,#3333ff);
      height: 120px;
      color: #fff;
      display: grid;
      grid-template-column: repeat(1, 1fr);
      flex-direction: column;
      padding: 10px;
    }
    .head img{
      width: auto;
      height: 70px;
      object-fit:cover;
      display: block;
    }
    .head b{
      font-size: 22px;
      font-weight: 900;
      display: block;
      margin-top: 0px;
    }
    .bottom{
      background: linear-gradient(to left,#3333ff,#3333ff);
      height: 50px;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .bottom i{
      margin-left: 10px;
      margin-right: 10px;
      font-size: 18px;
    }
    .body{
      padding: 15px;
      background: #0002;
    }
    .scam-alert{
      font-size: 12px;
      color: #555;
    }
    .greet{
      font-size: 15px;
      font-weight: 300;
      color: #000;
      margin-bottom: 20px;
      display: block;
    }
    table{
      margin: 0;
      margin-top: 15px;
      margin-bottom: 15px;
    }
    table tr{
      height: 25px;
      width: 100%;
      padding: 5px;
    }
    table tr td:nth-child(1){
      font-weight: 500;
      font-size: 13px;
      color: #000;
      width: 120px;
    }
    table tr td:nth-child(2){
      font-weight: 500;
      font-size: 13px;
      color: #777;
    }
  </style>
</head>
<body>
  <div class="head">
    <img src="https://'.$_SERVER["HTTP_HOST"].'/app/logos/logo.png" alt="logo">
    <b>NGN '.number_format($amount, 2).'</b>
  </div>
  <div class="body">
    <p class="greet">Dear '.$user["fname"].', Your transfer of <span>NGN '.number_format($amount, 2).'</span>  has been confirmed and the recipient is expected to be credited within 5 minutes.</p>
    
    <table>
      <tr>
        <td>Type</td>
        <td>Transfer</td>
      </tr>
      <tr>
        <td>Amount</td>
        <td>NGN'.$amount.'</td>
      </tr>
       <td>Bank</td>
           <td>'.$bank_name.'</td>
         </tr>
         <tr>
           <td>Account Name</td>
           <td>'.$account_name.'</td>
         </tr>
         <tr>
           <td>Amount</td>
           <td>NGN '.number_format($amount, 2).'</td>
         </tr>
         <tr>
           <td>Reference</td>
           <td>'.$generateId.' <i class="bi bi-copy"></i></td>
         </tr>
         <tr>
        <td>Date</td>
        <td>'.date("D d-M-Y h:i a").'</td>
      </tr>
    </table>
    
    <div class="scam-alert">If this wasnt done by you <a href="https://'.$_SERVER["HTTP_HOST"].'/app/login.php">Login</a> to reset your password and also contact support for help at <a href="'.$site["support_email"].'">'.$site["support_email"].'</a>. Thank you for using '.$site["site_name"].'</div>
  </div>
  <div class="bottom">
    <i class="fab fa-facebook"></i>
    <i class="fab fa-whatsapp"></i>
    <i class="fab fa-instagram"></i>
  </div>
</body>
</html>
';

 sendOtpMail($conn, $user["unique_id"], $user["email"], "Transfer Succesful", $msg, "Email notification send successfully");
 }   
?>
