<?php
 session_start();
 include_once "conn.php";
 include "controller.php";
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
   echo "Invalid request method only post method allowed";
   exit();
 }
 
 if(!isset($_SESSION["pin-reset-code"])){
   echo "Otp code not sent send otp code to be able to verify code and reset password";
   exit();
 }
 
 $email = validate::validateEmail($conn, $_POST["email"]);
 $code = validate::validateInt($conn, $_POST["otp-code"]);
 $new_pin = validate::validateInt($conn, $_POST["r-new-pin"]);
 
 $sent_code = $_SESSION["pin-reset-code"];
 
 if(strval($code) !== strval($sent_code)){
   echo "Incorrect otp code please check the code and try again".$code;
   exit();
 }
 
 $checkUser = Control::fetchDetail($conn, $email);
 if($checkUser["status"] === false){
   echo "Invalid email user does not exist please enter a valid email";
   exit();
 }
 
 $update_password = Control::updatePin($conn, $checkUser["unique_id"], $new_pin);
 echo "PIN has been reset successfully";
 session_destroy();
?>