<?php
 session_start();
 include_once "conn.php";
 include "controller.php";
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
   echo "Invalid request method only post method allowed";
   exit();
 }
 
 if(!isset($_SESSION["reset-code"])){
   echo "Otp code not sent send otp code to be able to verify code and reset password";
   exit();
 }
 
 $email = validate::validateEmail($conn, $_POST["email"]);
 $code = validate::validateInt($conn, $_POST["code"]);
 $new_password = validate::validatePassword($conn, $_POST["password"]);
 
 $sent_code = $_SESSION["reset-code"];
 
 if(strval($code) !== strval($sent_code)){
   echo "Incorrect otp code please check the code and try again".$code;
   exit();
 }
 
 $checkUser = Control::fetchDetail($conn, $email);
 if($checkUser["status"] === false){
   echo "Invalid email user does not exist please enter a valid email";
   exit();
 }
 
 $update_password = Control::updatePassword($conn, $checkUser["unique_id"], $new_password);
 echo "Password has been reset successfully you can now login";
 session_destroy();
?>