<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "mail.php";
 
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
   echo "Invalid server request method";
   exit();
 }
 
 if(!isset($_SESSION["pin_verify"])){
   echo "Something went wrong please go back and restart login process";
   exit();
 }
 
 $user_id = $_SESSION["pin_verify"];
 $user = Control::fetchDetail($conn, $user_id);
 if($user["status"] === false){
   echo $user["msg"];
   session_destroy();
   exit();
 }
 
 $data = json_decode(file_get_contents("php://input"), true);
 if(!isset($data["pins"]) && !isset($data["type"])){
   echo "Invalid request send please check and try again";
   exit();
 }
 
 if($data["type"] === "pin-login"){
     if($data["pins"] < 4){
         echo "Please enter your 4 digit pin to continue login";
         exit();
     }
     
     $checkPin = Control::checkPin($conn, $user["unique_id"], $data["pins"]);
     if($checkPin["status"] !== true){
       echo $checkPin["msg"];
       exit();
     }
 }
 
 if($user["status"] !== "VERIFIED"){
     echo "User account has been ".$user["status"]." please contact customer support if this was an error.";
     exit();
 }
 
 unset($_SESSION["pin_verify"]);
 $_SESSION["user_id"] = $user["unique_id"];
 echo "Login successful";
 
 
function getUserIpAddr() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    
    return $ip;
}

$site = Control::site($conn);
$addr = getUserIpAddr();

$msg = '
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Document</title>
  <link href="https://fonts.googleapis.com/css2?family=Mitr:wght@300;400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    *{
      box-sizing: border-box;
      font-family: "Mitr", Sans-Serif;
    }
    .head{
      background:  linear-gradient(to left,#ff8000,#0000ff);
      height: 120px;
      color: #fff;
      display: grid;
      grid-template-column: repeat(1, 1fr);
      flex-direction: column;
      padding: 10px;
    }
    .head img{
      width: auto;
      height: 70px;
      object-fit:cover;
      display: block;
    }
    .head b{
      font-size: 22px;
      font-weight: 900;
      display: block;
      margin-top: 0px;
    }
    .bottom{
      background: linear-gradient(to left,#ff8000,#0000ff);
      height: 50px;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .bottom i{
      margin-left: 10px;
      margin-right: 10px;
      font-size: 18px;
    }
    .body{
      padding: 15px;
      background: #0002;
    }
    .scam-alert{
      font-size: 12px;
      color: #555;
    }
    .greet{
      font-size: 16px;
      font-weight: 900;
      color: #000;
      margin-bottom: 20px;
      display: block;
    }
    table{
      margin: 0;
      margin-top: 15px;
      margin-bottom: 15px;
    }
    table tr{
      height: 15px;
      width: 100%;
      padding: 5px;
    }
    table tr td:nth-child(1){
      font-weight: 900;
      font-size: 14px;
      color: #000;
      width: 300px;
      padding-right: 40px;
    }
    table tr td:nth-child(2){
      font-weight: 300;
      font-size: 13px;
      color: #777;
      width: 50%;
    }
  </style>
</head>
<body>
  <div class="head">
    <img src="https://'.$_SERVER["HTTP_HOST"].'/app/logos/logo.png" alt="logo">
    <b>Login Notification</b>
  </div>
  <div class="body">
    <b class="greet">Hello, '.($user["acc_type"] === "wallet" ? $user["fname"] : $user["bs_name"]).'</b>
    
    <p>Hello '.$user["fname"].', did you just login your '.$site["site_name"].' Personal account</p>
    
    <table>
      <tr>
        <td>Ip address</td>
        <td>'.$addr.'</td>
      </tr>
      <tr>
        <td>Date</td>
        <td>'.date("D d-M-Y h:i a").'</td>
      </tr>
    </table>
    
    <div class="scam-alert">If this wasnt done by you <a href="https://'.$_SERVER["HTTP_HOST"].'/app/login.php">Login</a> to reset your password and also contact support for help at <a href="mail: '.$site["support_email"].'">'.$site["support_email"].'</a>. Thank you for using '.$site["site_name"].'</div>
  </div>
  <div class="bottom">
    <i class="fab fa-facebook"></i>
    <i class="fab fa-whatsapp"></i>
    <i class="fab fa-instagram"></i>
  </div>
</body>
</html>
';

 sendOtpMail($conn, $user["unique_id"], $user["email"], "Login Notificaton", $msg, "Email notification send successfully");
?>