<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 
 date_default_timezone_set("Africa/Lagos");
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo "Invalid server request method";
     exit();
 }
 
   $user_id = validate::validateString($conn, $_POST["user_id"]);
   $amount = validate::validateInt($conn, $_POST["amount"]);
   $type = "dynamic";
   
   $user = Control::fetchDetail($conn, $user_id);
   if($user["status"] === false){
       echo $user["msg"];
       exit();
   }
   
   $generate_acc = Api::generate_ncwallet($conn, $user["fname"].' '.$user["lname"], $user["email"], $user["phone"], $type, "safehaven", "", $amount);
   If($generate_acc["status"] !== true){
       echo $generate_acc["msg"];
       exit();
   }
   
   echo '
   <div>
    <p style="
      display: block;
      margin: 0;
      margin-bottom: 20px;
      font-size: 11px;
      font-weight: 900;
      color: #444;
      text-align: center;
    ">Kindly Transfer NGN '.number_format($amount).' to the account below:</p>
    
    <div style="
       padding: 25px;
       background: rgba(70%, 0%, 50%, 0.1);
       color: rgba(70%, 0%, 50%);
       width: 100%;
       border-radius: 6px;
       display: flex;
       margin-right: 20px;
       align-items: center;
       justify-content: center;
       font-size: 13px;
    ">
      <div>
        <span style="
          display: block;
          margin: 0;
          color: #333;
          font-size: 11px;
          font-weigth: 900;
        ">'.$generate_acc["bank_name"].'</span>
        
        <b style="
          display: block;
          margin: 0;
          color: #000;
          font-size: 14px;
          margin-top: 5px;
        ">'.$generate_acc["account_no"].'</b>
      </div>
      <i class="fas fa-copy" onclick="copyTxt(`'.$generate_acc["account_no"].'`)"></i>
    </div>
    <button type="button" class="pay-btn" style="width: 100%; margin-top: 10px;" onclick="verifyFund(this, `'.$generate_acc["account_no"].'`)">I have sent the money</button>
   </div>
   ';
?>