<?php
ini_set('display_errors',1);
error_reporting(E_ALL);
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 validate::checkSession();

 $user_id = $_SESSION["user_id"];
  $checkV = Control::fetchVerification($conn, $user_id);
 date_default_timezone_set("Africa/Lagos");
 
 if($_SERVER["REQUEST_METHOD"] === "POST"){
   $user = Control::fetchDetail($conn, $user_id);
   $bank_code = validate::validateInt($conn, $_POST["account"]);
   
   if(empty($bank_code)){
     echo "Err! Please select account";
     exit();
   }
   
   
   $sel = $conn->prepare("SELECT * FROM account WHERE unique_id = ?");
   $sel->bind_param("s", $user_id);
   $sel->execute();
   $res2 = $sel->get_result();
   if($res2->num_rows > 0){
       while($rw = $res2->fetch_assoc()){
           if($rw["bank_code"] === $bank_code){
               echo "Hello ".$user["fname"].", you already have selected account";
               exit();
           }
       }
   }
   
   
   $generate_acc = "";
   if($bank_code === '100003'){
     $generate_acc = Api::generate_strowallet($conn, "Paga", $user["fname"].' '.$user["lname"], $user["email"], $user["phone"]);
   }else if($bank_code === '090286'){
     $generate_acc = Api::generate_strowallet($conn, "Safe-Haven", $user["fname"].' '.$user["lname"], $user["email"], $user["phone"]);
   }else if($bank_code === '090529'){
     $generate_acc = Api::generate_strowallet($conn, "Bankly", $user["fname"].' '.$user["lname"], $user["email"], $user["phone"]);
   }else if($bank_code === '000023'){
     $generate_acc = Api::generate_ncwallet($conn, $user["fname"].' '.$user["lname"], $user["email"], $user["phone"], "static", "providus", $checkV["bvn"], "");
   }else if($bank_code === '120001'){
     $generate_acc = Api::generate_payvessel($conn, $bank_code, "STATIC", $user["fname"].' '.$user["lname"], $user["email"], $user["phone"]);
   }
   
   
   if($generate_acc["status"] !== true){
       echo json_encode($generate_acc);
       exit();
   }else{
       //echo json_encode($generate_acc);
       $empty = "";
       $sql = $conn->prepare("INSERT INTO account (unique_id, email, acc_name, acc_no, bank_name, bank_code, reference, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
       $sql->bind_param("ssssssss", $user_id, $user["email"], $generate_acc["account_name"], $generate_acc["account_no"], $generate_acc["bank_name"], $bank_code, $empty, date("D d-M-Y h:i a"));
       $sql->execute();
       
       echo "Account generated successfully";
       exit();
   }
 }
?>