<?php
 session_start();
 include_once "conn.php";
 require "controller.php";
 require "api_call.php";
 validate::checkSession();
 
 $user_id = $_SESSION["user_id"];
 
 date_default_timezone_set("Africa/Lagos");
 
 if($_SERVER["REQUEST_METHOD"] !== "POST"){
     echo 'Invalid server request method';
     exit();
 }
 
 $user = Control::fetchDetail($conn, $user_id);
 if($user["status"] === false){
     echo $user["msg"];
     exit();
 }
 
 $currency = validate::validateString($conn, $_POST["card-fund-currency"]);
 $cId = validate::validateString($conn, $_POST["card-id"]);
 $amount = validate::validateInt($conn, $_POST["fund-card-amount"]);
 
 $checkV = Control::fetchVerification($conn, $user_id);
 if(empty($checkV["bvn"])){
    echo "PLease complete your bvn verification to be able to create card";
    exit();
 }
 
 $checkB = Control::checkBalance($conn, $user_id, $amount);
 if($checkB["status"] !== true){
     echo $checkB["msg"];
     exit();
 }
 
 $fundCard = Api::fund_card($conn, $cId, $amount);
 if($fundCard["status"] !== true){
     echo $fundCard["msg"];
     exit();
 }
 
 Control::updateBalance($conn, $user_id, "debit", $amount);
 echo $fundCard["msg"];
?>